/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal.remote;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.tmatesoft.hg.auth.HgAuthFailedException;
import org.tmatesoft.hg.auth.HgAuthMethod;
import org.tmatesoft.hg.core.HgRemoteConnectionException;
import org.tmatesoft.hg.core.SessionContext;
import org.tmatesoft.hg.repo.HgInvalidStateException;
import org.tmatesoft.hg.util.LogFacility;

public class HttpAuthMethod
implements HgAuthMethod {
    private final SessionContext ctx;
    private final URL url;
    private String authInfo;
    private SSLContext sslContext;

    HttpAuthMethod(SessionContext sessionContext, URL url) throws HgRemoteConnectionException {
        this.ctx = sessionContext;
        if (!"http".equals(url.getProtocol()) && !"https".equals(url.getProtocol())) {
            throw new HgInvalidStateException(String.format("http protocol expected: %s", url.toString()));
        }
        this.url = url;
        if ("https".equals(url.getProtocol())) {
            try {
                this.sslContext = SSLContext.getInstance("SSL");
                class TrustEveryone
                implements X509TrustManager {
                    TrustEveryone() {
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return new X509Certificate[0];
                    }
                }
                this.sslContext.init(null, new TrustManager[]{new TrustEveryone()}, null);
            }
            catch (Exception ex) {
                throw new HgRemoteConnectionException("Can't initialize secure connection", ex);
            }
        } else {
            this.sslContext = null;
        }
    }

    public void tryWithUserInfo(String uriUserInfo) throws HgAuthFailedException {
        int colon = uriUserInfo.indexOf(58);
        if (colon == -1) {
            this.withPassword(uriUserInfo, null);
        } else {
            this.withPassword(uriUserInfo.substring(0, colon), uriUserInfo.substring(colon + 1));
        }
    }

    @Override
    public void noCredentials() throws HgAuthFailedException {
        this.checkConnection();
    }

    @Override
    public boolean supportsPassword() {
        return true;
    }

    @Override
    public void withPassword(String username, String password) throws HgAuthFailedException {
        this.authInfo = this.buildAuthValue(username, password == null ? "" : password);
        this.checkConnection();
    }

    @Override
    public boolean supportsPublicKey() {
        return false;
    }

    @Override
    public void withPublicKey(String username, InputStream privateKey, String passphrase) throws HgAuthFailedException {
    }

    @Override
    public boolean supportsCertificate() {
        return "https".equals(this.url.getProtocol());
    }

    @Override
    public void withCertificate(X509Certificate[] clientCert) throws HgAuthFailedException {
        this.checkConnection();
    }

    private void checkConnection() throws HgAuthFailedException {
        HttpURLConnection c = null;
        try {
            try {
                c = (HttpURLConnection)this.url.openConnection();
                c = this.setupConnection(c);
                c.connect();
                InputStream is = c.getInputStream();
                while (is.read() != -1) {
                }
                is.close();
                if (c.getResponseCode() == 401) {
                    throw new HgAuthFailedException(c.getResponseMessage(), null);
                }
            }
            catch (IOException ex) {
                throw new HgAuthFailedException("Communication failure while authenticating", ex);
            }
        }
        finally {
            if (c != null) {
                c.disconnect();
            }
        }
    }

    HttpURLConnection setupConnection(HttpURLConnection urlConnection) {
        if (this.authInfo != null) {
            urlConnection.addRequestProperty("Authorization", "Basic " + this.authInfo);
        }
        if (this.sslContext != null) {
            ((HttpsURLConnection)urlConnection).setSSLSocketFactory(this.sslContext.getSocketFactory());
        }
        return urlConnection;
    }

    private String buildAuthValue(String username, String password) {
        String ai = null;
        try {
            Preferences tempNode = Preferences.userRoot().node("xxx");
            tempNode.putByteArray("xxx", String.format("%s:%s", username, password).getBytes());
            ai = tempNode.get("xxx", null);
            tempNode.removeNode();
        }
        catch (BackingStoreException ex) {
            this.ctx.getLog().dump(this.getClass(), LogFacility.Severity.Info, ex, null);
        }
        return ai;
    }
}

