/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal.remote;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.tmatesoft.hg.auth.HgAuthFailedException;
import org.tmatesoft.hg.auth.HgAuthenticator;
import org.tmatesoft.hg.core.HgRemoteConnectionException;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.core.SessionContext;
import org.tmatesoft.hg.internal.PropertyMarshal;
import org.tmatesoft.hg.internal.remote.ConnectorBase;
import org.tmatesoft.hg.internal.remote.HttpAuthMethod;
import org.tmatesoft.hg.repo.HgRemoteRepository;
import org.tmatesoft.hg.repo.HgRuntimeException;

public class HttpConnector
extends ConnectorBase {
    private HgRemoteRepository.RemoteDescriptor rd;
    private URL url;
    private boolean debug;
    private SessionContext sessionCtx;
    private HttpURLConnection conn;
    private HttpAuthMethod authMediator;

    @Override
    public void init(HgRemoteRepository.RemoteDescriptor remote, SessionContext sessionContext, Object globalConfig) throws HgRuntimeException {
        this.rd = remote;
        this.setURI(remote.getURI());
        this.sessionCtx = sessionContext;
        this.debug = new PropertyMarshal(sessionContext).getBoolean("hg4j.remote.debug", false);
    }

    @Override
    public void connect() throws HgAuthFailedException, HgRemoteConnectionException, HgRuntimeException {
        try {
            this.url = this.uri.toURL();
        }
        catch (MalformedURLException ex) {
            throw new HgRemoteConnectionException("Bad URL", ex);
        }
        this.authMediator = new HttpAuthMethod(this.sessionCtx, this.url);
        this.authenticateClient();
    }

    private void authenticateClient() throws HgAuthFailedException {
        String userInfo = this.url.getUserInfo();
        if (userInfo != null) {
            try {
                this.authMediator.tryWithUserInfo(userInfo);
            }
            catch (HgAuthFailedException hgAuthFailedException) {}
        }
        HgAuthenticator auth = this.sessionCtx.getAuthenticator(this.rd);
        auth.authenticate(this.rd, this.authMediator);
    }

    @Override
    public void disconnect() throws HgRemoteConnectionException, HgRuntimeException {
    }

    @Override
    public void sessionBegin() throws HgRemoteConnectionException, HgRuntimeException {
    }

    @Override
    public void sessionEnd() throws HgRemoteConnectionException, HgRuntimeException {
        if (this.conn != null) {
            this.conn.disconnect();
            this.conn = null;
        }
    }

    @Override
    public String getCapabilities() throws HgRemoteConnectionException {
        try {
            URL u = new URL(this.url, String.valueOf(this.url.getPath()) + "?cmd=hello");
            HttpURLConnection c = this.setupConnection(u.openConnection());
            c.connect();
            if (this.debug) {
                this.dumpResponseHeader(u);
            }
            BufferedReader r = new BufferedReader(new InputStreamReader(c.getInputStream(), "US-ASCII"));
            String line = r.readLine();
            c.disconnect();
            if (line != null && line.startsWith("capabilities:")) {
                return line.substring("capabilities:".length()).trim();
            }
            u = new URL(this.url, String.valueOf(this.url.getPath()) + "?cmd=capabilities");
            c = this.setupConnection(u.openConnection());
            c.connect();
            if (this.debug) {
                this.dumpResponseHeader(u);
            }
            r = new BufferedReader(new InputStreamReader(c.getInputStream(), "US-ASCII"));
            line = r.readLine();
            c.disconnect();
            if (line != null && line.startsWith("capabilities:")) {
                return line.substring("capabilities:".length()).trim();
            }
            return new String();
        }
        catch (MalformedURLException ex) {
            throw new HgRemoteConnectionException("Bad URL", ex).setRemoteCommand("hello").setServerInfo(this.getServerLocation());
        }
        catch (IOException ex) {
            throw new HgRemoteConnectionException("Communication failure", ex).setRemoteCommand("hello").setServerInfo(this.getServerLocation());
        }
    }

    @Override
    public InputStream heads() throws HgRemoteConnectionException, HgRuntimeException {
        try {
            URL u = new URL(this.url, String.valueOf(this.url.getPath()) + "?cmd=heads");
            this.conn = this.setupConnection(u.openConnection());
            this.conn.connect();
            if (this.debug) {
                this.dumpResponseHeader(u);
            }
            return this.conn.getInputStream();
        }
        catch (MalformedURLException ex) {
            throw new HgRemoteConnectionException("Bad URL", ex).setRemoteCommand("heads").setServerInfo(this.getServerLocation());
        }
        catch (IOException ex) {
            throw new HgRemoteConnectionException("Communication failure", ex).setRemoteCommand("heads").setServerInfo(this.getServerLocation());
        }
    }

    @Override
    public InputStream between(Collection<HgRemoteRepository.Range> ranges) throws HgRemoteConnectionException, HgRuntimeException {
        StringBuilder sb = new StringBuilder(20 + ranges.size() * 82);
        sb.append("pairs=");
        for (HgRemoteRepository.Range r : ranges) {
            r.append(sb);
            sb.append('+');
        }
        if (sb.charAt(sb.length() - 1) == '+') {
            sb.setLength(sb.length() - 1);
        }
        try {
            boolean usePOST = ranges.size() > 3;
            URL u = new URL(this.url, String.valueOf(this.url.getPath()) + "?cmd=between" + (usePOST ? "" : String.valueOf('&') + sb.toString()));
            this.conn = this.setupConnection(u.openConnection());
            if (usePOST) {
                this.conn.setRequestMethod("POST");
                this.conn.setRequestProperty("Content-Length", String.valueOf(sb.length()));
                this.conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                this.conn.setDoOutput(true);
                this.conn.connect();
                OutputStream os = this.conn.getOutputStream();
                os.write(sb.toString().getBytes());
                os.flush();
                os.close();
            } else {
                this.conn.connect();
            }
            if (this.debug) {
                System.out.printf("%d ranges, method:%s \n", ranges.size(), this.conn.getRequestMethod());
                this.dumpResponseHeader(u);
            }
            return this.conn.getInputStream();
        }
        catch (MalformedURLException ex) {
            throw new HgRemoteConnectionException("Bad URL", ex).setRemoteCommand("between").setServerInfo(this.getServerLocation());
        }
        catch (IOException ex) {
            throw new HgRemoteConnectionException("Communication failure", ex).setRemoteCommand("between").setServerInfo(this.getServerLocation());
        }
    }

    @Override
    public InputStream branches(List<Nodeid> nodes) throws HgRemoteConnectionException, HgRuntimeException {
        StringBuilder sb = this.appendNodeidListArgument("nodes", nodes, null);
        try {
            URL u = new URL(this.url, String.valueOf(this.url.getPath()) + "?cmd=branches&" + sb.toString());
            this.conn = this.setupConnection(u.openConnection());
            this.conn.connect();
            if (this.debug) {
                this.dumpResponseHeader(u);
            }
            return this.conn.getInputStream();
        }
        catch (MalformedURLException ex) {
            throw new HgRemoteConnectionException("Bad URL", ex).setRemoteCommand("branches").setServerInfo(this.getServerLocation());
        }
        catch (IOException ex) {
            throw new HgRemoteConnectionException("Communication failure", ex).setRemoteCommand("branches").setServerInfo(this.getServerLocation());
        }
    }

    @Override
    public InputStream changegroup(List<Nodeid> roots) throws HgRemoteConnectionException, HgRuntimeException {
        StringBuilder sb = this.appendNodeidListArgument("roots", roots, null);
        try {
            URL u = new URL(this.url, String.valueOf(this.url.getPath()) + "?cmd=changegroup&" + sb.toString());
            this.conn = this.setupConnection(u.openConnection());
            this.conn.connect();
            if (this.debug) {
                this.dumpResponseHeader(u);
            }
            InputStream cg = this.conn.getInputStream();
            ByteArrayInputStream prefix = new ByteArrayInputStream("HG10GZ".getBytes());
            return new SequenceInputStream(prefix, cg);
        }
        catch (MalformedURLException ex) {
            throw new HgRemoteConnectionException("Bad URL", ex).setRemoteCommand("changegroup").setServerInfo(this.getServerLocation());
        }
        catch (IOException ex) {
            throw new HgRemoteConnectionException("Communication failure", ex).setRemoteCommand("changegroup").setServerInfo(this.getServerLocation());
        }
    }

    @Override
    public OutputStream unbundle(long outputLen, List<Nodeid> remoteHeads) throws HgRemoteConnectionException, HgRuntimeException {
        StringBuilder sb = this.appendNodeidListArgument("heads", remoteHeads, null);
        try {
            final URL u = new URL(this.url, String.valueOf(this.url.getPath()) + "?cmd=unbundle&" + sb.toString());
            this.conn = this.setupConnection(u.openConnection());
            this.conn.setRequestMethod("POST");
            this.conn.setDoOutput(true);
            this.conn.setRequestProperty("Content-Type", "application/mercurial-0.1");
            this.conn.setRequestProperty("Content-Length", String.valueOf(outputLen));
            this.conn.connect();
            return new FilterOutputStream(this.conn.getOutputStream()){

                @Override
                public void close() throws IOException {
                    super.close();
                    if (HttpConnector.this.debug) {
                        HttpConnector.this.dumpResponseHeader(u);
                    }
                    try {
                        HttpConnector.this.checkResponseOk("Push", "unbundle");
                    }
                    catch (HgRemoteConnectionException ex) {
                        IOException e = new IOException(ex.getMessage());
                        e.setStackTrace(ex.getStackTrace());
                        throw e;
                    }
                }
            };
        }
        catch (MalformedURLException ex) {
            throw new HgRemoteConnectionException("Bad URL", ex).setRemoteCommand("unbundle").setServerInfo(this.getServerLocation());
        }
        catch (IOException ex) {
            throw new HgRemoteConnectionException("Communication failure", ex).setRemoteCommand("unbundle").setServerInfo(this.getServerLocation());
        }
    }

    @Override
    public InputStream pushkey(String opName, String namespace, String key, String oldValue, String newValue) throws HgRemoteConnectionException, HgRuntimeException {
        try {
            String p = String.format("%s?cmd=pushkey&namespace=%s&key=%s&old=%s&new=%s", this.url.getPath(), namespace, key, oldValue, newValue);
            URL u = new URL(this.url, p);
            this.conn = this.setupConnection(u.openConnection());
            this.conn.setRequestMethod("POST");
            this.conn.connect();
            if (this.debug) {
                this.dumpResponseHeader(u);
            }
            this.checkResponseOk(opName, "pushkey");
            return this.conn.getInputStream();
        }
        catch (MalformedURLException ex) {
            throw new HgRemoteConnectionException("Bad URL", ex).setRemoteCommand("pushkey").setServerInfo(this.getServerLocation());
        }
        catch (IOException ex) {
            throw new HgRemoteConnectionException("Communication failure", ex).setRemoteCommand("pushkey").setServerInfo(this.getServerLocation());
        }
    }

    @Override
    public InputStream listkeys(String namespace, String actionName) throws HgRemoteConnectionException, HgRuntimeException {
        try {
            URL u = new URL(this.url, String.valueOf(this.url.getPath()) + "?cmd=listkeys&namespace=" + namespace);
            this.conn = this.setupConnection(u.openConnection());
            this.conn.connect();
            if (this.debug) {
                this.dumpResponseHeader(u);
            }
            this.checkResponseOk(actionName, "listkeys");
            return this.conn.getInputStream();
        }
        catch (MalformedURLException ex) {
            throw new HgRemoteConnectionException("Bad URL", ex).setRemoteCommand("listkeys").setServerInfo(this.getServerLocation());
        }
        catch (IOException ex) {
            throw new HgRemoteConnectionException("Communication failure", ex).setRemoteCommand("listkeys").setServerInfo(this.getServerLocation());
        }
    }

    private void checkResponseOk(String opName, String remoteCmd) throws HgRemoteConnectionException, IOException {
        if (this.conn.getResponseCode() != 200) {
            String m = this.conn.getResponseMessage() == null ? "unknown reason" : this.conn.getResponseMessage();
            String em = String.format("%s failed: %s (HTTP error:%d)", opName, m, this.conn.getResponseCode());
            throw new HgRemoteConnectionException(em).setRemoteCommand(remoteCmd).setServerInfo(this.getServerLocation());
        }
    }

    private HttpURLConnection setupConnection(URLConnection urlConnection) {
        urlConnection.setRequestProperty("User-Agent", "hg4j/1.0.0");
        urlConnection.addRequestProperty("Accept", "application/mercurial-0.1");
        return this.authMediator.setupConnection((HttpURLConnection)urlConnection);
    }

    private StringBuilder appendNodeidListArgument(String key, List<Nodeid> values, StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder(20 + values.size() * 41);
        }
        sb.append(key);
        sb.append('=');
        for (Nodeid n : values) {
            sb.append(n.toString());
            sb.append('+');
        }
        if (sb.charAt(sb.length() - 1) == '+') {
            sb.setLength(sb.length() - 1);
        }
        return sb;
    }

    private void dumpResponseHeader(URL u) {
        System.out.printf("Query (%d bytes):%s\n", u.getQuery().length(), u.getQuery());
        System.out.println("Response headers:");
        Map<String, List<String>> headerFields = this.conn.getHeaderFields();
        for (String s : headerFields.keySet()) {
            System.out.printf("%s: %s\n", s, this.conn.getHeaderField(s));
        }
    }
}

