/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal.remote;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.tmatesoft.hg.core.HgBadArgumentException;
import org.tmatesoft.hg.core.SessionContext;
import org.tmatesoft.hg.internal.remote.Connector;
import org.tmatesoft.hg.internal.remote.HttpConnector;
import org.tmatesoft.hg.repo.HgRemoteRepository;
import org.tmatesoft.hg.util.Pair;

public class RemoteConnectorDescriptor
implements HgRemoteRepository.RemoteDescriptor {
    private Map<String, Pair<ClassLoader, String>> connFactory;
    private final URI uri;

    public RemoteConnectorDescriptor(Map<String, Pair<ClassLoader, String>> scheme2connectorMap, URI uriRemote) {
        this(uriRemote);
        this.connFactory = scheme2connectorMap;
    }

    protected RemoteConnectorDescriptor(URI uriRemote) {
        this.uri = uriRemote;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    public Connector createConnector() throws HgBadArgumentException {
        Pair<ClassLoader, String> connectorToBe = this.connFactory.get(this.uri.getScheme());
        if (connectorToBe == null || connectorToBe.second() == null) {
            throw new HgBadArgumentException(String.format("Can't instantiate connector for scheme '%s'", this.uri.getScheme()), null);
        }
        try {
            Class<?> connClass = connectorToBe.first().loadClass(connectorToBe.second());
            if (!Connector.class.isAssignableFrom(connClass)) {
                throw new HgBadArgumentException(String.format("Connector %s for scheme '%s' is not a subclass of %s", connectorToBe.second(), this.uri.getScheme(), Connector.class.getName()), null);
            }
            Object connector = connClass.newInstance();
            return (Connector)Connector.class.cast(connector);
        }
        catch (ClassNotFoundException ex) {
            throw new HgBadArgumentException(String.format("Can't instantiate connector %s for scheme '%s'", connectorToBe.second(), this.uri.getScheme()), ex);
        }
        catch (InstantiationException ex) {
            throw new HgBadArgumentException(String.format("Can't instantiate connector %s for scheme '%s'", connectorToBe.second(), this.uri.getScheme()), ex);
        }
        catch (IllegalAccessException ex) {
            throw new HgBadArgumentException(String.format("Can't instantiate connector %s for scheme '%s'", connectorToBe.second(), this.uri.getScheme()), ex);
        }
    }

    public static class Provider {
        private final Map<String, Pair<ClassLoader, String>> knownConnectors = new HashMap<String, Pair<ClassLoader, String>>(5);

        public Provider() {
            ClassLoader cl = Provider.class.getClassLoader();
            this.knownConnectors.put("http", new Pair<ClassLoader, String>(cl, HttpConnector.class.getName()));
            this.knownConnectors.put("https", new Pair<ClassLoader, String>(cl, HttpConnector.class.getName()));
            this.knownConnectors.put("ssh", new Pair<ClassLoader, String>(cl, "org.tmatesoft.hg.internal.remote.SshConnector"));
        }

        public HgRemoteRepository.RemoteDescriptor get(SessionContext ctx, URI uri) {
            if (this.knownConnectors.containsKey(uri.getScheme())) {
                return new RemoteConnectorDescriptor(this.knownConnectors, uri);
            }
            return null;
        }
    }
}

