/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal.remote;

import com.trilead.ssh2.Connection;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import org.tmatesoft.hg.auth.HgAuthFailedException;
import org.tmatesoft.hg.auth.HgAuthMethod;

public final class SshAuthMethod
implements HgAuthMethod {
    private final Connection conn;

    public SshAuthMethod(Connection connection) {
        this.conn = connection;
    }

    public void tryWithUserInfo(String uriUserInfo) throws HgAuthFailedException {
        assert (uriUserInfo != null && uriUserInfo.trim().length() > 0);
        int colon = uriUserInfo.indexOf(58);
        if (colon == -1) {
            String username = uriUserInfo;
            this.withPassword(username, null);
        } else {
            String username = uriUserInfo.substring(0, colon);
            String password = uriUserInfo.substring(colon + 1);
            this.withPassword(username, password);
        }
    }

    @Override
    public void noCredentials() throws HgAuthFailedException {
        try {
            String username = System.getProperty("user.name");
            if (!this.conn.authenticateWithNone(username)) {
                throw this.authFailed(username);
            }
        }
        catch (IOException ex) {
            throw this.commFailed(ex);
        }
    }

    @Override
    public void withPublicKey(String username, InputStream privateKey, String passphrase) throws HgAuthFailedException {
        if (username == null) {
            throw new HgAuthFailedException("Need username", null);
        }
        if (privateKey == null) {
            throw new HgAuthFailedException("Need private key", null);
        }
        CharArrayWriter a = new CharArrayWriter(2048);
        try {
            int r;
            while ((r = privateKey.read()) != -1) {
                a.append((char)r);
            }
        }
        catch (IOException ex) {
            throw new HgAuthFailedException("Failed to read private key", ex);
        }
        try {
            boolean success = this.conn.authenticateWithPublicKey(username, a.toCharArray(), passphrase);
            if (!success) {
                throw this.authFailed(username);
            }
        }
        catch (IOException ex) {
            throw this.commFailed(ex);
        }
    }

    @Override
    public void withPassword(String username, String password) throws HgAuthFailedException {
        if (username == null) {
            throw new HgAuthFailedException("Need username", null);
        }
        try {
            boolean success = password == null ? this.conn.authenticateWithNone(username) : this.conn.authenticateWithPassword(username, password);
            if (!success) {
                throw this.authFailed(username);
            }
        }
        catch (IOException ex) {
            throw this.commFailed(ex);
        }
    }

    @Override
    public void withCertificate(X509Certificate[] clientCert) throws HgAuthFailedException {
    }

    @Override
    public boolean supportsPublicKey() {
        return true;
    }

    @Override
    public boolean supportsPassword() {
        return true;
    }

    @Override
    public boolean supportsCertificate() {
        return true;
    }

    private HgAuthFailedException commFailed(IOException ex) {
        return new HgAuthFailedException("Communication failure while authenticating", ex);
    }

    private HgAuthFailedException authFailed(String username) throws IOException {
        Object[] authMethodsLeft = this.conn.getRemainingAuthMethods(username);
        return new HgAuthFailedException(String.format("Failed to authenticate, other methods to try: %s", Arrays.toString(authMethodsLeft)), null);
    }
}

