/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.internal.remote;

import com.trilead.ssh2.Connection;
import com.trilead.ssh2.Session;
import com.trilead.ssh2.StreamGobbler;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.tmatesoft.hg.auth.HgAuthFailedException;
import org.tmatesoft.hg.auth.HgAuthenticator;
import org.tmatesoft.hg.core.HgRemoteConnectionException;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.core.SessionContext;
import org.tmatesoft.hg.internal.remote.ConnectorBase;
import org.tmatesoft.hg.internal.remote.SshAuthMethod;
import org.tmatesoft.hg.repo.HgRemoteRepository;
import org.tmatesoft.hg.repo.HgRuntimeException;
import org.tmatesoft.hg.util.LogFacility;

public class SshConnector
extends ConnectorBase {
    private HgRemoteRepository.RemoteDescriptor rd;
    private SessionContext sessionCtx;
    private Connection conn;
    private Session session;
    private int sessionUse;
    private StreamGobbler remoteErr;
    private StreamGobbler remoteOut;
    private OutputStream remoteIn;

    @Override
    public void init(HgRemoteRepository.RemoteDescriptor remote, SessionContext sessionContext, Object globalConfig) throws HgRuntimeException {
        this.rd = remote;
        this.sessionCtx = sessionContext;
        this.setURI(remote.getURI());
    }

    @Override
    public void connect() throws HgAuthFailedException, HgRemoteConnectionException, HgRuntimeException {
        try {
            this.conn = new Connection(this.uri.getHost(), this.uri.getPort() == -1 ? 22 : this.uri.getPort());
            this.conn.connect();
            this.authenticateClient();
        }
        catch (IOException iOException) {
            throw new HgRemoteConnectionException("Failed to establish connection").setServerInfo(this.getServerLocation());
        }
    }

    private void authenticateClient() throws HgAuthFailedException {
        SshAuthMethod m = new SshAuthMethod(this.conn);
        if (this.uri.getUserInfo() != null) {
            try {
                m.tryWithUserInfo(this.uri.getUserInfo());
                return;
            }
            catch (HgAuthFailedException hgAuthFailedException) {}
        }
        HgAuthenticator auth = this.sessionCtx.getAuthenticator(this.rd);
        auth.authenticate(this.rd, m);
    }

    @Override
    public void disconnect() throws HgRemoteConnectionException {
        if (this.session != null) {
            this.doSessionClose();
        }
        if (this.conn != null) {
            this.conn.close();
            this.conn = null;
        }
    }

    @Override
    public void sessionBegin() throws HgRemoteConnectionException {
        if (this.sessionUse > 0) {
            assert (this.session != null);
            ++this.sessionUse;
            return;
        }
        try {
            this.session = this.conn.openSession();
            String path = this.uri.getPath();
            this.session.execCommand(String.format("hg -R %s serve --stdio", path.charAt(0) == '/' ? path.substring(1) : path));
            this.remoteErr = new StreamGobbler(this.session.getStderr());
            this.remoteOut = new StreamGobbler(this.session.getStdout());
            this.remoteIn = this.session.getStdin();
            this.sessionUse = 1;
        }
        catch (IOException ex) {
            throw new HgRemoteConnectionException("Failed to create ssh session", ex);
        }
    }

    @Override
    public void sessionEnd() throws HgRemoteConnectionException {
        assert (this.sessionUse > 0);
        assert (this.session != null);
        if (this.sessionUse > 1) {
            --this.sessionUse;
            return;
        }
        this.doSessionClose();
    }

    @Override
    public String getCapabilities() throws HgRemoteConnectionException {
        try {
            String line;
            this.consume((InputStream)this.remoteOut);
            this.consume((InputStream)this.remoteErr);
            this.remoteIn.write("hello".getBytes());
            this.remoteIn.write(10);
            this.remoteIn.write("capabilities".getBytes());
            this.remoteIn.write(10);
            this.remoteIn.write("heads".getBytes());
            this.remoteIn.write(10);
            this.checkError();
            int responseLen = this.readResponseLength();
            this.checkError();
            FilterStream s = new FilterStream((InputStream)this.remoteOut, responseLen);
            BufferedReader r = new BufferedReader(new InputStreamReader(s));
            while ((line = r.readLine()) != null) {
                if (!line.startsWith("capabilities") || line.length() <= "capabilities".length() + 1 || (line = line.substring("capabilities".length())).charAt(0) != ':') continue;
                return line.substring("capabilities".length() + 1);
            }
            r.close();
            this.consume((InputStream)this.remoteOut);
            this.checkError();
            return new String();
        }
        catch (IOException ex) {
            throw new HgRemoteConnectionException("Failed to initiate dialog with server", ex).setRemoteCommand("hello").setServerInfo(this.getServerLocation());
        }
    }

    @Override
    public InputStream heads() throws HgRemoteConnectionException {
        return this.executeCommand("heads", Collections.emptyList(), true);
    }

    @Override
    public InputStream between(Collection<HgRemoteRepository.Range> ranges) throws HgRemoteConnectionException {
        StringBuilder sb = new StringBuilder(ranges.size() * 82);
        for (HgRemoteRepository.Range r : ranges) {
            r.append(sb).append(' ');
        }
        if (!ranges.isEmpty()) {
            sb.setLength(sb.length() - 1);
        }
        return this.executeCommand("between", Collections.singletonList(new Parameter("pairs", sb.toString())), true);
    }

    @Override
    public InputStream branches(List<Nodeid> nodes) throws HgRemoteConnectionException {
        String l = SshConnector.join(nodes, ' ');
        return this.executeCommand("branches", Collections.singletonList(new Parameter("nodes", l)), true);
    }

    @Override
    public InputStream changegroup(List<Nodeid> roots) throws HgRemoteConnectionException, HgRuntimeException {
        String l = SshConnector.join(roots, ' ');
        InputStream cg = this.executeCommand("changegroup", Collections.singletonList(new Parameter("roots", l)), false);
        ByteArrayInputStream prefix = new ByteArrayInputStream("HG10UN".getBytes());
        return new SequenceInputStream(prefix, cg);
    }

    @Override
    public OutputStream unbundle(long outputLen, List<Nodeid> remoteHeads) throws HgRemoteConnectionException, HgRuntimeException {
        String l = SshConnector.join(remoteHeads, ' ');
        try {
            this.consume((InputStream)this.remoteOut);
            this.consume((InputStream)this.remoteErr);
            this.remoteIn.write("unbundle".getBytes());
            this.remoteIn.write(10);
            this.writeParameters(Collections.singletonList(new Parameter("heads", l)));
            this.checkError();
            return new FilterOutputStream(this.remoteIn){

                @Override
                public void close() throws IOException {
                    this.out.flush();
                    SshConnector.this.readResponseLength();
                    SshConnector.this.checkError();
                }
            };
        }
        catch (IOException ex) {
            throw new HgRemoteConnectionException("Communication failure", ex).setRemoteCommand("unbundle").setServerInfo(this.getServerLocation());
        }
    }

    @Override
    public InputStream pushkey(String opName, String namespace, String key, String oldValue, String newValue) throws HgRemoteConnectionException, HgRuntimeException {
        ArrayList<Parameter> p = new ArrayList<Parameter>();
        p.add(new Parameter("namespace", namespace));
        p.add(new Parameter("key", key));
        p.add(new Parameter("old", oldValue));
        p.add(new Parameter("new", newValue));
        return this.executeCommand("pushkey", p, true);
    }

    @Override
    public InputStream listkeys(String namespace, String actionName) throws HgRemoteConnectionException, HgRuntimeException {
        return this.executeCommand("listkeys", Collections.singletonList(new Parameter("namespace", namespace)), true);
    }

    private InputStream executeCommand(String cmd, List<Parameter> parameters, boolean expectResponseLength) throws HgRemoteConnectionException {
        try {
            this.consume((InputStream)this.remoteOut);
            this.consume((InputStream)this.remoteErr);
            this.remoteIn.write(cmd.getBytes());
            this.remoteIn.write(10);
            this.writeParameters(parameters);
            this.checkError();
            if (expectResponseLength) {
                int responseLen = this.readResponseLength();
                this.checkError();
                return new FilterStream((InputStream)this.remoteOut, responseLen);
            }
            return new FilterStream((InputStream)this.remoteOut, Integer.MAX_VALUE);
        }
        catch (IOException ex) {
            throw new HgRemoteConnectionException("Communication failure", ex).setRemoteCommand(cmd).setServerInfo(this.getServerLocation());
        }
    }

    private void writeParameters(List<Parameter> parameters) throws IOException {
        for (Parameter p : parameters) {
            this.remoteIn.write(p.name().getBytes());
            this.remoteIn.write(32);
            this.remoteIn.write(String.valueOf(p.size()).getBytes());
            this.remoteIn.write(10);
            this.remoteIn.write(p.data());
            this.remoteIn.write(10);
        }
    }

    private void consume(InputStream is) throws IOException {
        while (is.available() > 0) {
            is.read();
        }
    }

    private void checkError() throws IOException {
        if (this.remoteErr.available() > 0) {
            int c;
            StringBuilder sb = new StringBuilder();
            while ((c = this.remoteErr.read()) != -1) {
                sb.append((char)c);
            }
            throw new IOException(sb.toString());
        }
    }

    private int readResponseLength() throws IOException {
        int c;
        StringBuilder sb = new StringBuilder();
        while ((c = this.remoteOut.read()) != -1) {
            if (c == 10) break;
            sb.append((char)c);
        }
        if (c == -1) {
            throw new EOFException();
        }
        try {
            return Integer.parseInt(sb.toString());
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException(String.format("Expected response length instead of %s", sb));
        }
    }

    private void doSessionClose() {
        if (this.session != null) {
            this.closeQuietly((Closeable)this.remoteErr);
            this.closeQuietly((Closeable)this.remoteOut);
            this.remoteOut = null;
            this.remoteErr = null;
            this.closeQuietly(this.remoteIn);
            this.remoteIn = null;
            this.session.close();
            this.session = null;
        }
        this.sessionUse = 0;
    }

    private void closeQuietly(Closeable c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (IOException ex) {
            this.sessionCtx.getLog().dump(this.getClass(), LogFacility.Severity.Warn, ex, null);
        }
    }

    private static String join(List<Nodeid> values, char sep) {
        StringBuilder sb = new StringBuilder(values.size() * 41);
        for (Nodeid n : values) {
            sb.append(n.toString());
            sb.append(sep);
        }
        if (!values.isEmpty()) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    private static final class FilterStream
    extends FilterInputStream {
        private int length;

        public FilterStream(InputStream is, int initialLength) {
            super(is);
            this.length = initialLength;
        }

        @Override
        public int available() throws IOException {
            return Math.min(super.available(), this.length);
        }

        @Override
        public int read() throws IOException {
            if (this.length == 0) {
                return -1;
            }
            int r = super.read();
            if (r >= 0) {
                --this.length;
            }
            return r;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.length == 0) {
                return -1;
            }
            int r = super.read(b, off, Math.min(len, this.length));
            if (r >= 0) {
                assert (r <= this.length);
                this.length -= r;
            }
            return r;
        }

        @Override
        public void close() throws IOException {
            this.length = 0;
        }
    }

    private static final class Parameter {
        private final String name;
        private final byte[] data;

        public Parameter(String paramName, String paramValue) {
            assert (paramName != null);
            assert (paramValue != null);
            this.name = paramName;
            this.data = paramValue.getBytes();
        }

        public String name() {
            return this.name;
        }

        public int size() {
            return this.data.length;
        }

        public byte[] data() {
            return this.data;
        }
    }
}

