/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.repo;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.tmatesoft.hg.core.HgIOException;
import org.tmatesoft.hg.core.HgRepositoryLockException;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.internal.FileChangeMonitor;
import org.tmatesoft.hg.internal.Internals;
import org.tmatesoft.hg.internal.LineReader;
import org.tmatesoft.hg.repo.HgInvalidControlFileException;
import org.tmatesoft.hg.repo.HgRepositoryFiles;
import org.tmatesoft.hg.repo.HgRepositoryLock;
import org.tmatesoft.hg.repo.HgRuntimeException;
import org.tmatesoft.hg.util.LogFacility;

public final class HgBookmarks {
    private final Internals repo;
    private Map<String, Nodeid> bookmarks = Collections.emptyMap();
    private String activeBookmark;
    private FileChangeMonitor activeTracker;
    private FileChangeMonitor bmFileTracker;

    HgBookmarks(Internals internals) {
        this.repo = internals;
    }

    void read() throws HgRuntimeException {
        this.readBookmarks();
        this.readActiveBookmark();
    }

    private void readBookmarks() throws HgRuntimeException {
        LogFacility log = this.repo.getLog();
        File all = this.repo.getRepositoryFile(HgRepositoryFiles.Bookmarks);
        try {
            LinkedHashMap<String, Nodeid> bm = new LinkedHashMap<String, Nodeid>();
            if (all.canRead() && all.isFile()) {
                LineReader lr1 = new LineReader(all, log);
                ArrayList c = new ArrayList();
                lr1.read(new LineReader.SimpleLineCollector(), c);
                for (String s : c) {
                    int x = s.indexOf(32);
                    try {
                        if (x > 0) {
                            Nodeid nid = Nodeid.fromAscii(s.substring(0, x));
                            String name = new String(s.substring(x + 1));
                            if (this.repo.getRepo().getChangelog().isKnown(nid)) {
                                bm.put(name, nid);
                                continue;
                            }
                            log.dump(this.getClass(), LogFacility.Severity.Info, "Bookmark %s points to non-existent revision %s, ignored.", name, nid);
                            continue;
                        }
                        log.dump(this.getClass(), LogFacility.Severity.Warn, "Can't parse bookmark entry: %s", s);
                    }
                    catch (IllegalArgumentException ex) {
                        log.dump(this.getClass(), LogFacility.Severity.Warn, ex, String.format("Can't parse bookmark entry: %s", s));
                    }
                }
                this.bookmarks = bm;
            } else {
                this.bookmarks = Collections.emptyMap();
            }
            if (this.bmFileTracker == null) {
                this.bmFileTracker = new FileChangeMonitor(all);
            }
            this.bmFileTracker.touch(this);
        }
        catch (HgInvalidControlFileException ex) {
            throw ex;
        }
        catch (HgIOException ex) {
            throw new HgInvalidControlFileException(ex, true);
        }
    }

    private void readActiveBookmark() throws HgInvalidControlFileException {
        this.activeBookmark = null;
        File active = this.repo.getRepositoryFile(HgRepositoryFiles.BookmarksCurrent);
        try {
            if (active.canRead() && active.isFile()) {
                LineReader lr2 = new LineReader(active, this.repo.getLog());
                ArrayList c = new ArrayList(2);
                lr2.read(new LineReader.SimpleLineCollector(), c);
                if (c.size() > 0) {
                    this.activeBookmark = (String)c.get(0);
                }
            }
            if (this.activeTracker == null) {
                this.activeTracker = new FileChangeMonitor(active);
            }
            this.activeTracker.touch(this);
        }
        catch (HgIOException ex) {
            throw new HgInvalidControlFileException(ex, true);
        }
    }

    void reloadIfChanged() throws HgRuntimeException {
        assert (this.activeTracker != null);
        assert (this.bmFileTracker != null);
        if (this.bmFileTracker.changed(this)) {
            this.readBookmarks();
        }
        if (this.activeTracker.changed(this)) {
            this.readActiveBookmark();
        }
    }

    public String getActiveBookmarkName() {
        return this.activeBookmark;
    }

    public Nodeid getRevision(String bookmarkName) {
        return this.bookmarks.get(bookmarkName);
    }

    public Collection<String> getAllBookmarks() {
        return Collections.unmodifiableSet(this.bookmarks.keySet());
    }

    public void updateActive(Nodeid p1, Nodeid p2, Nodeid child) throws HgIOException, HgRepositoryLockException {
        if (this.activeBookmark == null) {
            return;
        }
        Nodeid activeRev = this.getRevision(this.activeBookmark);
        if (!activeRev.equals(p1) && !activeRev.equals(p2)) {
            return;
        }
        if (child.equals(activeRev)) {
            return;
        }
        LinkedHashMap<String, Nodeid> copy = new LinkedHashMap<String, Nodeid>(this.bookmarks);
        copy.put(this.activeBookmark, child);
        this.bookmarks = copy;
        this.write();
    }

    private void write() throws HgIOException, HgRepositoryLockException {
        File bookmarksFile = this.repo.getRepositoryFile(HgRepositoryFiles.Bookmarks);
        HgRepositoryLock workingDirLock = this.repo.getRepo().getWorkingDirLock();
        FileWriter fileWriter = null;
        workingDirLock.acquire();
        try {
            try {
                fileWriter = new FileWriter(bookmarksFile);
                for (String bm : this.bookmarks.keySet()) {
                    Nodeid nid = this.bookmarks.get(bm);
                    fileWriter.write(String.format("%s %s\n", nid.toString(), bm));
                }
                fileWriter.flush();
            }
            catch (IOException ex) {
                throw new HgIOException("Failed to serialize bookmarks", ex, bookmarksFile);
            }
        }
        finally {
            try {
                if (fileWriter != null) {
                    fileWriter.close();
                }
            }
            catch (IOException ex) {
                this.repo.getLog().dump(this.getClass(), LogFacility.Severity.Error, ex, null);
            }
            workingDirLock.release();
        }
    }
}

