/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.repo;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.internal.ChangelogMonitor;
import org.tmatesoft.hg.internal.Internals;
import org.tmatesoft.hg.repo.HgChangelog;
import org.tmatesoft.hg.repo.HgInvalidControlFileException;
import org.tmatesoft.hg.repo.HgParentChildMap;
import org.tmatesoft.hg.repo.HgRepository;
import org.tmatesoft.hg.repo.HgRevisionMap;
import org.tmatesoft.hg.repo.HgRuntimeException;
import org.tmatesoft.hg.util.ProgressSupport;

public class HgBranches {
    private final Internals internalRepo;
    private final ChangelogMonitor repoChangeTracker;
    private final Map<String, BranchInfo> branches = new TreeMap<String, BranchInfo>();
    private boolean isCacheActual = false;

    HgBranches(Internals internals) {
        this.internalRepo = internals;
        this.repoChangeTracker = new ChangelogMonitor(internals.getRepo());
    }

    /*
     * Exception decompiling
     */
    private int readCache() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void collect(final ProgressSupport ps) throws HgRuntimeException {
        HgRevisionMap<HgChangelog> rmap;
        this.branches.clear();
        HgRepository repo = this.internalRepo.getRepo();
        HgChangelog clog = repo.getChangelog();
        ps.start(1 + clog.getRevisionCount() * 2);
        int lastCached = this.readCache();
        boolean bl = this.isCacheActual = lastCached == clog.getLastRevision();
        if (!this.isCacheActual) {
            final HgParentChildMap<HgChangelog> pw = new HgParentChildMap<HgChangelog>(clog);
            pw.init();
            ps.worked(clog.getRevisionCount());
            final HashMap branchStart = new HashMap();
            final HashMap branchHeads = new HashMap();
            HgChangelog.Inspector insp = new HgChangelog.Inspector(){
                private final ArrayList<Nodeid> parents = new ArrayList(3);

                @Override
                public void next(int revisionNumber, Nodeid nodeid, HgChangelog.RawChangeset cset) {
                    LinkedList<Nodeid> _branchHeads;
                    String branchName = cset.branch();
                    if (!branchStart.containsKey(branchName)) {
                        branchStart.put(branchName, nodeid);
                        _branchHeads = new LinkedList<Nodeid>();
                        branchHeads.put(branchName, _branchHeads);
                    } else {
                        _branchHeads = (LinkedList<Nodeid>)branchHeads.get(branchName);
                        if (_branchHeads == null) {
                            _branchHeads = new LinkedList();
                            branchHeads.put(branchName, _branchHeads);
                        }
                    }
                    _branchHeads.add(nodeid);
                    this.parents.clear();
                    pw.appendParentsOf(nodeid, this.parents);
                    _branchHeads.removeAll(this.parents);
                    ps.worked(1);
                }
            };
            clog.range(lastCached == -1 ? 0 : lastCached + 1, -3, insp);
            for (String bn : branchStart.keySet()) {
                BranchInfo bi = this.branches.get(bn);
                if (bi != null) {
                    LinkedHashSet<Nodeid> oldHeads = new LinkedHashSet<Nodeid>(bi.getHeads());
                    for (Nodeid newHead : (List)branchHeads.get(bn)) {
                        Iterator it = oldHeads.iterator();
                        while (it.hasNext()) {
                            if (!pw.isChild((Nodeid)it.next(), newHead)) continue;
                            it.remove();
                        }
                    }
                    oldHeads.addAll((Collection)branchHeads.get(bn));
                    assert (oldHeads.size() > 0);
                    bi = new BranchInfo(bn, bi.getStart(), oldHeads.toArray(new Nodeid[oldHeads.size()]));
                } else {
                    Nodeid[] heads = ((List)branchHeads.get(bn)).toArray(new Nodeid[0]);
                    bi = new BranchInfo(bn, (Nodeid)branchStart.get(bn), heads);
                }
                this.branches.put(bn, bi);
            }
            rmap = pw.getRevisionMap();
        } else {
            rmap = new HgRevisionMap<HgChangelog>(clog).init();
        }
        for (BranchInfo bi : this.branches.values()) {
            bi.validate(clog, rmap);
        }
        this.repoChangeTracker.touch();
        ps.done();
    }

    public List<BranchInfo> getAllBranches() throws HgInvalidControlFileException {
        return new LinkedList<BranchInfo>(this.branches.values());
    }

    public BranchInfo getBranch(String name) throws HgInvalidControlFileException {
        return this.branches.get(name);
    }

    public void writeCache() throws IOException, HgRuntimeException {
        if (this.isCacheActual) {
            return;
        }
        File branchheadsCache = this.getCacheFile();
        if (!branchheadsCache.exists()) {
            branchheadsCache.getParentFile().mkdirs();
            branchheadsCache.createNewFile();
        }
        if (!branchheadsCache.canWrite()) {
            return;
        }
        HgRepository repo = this.internalRepo.getRepo();
        int lastRev = repo.getChangelog().getLastRevision();
        Nodeid lastNid = repo.getChangelog().getRevision(lastRev);
        BufferedWriter bw = new BufferedWriter(new FileWriter(branchheadsCache));
        bw.write(lastNid.toString());
        bw.write(32);
        bw.write(Integer.toString(lastRev));
        bw.write("\n");
        for (BranchInfo bi : this.branches.values()) {
            for (Nodeid nid : bi.getHeads()) {
                bw.write(nid.toString());
                bw.write(32);
                bw.write(bi.getName());
                bw.write("\n");
            }
        }
        bw.close();
    }

    private File getCacheFile() {
        File f = this.internalRepo.getFileFromRepoDir("cache/branchheads-base");
        if (f.exists()) {
            return f;
        }
        return this.internalRepo.getFileFromRepoDir("cache/branchheads");
    }

    void reloadIfChanged(ProgressSupport ps) throws HgRuntimeException {
        if (this.repoChangeTracker.isChanged()) {
            this.collect(ps);
        }
    }

    public static class BranchInfo {
        private final String name;
        private List<Nodeid> heads;
        private boolean closed;
        private final Nodeid start;
        private List<Nodeid> closedHeads;

        BranchInfo(String branchName, Nodeid first, Nodeid[] branchHeads) {
            this.name = branchName;
            this.start = first;
            this.heads = Arrays.asList(branchHeads);
        }

        BranchInfo(String branchName, Nodeid[] branchHeads) {
            this(branchName, Nodeid.NULL, branchHeads);
        }

        void validate(HgChangelog clog, HgRevisionMap<HgChangelog> rmap) throws HgRuntimeException {
            int[] localCset = new int[this.heads.size()];
            int i = 0;
            for (Nodeid h : this.heads) {
                localCset[i++] = rmap.revisionIndex(h);
            }
            final Nodeid[] tipmost = new Nodeid[2];
            final boolean[] allClosed = new boolean[]{true};
            final ArrayList<Nodeid> _closedHeads = new ArrayList<Nodeid>(this.heads.size());
            clog.range(new HgChangelog.Inspector(){

                @Override
                public void next(int revisionNumber, Nodeid nodeid, HgChangelog.RawChangeset cset) {
                    if (!$assertionsDisabled && !BranchInfo.this.heads.contains(nodeid)) {
                        throw new AssertionError();
                    }
                    tipmost[0] = nodeid;
                    if (!"1".equals(cset.extras().get("close"))) {
                        tipmost[1] = nodeid;
                        allClosed[0] = false;
                    } else {
                        _closedHeads.add(nodeid);
                    }
                }
            }, localCset);
            this.closed = allClosed[0];
            Nodeid[] outcome = new Nodeid[localCset.length];
            i = 0;
            if (!this.closed && tipmost[1] != null) {
                outcome[i++] = tipmost[1];
                if (i < outcome.length && !tipmost[0].equals(tipmost[1])) {
                    outcome[i++] = tipmost[0];
                }
            } else {
                outcome[i++] = tipmost[0];
            }
            for (Nodeid h : this.heads) {
                if (h.equals(tipmost[0]) || h.equals(tipmost[1])) continue;
                outcome[i++] = h;
            }
            this.heads = Arrays.asList(outcome);
            if (this.closed) {
                this.closedHeads = null;
            } else {
                _closedHeads.trimToSize();
                this.closedHeads = _closedHeads;
            }
        }

        public String getName() {
            return this.name;
        }

        public boolean isClosed() {
            return this.closed;
        }

        public List<Nodeid> getHeads() {
            return this.heads;
        }

        public boolean isClosed(Nodeid head) {
            if (!this.heads.contains(head)) {
                throw new IllegalArgumentException(String.format("Revision %s does not belong to heads of %s branch", head, this.name), null);
            }
            if (this.closed) {
                return true;
            }
            return this.closedHeads.contains(head);
        }

        Nodeid getStart() {
            return this.start;
        }
    }
}

