/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.repo;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ConcurrentModificationException;
import org.tmatesoft.hg.core.HgIOException;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.core.SessionContext;
import org.tmatesoft.hg.internal.ByteArrayChannel;
import org.tmatesoft.hg.internal.ByteArrayDataAccess;
import org.tmatesoft.hg.internal.ChangesetParser;
import org.tmatesoft.hg.internal.DataAccess;
import org.tmatesoft.hg.internal.DataAccessInputStream;
import org.tmatesoft.hg.internal.DataAccessProvider;
import org.tmatesoft.hg.internal.DigestHelper;
import org.tmatesoft.hg.internal.EncodingHelper;
import org.tmatesoft.hg.internal.InflaterDataAccess;
import org.tmatesoft.hg.internal.Internals;
import org.tmatesoft.hg.internal.Lifecycle;
import org.tmatesoft.hg.internal.Patch;
import org.tmatesoft.hg.repo.HgChangelog;
import org.tmatesoft.hg.repo.HgInvalidControlFileException;
import org.tmatesoft.hg.repo.HgInvalidDataFormatException;
import org.tmatesoft.hg.repo.HgInvalidStateException;
import org.tmatesoft.hg.repo.HgRepository;
import org.tmatesoft.hg.repo.HgRuntimeException;
import org.tmatesoft.hg.util.Adaptable;
import org.tmatesoft.hg.util.ByteChannel;
import org.tmatesoft.hg.util.CancelledException;

public class HgBundle {
    final File bundleFile;
    private final DataAccessProvider accessProvider;
    final SessionContext ctx;
    private final EncodingHelper fnDecorer;
    private Lifecycle.BasicCallback flowControl;
    private int uses = 0;

    HgBundle(SessionContext sessionContext, DataAccessProvider dap, File bundle) {
        this.ctx = sessionContext;
        this.accessProvider = dap;
        this.bundleFile = bundle;
        this.fnDecorer = Internals.buildFileNameEncodingHelper(new SessionContext.SourcePrim(this.ctx));
    }

    private DataAccess getDataStream() throws IOException {
        DataAccess da = this.accessProvider.createReader(this.bundleFile, false);
        byte[] signature = new byte[6];
        if (da.length() > 6) {
            da.readBytes(signature, 0, 6);
            if (signature[0] == 72 && signature[1] == 71 && signature[2] == 49 && signature[3] == 48) {
                if (signature[4] == 71 && signature[5] == 90) {
                    return new InflaterDataAccess(da, 6L, da.length() - 6);
                }
                if (signature[4] == 66 && signature[5] == 90) {
                    throw Internals.notImplemented();
                }
                if (signature[4] != 85 || signature[5] != 78) {
                    throw new HgInvalidStateException(String.format("Bad bundle signature: %s", String.valueOf(signature)));
                }
            } else {
                da.reset();
            }
        }
        return da;
    }

    public HgBundle link() {
        ++this.uses;
        return this;
    }

    public void unlink() {
        --this.uses;
        if (this.uses == 0 && this.bundleFile != null) {
            this.bundleFile.deleteOnExit();
        }
    }

    public boolean inUse() {
        return this.uses > 0;
    }

    public void changes(final HgRepository hgRepo, final HgChangelog.Inspector inspector) throws HgIOException, HgRuntimeException {
        Inspector bundleInsp = new Inspector(){
            DigestHelper dh = new DigestHelper();
            boolean emptyChangelog = true;
            private DataAccess prevRevContent;
            private int revisionIndex;
            private ChangesetParser csetBuilder;

            @Override
            public void changelogStart() {
                this.emptyChangelog = true;
                this.revisionIndex = 0;
                this.csetBuilder = new ChangesetParser(hgRepo, new HgChangelog.RawCsetFactory(true));
            }

            @Override
            public void changelogEnd() {
                if (this.emptyChangelog) {
                    throw new IllegalStateException("No changelog group in the bundle");
                }
            }

            @Override
            public boolean element(GroupElement ge) throws IOException, HgRuntimeException {
                this.emptyChangelog = false;
                HgChangelog changelog = hgRepo.getChangelog();
                try {
                    if (this.prevRevContent == null) {
                        if (ge.firstParent().isNull() && ge.secondParent().isNull()) {
                            this.prevRevContent = new ByteArrayDataAccess(new byte[0]);
                        } else {
                            Nodeid base = ge.firstParent();
                            if (!changelog.isKnown(base)) {
                                throw new IllegalStateException(String.format("Revision %s needs a parent %s, which is missing in the supplied repo %s", ge.node().shortNotation(), base.shortNotation(), hgRepo.toString()));
                            }
                            ByteArrayChannel bac = new ByteArrayChannel();
                            changelog.rawContent(base, (ByteChannel)bac);
                            this.prevRevContent = new ByteArrayDataAccess(bac.toArray());
                        }
                    }
                    byte[] csetContent = ge.patch().apply(this.prevRevContent, -1);
                    this.dh = this.dh.sha1(ge.firstParent(), ge.secondParent(), csetContent);
                    if (!ge.node().equalsTo(this.dh.asBinary())) {
                        throw new HgInvalidStateException(String.format("Integrity check failed on %s, node: %s", HgBundle.this.bundleFile, ge.node().shortNotation()));
                    }
                    HgChangelog.RawChangeset cs = this.csetBuilder.parse(csetContent);
                    inspector.next(this.revisionIndex++, ge.node(), cs);
                    this.prevRevContent.done();
                    this.prevRevContent = new ByteArrayDataAccess(csetContent);
                }
                catch (CancelledException cancelledException) {
                    return false;
                }
                catch (HgInvalidDataFormatException ex) {
                    throw new HgInvalidControlFileException("Invalid bundle file", ex, HgBundle.this.bundleFile);
                }
                return true;
            }

            @Override
            public void manifestStart() {
            }

            @Override
            public void manifestEnd() {
            }

            @Override
            public void fileStart(String name) {
            }

            @Override
            public void fileEnd(String name) {
            }
        };
        this.inspectChangelog(bundleInsp);
    }

    public void inspectChangelog(Inspector inspector) throws HgIOException, HgRuntimeException {
        if (inspector == null) {
            throw new IllegalArgumentException();
        }
        Lifecycle lifecycle = this.lifecycleSetUp(inspector);
        DataAccess da = null;
        try {
            try {
                da = this.getDataStream();
                this.internalInspectChangelog(da, inspector);
            }
            catch (IOException ex) {
                throw new HgIOException("Failed to inspect changelog in the bundle", ex, this.bundleFile);
            }
        }
        finally {
            if (da != null) {
                da.done();
            }
            this.lifecycleTearDown(lifecycle);
        }
    }

    public void inspectManifest(Inspector inspector) throws HgIOException, HgRuntimeException {
        if (inspector == null) {
            throw new IllegalArgumentException();
        }
        Lifecycle lifecycle = this.lifecycleSetUp(inspector);
        DataAccess da = null;
        try {
            da = this.getDataStream();
            if (da.isEmpty()) {
                return;
            }
            try {
                HgBundle.skipGroup(da);
                this.internalInspectManifest(da, inspector);
            }
            catch (IOException ex) {
                throw new HgIOException("Failed to inspect manifest in the bundle", ex, this.bundleFile);
            }
        }
        finally {
            if (da != null) {
                da.done();
            }
            this.lifecycleTearDown(lifecycle);
        }
    }

    public void inspectFiles(Inspector inspector) throws HgIOException, HgRuntimeException {
        if (inspector == null) {
            throw new IllegalArgumentException();
        }
        Lifecycle lifecycle = this.lifecycleSetUp(inspector);
        DataAccess da = null;
        try {
            da = this.getDataStream();
            if (da.isEmpty()) {
                return;
            }
            HgBundle.skipGroup(da);
            if (da.isEmpty()) {
                return;
            }
            try {
                HgBundle.skipGroup(da);
                this.internalInspectFiles(da, inspector);
            }
            catch (IOException ex) {
                throw new HgIOException("Failed to inspect files in the bundle", ex, this.bundleFile);
            }
        }
        finally {
            if (da != null) {
                da.done();
            }
            this.lifecycleTearDown(lifecycle);
        }
    }

    public void inspectAll(Inspector inspector) throws HgIOException, HgRuntimeException {
        if (inspector == null) {
            throw new IllegalArgumentException();
        }
        Lifecycle lifecycle = this.lifecycleSetUp(inspector);
        DataAccess da = null;
        try {
            da = this.getDataStream();
            this.internalInspectChangelog(da, inspector);
            if (this.flowControl.isStopped()) {
                return;
            }
            this.internalInspectManifest(da, inspector);
            if (this.flowControl.isStopped()) {
                return;
            }
            try {
                this.internalInspectFiles(da, inspector);
            }
            catch (IOException ex) {
                throw new HgIOException("Failed to inspect bundle", ex, this.bundleFile);
            }
        }
        finally {
            if (da != null) {
                da.done();
            }
            this.lifecycleTearDown(lifecycle);
        }
    }

    private Lifecycle lifecycleSetUp(Inspector inspector) throws ConcurrentModificationException {
        if (this.flowControl != null) {
            throw new ConcurrentModificationException("HgBundle is in use and not thread-safe yet");
        }
        this.flowControl = new Lifecycle.BasicCallback();
        Lifecycle lifecycle = Adaptable.Factory.getAdapter(inspector, Lifecycle.class, null);
        if (lifecycle != null) {
            lifecycle.start(-1, this.flowControl, this.flowControl);
        }
        return lifecycle;
    }

    private void lifecycleTearDown(Lifecycle lifecycle) {
        if (lifecycle != null) {
            lifecycle.finish(this.flowControl);
        }
        this.flowControl = null;
    }

    private void internalInspectChangelog(DataAccess da, Inspector inspector) throws IOException, HgRuntimeException {
        if (da.isEmpty()) {
            return;
        }
        inspector.changelogStart();
        if (this.flowControl.isStopped()) {
            return;
        }
        HgBundle.readGroup(da, inspector);
        if (this.flowControl.isStopped()) {
            return;
        }
        inspector.changelogEnd();
    }

    private void internalInspectManifest(DataAccess da, Inspector inspector) throws IOException, HgRuntimeException {
        if (da.isEmpty()) {
            return;
        }
        inspector.manifestStart();
        if (this.flowControl.isStopped()) {
            return;
        }
        HgBundle.readGroup(da, inspector);
        if (this.flowControl.isStopped()) {
            return;
        }
        inspector.manifestEnd();
    }

    private void internalInspectFiles(DataAccess da, Inspector inspector) throws IOException, HgRuntimeException {
        while (!da.isEmpty()) {
            int fnameLen = da.readInt();
            if (fnameLen <= 4) break;
            byte[] fnameBuf = new byte[fnameLen - 4];
            da.readBytes(fnameBuf, 0, fnameBuf.length);
            String name = this.fnDecorer.fromBundle(fnameBuf, 0, fnameBuf.length);
            inspector.fileStart(name);
            if (this.flowControl.isStopped()) {
                return;
            }
            HgBundle.readGroup(da, inspector);
            if (this.flowControl.isStopped()) {
                return;
            }
            inspector.fileEnd(name);
        }
    }

    private static void readGroup(DataAccess da, Inspector inspector) throws IOException, HgRuntimeException {
        int len = da.readInt();
        boolean good2go = true;
        Nodeid prevNodeid = null;
        while (len > 4 && !da.isEmpty() && good2go) {
            byte[] nb = new byte[80];
            da.readBytes(nb, 0, 80);
            int dataLength = len - 84;
            byte[] data = new byte[dataLength];
            da.readBytes(data, 0, dataLength);
            ByteArrayDataAccess slice = new ByteArrayDataAccess(data);
            GroupElement ge = new GroupElement(nb, prevNodeid, slice);
            good2go = inspector.element(ge);
            slice.done();
            prevNodeid = ge.node();
            int n = len = da.isEmpty() ? 0 : da.readInt();
        }
        while (len > 4 && !da.isEmpty()) {
            da.skip(len - 4);
            int n = len = da.isEmpty() ? 0 : da.readInt();
        }
    }

    private static void skipGroup(DataAccess da) throws IOException {
        int len = da.readInt();
        while (len > 4 && !da.isEmpty()) {
            da.skip(len - 4);
            int n = len = da.isEmpty() ? 0 : da.readInt();
        }
    }

    public static final class GroupElement {
        private final byte[] header;
        private final DataAccess dataAccess;
        private final Nodeid deltaBase;
        private Patch patches;

        GroupElement(byte[] fourNodeids, Nodeid deltaBaseRev, DataAccess rawDataAccess) {
            assert (fourNodeids != null && fourNodeids.length == 80);
            this.header = fourNodeids;
            this.deltaBase = deltaBaseRev;
            this.dataAccess = rawDataAccess;
        }

        public Nodeid node() {
            return Nodeid.fromBinary(this.header, 0);
        }

        public Nodeid firstParent() {
            return Nodeid.fromBinary(this.header, 20);
        }

        public Nodeid secondParent() {
            return Nodeid.fromBinary(this.header, 40);
        }

        public Nodeid cset() {
            return Nodeid.fromBinary(this.header, 60);
        }

        public Nodeid patchBase() {
            return this.deltaBase == null ? this.firstParent() : this.deltaBase;
        }

        public InputStream data() {
            return new DataAccessInputStream(this.dataAccess);
        }

        Patch patch() throws IOException {
            if (this.patches == null) {
                this.dataAccess.reset();
                this.patches = new Patch();
                this.patches.read(this.dataAccess);
            }
            return this.patches;
        }

        public String toString() {
            int patchCount;
            try {
                patchCount = this.patch().count();
            }
            catch (IOException ex) {
                ex.printStackTrace();
                patchCount = -1;
            }
            return String.format("%s %s %s %s; patches:%d\n", this.node().shortNotation(), this.firstParent().shortNotation(), this.secondParent().shortNotation(), this.cset().shortNotation(), patchCount);
        }
    }

    public static interface Inspector {
        public void changelogStart() throws HgRuntimeException;

        public void changelogEnd() throws HgRuntimeException;

        public void manifestStart() throws HgRuntimeException;

        public void manifestEnd() throws HgRuntimeException;

        public void fileStart(String var1) throws HgRuntimeException;

        public void fileEnd(String var1) throws HgRuntimeException;

        public boolean element(GroupElement var1) throws IOException, HgRuntimeException;
    }
}

