/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.repo;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.core.SessionContext;
import org.tmatesoft.hg.internal.ChangesetParser;
import org.tmatesoft.hg.internal.DataAccess;
import org.tmatesoft.hg.internal.Lifecycle;
import org.tmatesoft.hg.internal.LifecycleBridge;
import org.tmatesoft.hg.internal.RevlogStream;
import org.tmatesoft.hg.repo.HgInvalidControlFileException;
import org.tmatesoft.hg.repo.HgInvalidDataFormatException;
import org.tmatesoft.hg.repo.HgRepository;
import org.tmatesoft.hg.repo.HgRuntimeException;
import org.tmatesoft.hg.repo.Revlog;
import org.tmatesoft.hg.util.Adaptable;
import org.tmatesoft.hg.util.CancelSupport;
import org.tmatesoft.hg.util.ProgressSupport;

public final class HgChangelog
extends Revlog {
    HgChangelog(HgRepository hgRepo, RevlogStream content) {
        super(hgRepo, content, true);
    }

    public void all(Inspector inspector) throws HgRuntimeException {
        this.range(0, this.getLastRevision(), inspector);
    }

    public void range(int start, int end, Inspector inspector) throws HgRuntimeException {
        if (inspector == null) {
            throw new IllegalArgumentException();
        }
        this.content.iterate(start, end, true, new RawCsetParser(this.getRepo(), inspector));
    }

    public List<RawChangeset> range(int start, int end) throws HgRuntimeException {
        RawCsetCollector c = new RawCsetCollector(end - start + 1);
        this.range(start, end, c);
        return c.result;
    }

    public void range(Inspector inspector, int ... revisions) throws HgRuntimeException {
        Arrays.sort(revisions);
        this.rangeInternal(inspector, revisions);
    }

    void rangeInternal(Inspector inspector, int[] sortedRevisions) throws HgRuntimeException {
        if (sortedRevisions == null || sortedRevisions.length == 0) {
            return;
        }
        if (inspector == null) {
            throw new IllegalArgumentException();
        }
        this.content.iterate(sortedRevisions, true, new RawCsetParser(this.getRepo(), inspector));
    }

    public RawChangeset changeset(Nodeid nid) throws HgRuntimeException {
        int x = this.getRevisionIndex(nid);
        return this.range(x, x).get(0);
    }

    public static interface Inspector {
        public void next(int var1, Nodeid var2, RawChangeset var3) throws HgRuntimeException;
    }

    public static final class RawChangeset
    implements Cloneable {
        Nodeid manifest;
        String user;
        String comment;
        String[] files;
        Date time;
        int timezone;
        Map<String, String> extras;

        private RawChangeset() {
        }

        public Nodeid manifest() {
            return this.manifest;
        }

        public String user() {
            return this.user;
        }

        public String comment() {
            return this.comment;
        }

        public List<String> files() {
            return Arrays.asList(this.files);
        }

        public Date date() {
            return this.time;
        }

        public int timezone() {
            return this.timezone;
        }

        public String dateString() {
            StringBuilder sb = new StringBuilder(30);
            Formatter f = new Formatter(sb, Locale.US);
            TimeZone tz = TimeZone.getTimeZone(TimeZone.getAvailableIDs(this.timezone * 1000)[0]);
            Calendar c = Calendar.getInstance(tz, Locale.US);
            c.setTime(this.time);
            f.format("%ta %<tb %<td %<tH:%<tM:%<tS %<tY %<tz", c);
            return sb.toString();
        }

        public Map<String, String> extras() {
            return this.extras;
        }

        public String branch() {
            return this.extras.get("branch");
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Changeset {");
            sb.append("User: ").append(this.user).append(", ");
            sb.append("Comment: ").append(this.comment).append(", ");
            sb.append("Manifest: ").append(this.manifest).append(", ");
            sb.append("Date: ").append(this.time).append(", ");
            sb.append("Files: ").append(this.files.length);
            String[] stringArray = this.files;
            int n = this.files.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                sb.append(", ").append(s);
                ++n2;
            }
            if (this.extras != null) {
                sb.append(", Extra: ").append(this.extras);
            }
            sb.append("}");
            return sb.toString();
        }

        public RawChangeset clone() {
            try {
                return (RawChangeset)super.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new InternalError(ex.toString());
            }
        }
    }

    private static class RawCsetCollector
    implements Inspector {
        final ArrayList<RawChangeset> result;

        public RawCsetCollector(int count) {
            this.result = new ArrayList(count > 0 ? count : 5);
        }

        @Override
        public void next(int revisionNumber, Nodeid nodeid, RawChangeset cset) {
            this.result.add(cset.clone());
        }
    }

    static final class RawCsetFactory
    implements ChangesetParser.CsetFactory {
        private RawChangeset cset;

        public RawCsetFactory(boolean shallReuseCsetInstance) {
            if (shallReuseCsetInstance) {
                this.cset = new RawChangeset();
            }
        }

        @Override
        public RawChangeset create(Nodeid nodeidManifest, String user, Date time, int timezone, List<String> files, String comment, Map<String, String> extrasMap) {
            RawChangeset target = this.cset != null ? this.cset : new RawChangeset();
            target.manifest = nodeidManifest;
            target.user = user;
            target.time = time;
            target.timezone = timezone;
            target.files = files == null ? new String[]{} : files.toArray(new String[files.size()]);
            target.comment = comment;
            target.extras = extrasMap;
            return target;
        }
    }

    private static final class RawCsetParser
    implements RevlogStream.Inspector,
    Adaptable,
    Lifecycle {
        private final Inspector inspector;
        private final ChangesetParser csetBuilder;
        private final LifecycleBridge lifecycleStub;
        private final Lifecycle inspectorLifecycle;

        public RawCsetParser(SessionContext.Source sessionContext, Inspector delegate) {
            assert (delegate != null);
            this.inspector = delegate;
            this.csetBuilder = new ChangesetParser(sessionContext, new RawCsetFactory(true));
            this.inspectorLifecycle = Adaptable.Factory.getAdapter(delegate, Lifecycle.class, null);
            if (this.inspectorLifecycle == null) {
                ProgressSupport ph = Adaptable.Factory.getAdapter(delegate, ProgressSupport.class, null);
                CancelSupport cs = Adaptable.Factory.getAdapter(delegate, CancelSupport.class, null);
                this.lifecycleStub = cs != null || ph != null ? new LifecycleBridge(ph, cs) : null;
            } else {
                this.lifecycleStub = null;
            }
        }

        @Override
        public void next(int revisionNumber, int actualLen, int baseRevision, int linkRevision, int parent1Revision, int parent2Revision, byte[] nodeid, DataAccess da) throws HgRuntimeException {
            try {
                RawChangeset cset = this.csetBuilder.parse(da);
                this.inspector.next(revisionNumber, Nodeid.fromBinary(nodeid, 0), cset);
                if (this.lifecycleStub != null) {
                    this.lifecycleStub.nextStep();
                }
            }
            catch (HgInvalidDataFormatException ex) {
                throw ex.setRevisionIndex(revisionNumber);
            }
            catch (IOException ex) {
                throw new HgInvalidControlFileException("Failed reading changelog", ex, null).setRevisionIndex(revisionNumber);
            }
        }

        @Override
        public <T> T getAdapter(Class<T> adapterClass) {
            if (adapterClass == Lifecycle.class) {
                return adapterClass.cast(this);
            }
            return Adaptable.Factory.getAdapter(this.inspector, adapterClass, null);
        }

        @Override
        public void start(int count, Lifecycle.Callback callback, Object token) {
            if (this.inspectorLifecycle != null) {
                this.inspectorLifecycle.start(count, callback, token);
            } else if (this.lifecycleStub != null) {
                this.lifecycleStub.start(count, callback, token);
            }
        }

        @Override
        public void finish(Object token) {
            if (this.inspectorLifecycle != null) {
                this.inspectorLifecycle.finish(token);
            } else if (this.lifecycleStub != null) {
                this.lifecycleStub.finish(token);
            }
            this.csetBuilder.dispose();
        }
    }
}

