/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.repo;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import org.tmatesoft.hg.core.HgFileRevision;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.internal.DataAccess;
import org.tmatesoft.hg.internal.FileUtils;
import org.tmatesoft.hg.internal.FilterByteChannel;
import org.tmatesoft.hg.internal.FilterDataAccess;
import org.tmatesoft.hg.internal.Internals;
import org.tmatesoft.hg.internal.Metadata;
import org.tmatesoft.hg.internal.RevlogStream;
import org.tmatesoft.hg.repo.HgChangelog;
import org.tmatesoft.hg.repo.HgInternals;
import org.tmatesoft.hg.repo.HgInvalidControlFileException;
import org.tmatesoft.hg.repo.HgInvalidFileException;
import org.tmatesoft.hg.repo.HgInvalidRevisionException;
import org.tmatesoft.hg.repo.HgManifest;
import org.tmatesoft.hg.repo.HgRepository;
import org.tmatesoft.hg.repo.HgRuntimeException;
import org.tmatesoft.hg.repo.Revlog;
import org.tmatesoft.hg.util.ByteChannel;
import org.tmatesoft.hg.util.CancelSupport;
import org.tmatesoft.hg.util.CancelledException;
import org.tmatesoft.hg.util.LogFacility;
import org.tmatesoft.hg.util.Pair;
import org.tmatesoft.hg.util.Path;
import org.tmatesoft.hg.util.ProgressSupport;

public final class HgDataFile
extends Revlog {
    private final Path path;
    private Metadata metadata;

    HgDataFile(HgRepository hgRepo, Path filePath, RevlogStream content) {
        super(hgRepo, content, false);
        this.path = filePath;
    }

    public boolean exists() {
        return this.content.exists();
    }

    public Path getPath() {
        return this.path;
    }

    public int getLength(Nodeid nodeid) throws HgRuntimeException {
        try {
            return this.getLength(this.getRevisionIndex(nodeid));
        }
        catch (HgInvalidControlFileException ex) {
            throw ex.isRevisionSet() ? ex : ex.setRevision(nodeid);
        }
        catch (HgInvalidRevisionException ex) {
            throw ex.isRevisionSet() ? ex : ex.setRevision(nodeid);
        }
    }

    public int getLength(int fileRevisionIndex) throws HgRuntimeException {
        if (HgInternals.wrongRevisionIndex(fileRevisionIndex) || fileRevisionIndex == Integer.MIN_VALUE) {
            throw new HgInvalidRevisionException(fileRevisionIndex);
        }
        if (fileRevisionIndex == -3) {
            fileRevisionIndex = this.getLastRevision();
        } else if (fileRevisionIndex == -2) {
            File f = this.getRepo().getFile(this);
            if (f.exists()) {
                return Internals.ltoi(f.length());
            }
            Nodeid fileRev = this.getWorkingCopyRevision();
            if (fileRev == null) {
                throw new HgInvalidRevisionException(String.format("File %s is not part of working copy", this.getPath()), null, fileRevisionIndex);
            }
            fileRevisionIndex = this.getRevisionIndex(fileRev);
        }
        if (this.metadata == null || !this.metadata.checked(fileRevisionIndex)) {
            this.checkAndRecordMetadata(fileRevisionIndex);
        }
        int dataLen = this.content.dataLength(fileRevisionIndex);
        if (this.metadata.known(fileRevisionIndex)) {
            return dataLen - this.metadata.dataOffset(fileRevisionIndex);
        }
        return dataLen;
    }

    public void workingCopy(ByteChannel sink) throws CancelledException, HgRuntimeException {
        block9: {
            File f = this.getRepo().getFile(this);
            if (f.exists()) {
                CancelSupport cs = CancelSupport.Factory.get(sink);
                ProgressSupport progress = ProgressSupport.Factory.get(sink);
                long flength = f.length();
                int bsize = (int)Math.min(flength, 32768L);
                progress.start((int)(flength > Integer.MAX_VALUE ? flength >>> 15 : flength));
                ByteBuffer buf = ByteBuffer.allocate(bsize);
                FileInputStream fis = null;
                try {
                    try {
                        fis = new FileInputStream(f);
                        FileChannel fc = fis.getChannel();
                        while (fc.read(buf) != -1) {
                            cs.checkCancelled();
                            buf.flip();
                            int consumed = sink.write(buf);
                            progress.worked(flength > Integer.MAX_VALUE ? 1 : consumed);
                            buf.compact();
                        }
                        break block9;
                    }
                    catch (IOException ex) {
                        throw new HgInvalidFileException("Working copy read failed", ex, f);
                    }
                }
                finally {
                    progress.done();
                    if (fis != null) {
                        new FileUtils(this.getRepo().getSessionContext().getLog(), this).closeQuietly(fis);
                    }
                }
            }
            Nodeid fileRev = this.getWorkingCopyRevision();
            if (fileRev == null) {
                return;
            }
            int fileRevIndex = this.getRevisionIndex(fileRev);
            this.contentWithFilters(fileRevIndex, sink);
        }
    }

    private Nodeid getWorkingCopyRevision() throws HgRuntimeException {
        int csetRevIndex;
        Pair<Nodeid, Nodeid> wcParents = this.getRepo().getWorkingCopyParents();
        Nodeid p = wcParents.first().isNull() ? wcParents.second() : wcParents.first();
        HgChangelog clog = this.getRepo().getChangelog();
        if (p.isNull()) {
            this.getRepo().getSessionContext().getLog().dump(this.getClass(), LogFacility.Severity.Info, "No dirstate parents, resort to TIP", this.getPath());
            csetRevIndex = clog.getLastRevision();
            if (csetRevIndex == -1) {
                return null;
            }
        } else {
            Nodeid tipRev = clog.getRevision(-3);
            csetRevIndex = tipRev.equals(p) ? clog.getLastRevision() : clog.getRevisionIndex(p);
        }
        Nodeid fileRev = this.getRepo().getManifest().getFileRevision(csetRevIndex, this.getPath());
        return fileRev;
    }

    public void contentWithFilters(int fileRevisionIndex, ByteChannel sink) throws CancelledException, HgRuntimeException {
        if (fileRevisionIndex == -2) {
            this.workingCopy(sink);
        } else {
            this.content(fileRevisionIndex, new FilterByteChannel(sink, this.getRepo().getFiltersFromRepoToWorkingDir(this.getPath())));
        }
    }

    public void content(int fileRevisionIndex, ByteChannel sink) throws CancelledException, HgRuntimeException {
        if (fileRevisionIndex == -3) {
            fileRevisionIndex = this.getLastRevision();
        }
        if (fileRevisionIndex == -2) {
            this.workingCopy(sink);
            return;
        }
        if (HgInternals.wrongRevisionIndex(fileRevisionIndex) || fileRevisionIndex == Integer.MIN_VALUE) {
            throw new HgInvalidRevisionException(fileRevisionIndex);
        }
        if (sink == null) {
            throw new IllegalArgumentException();
        }
        if (this.metadata == null) {
            this.metadata = new Metadata(this.getRepo());
        }
        LogFacility lf = this.getRepo().getSessionContext().getLog();
        Revlog.ErrorHandlingInspector insp = this.metadata.none(fileRevisionIndex) ? new Revlog.ContentPipe(sink, 0, lf) : (this.metadata.known(fileRevisionIndex) ? new Revlog.ContentPipe(sink, this.metadata.dataOffset(fileRevisionIndex), lf) : new MetadataInspector(this.metadata, new Revlog.ContentPipe(sink, 0, lf)));
        insp.checkCancelled();
        this.content.iterate(fileRevisionIndex, fileRevisionIndex, true, insp);
        try {
            insp.checkFailed();
        }
        catch (HgInvalidControlFileException ex) {
            ex = ex.setFileName(this.getPath());
            throw ex.isRevisionIndexSet() ? ex : ex.setRevisionIndex(fileRevisionIndex);
        }
        catch (IOException ex) {
            HgInvalidControlFileException e = new HgInvalidControlFileException("Revision content access failed", ex, null);
            throw this.content.initWithIndexFile(e).setFileName(this.getPath()).setRevisionIndex(fileRevisionIndex);
        }
    }

    public void history(HgChangelog.Inspector inspector) throws HgRuntimeException {
        this.history(0, this.getLastRevision(), inspector);
    }

    public void history(int start, int end, HgChangelog.Inspector inspector) throws HgRuntimeException {
        if (!this.exists()) {
            throw new IllegalStateException("Can't get history of invalid repository file node");
        }
        int last = this.getLastRevision();
        if (end == -3) {
            end = last;
        }
        if (start == -3) {
            start = last;
        }
        HgInternals.checkRevlogRange(start, end, last);
        final int[] commitRevisions = new int[end - start + 1];
        final boolean[] needsSorting = new boolean[1];
        RevlogStream.Inspector insp = new RevlogStream.Inspector(){
            int count = 0;

            @Override
            public void next(int revisionNumber, int actualLen, int baseRevision, int linkRevision, int parent1Revision, int parent2Revision, byte[] nodeid, DataAccess data) {
                if (this.count > 0 && commitRevisions[this.count - 1] > linkRevision) {
                    needsSorting[0] = true;
                }
                commitRevisions[this.count++] = linkRevision;
            }
        };
        this.content.iterate(start, end, false, insp);
        HgChangelog changelog = this.getRepo().getChangelog();
        if (needsSorting[0]) {
            Arrays.sort(commitRevisions);
        }
        changelog.rangeInternal(inspector, commitRevisions);
    }

    public int getChangesetRevisionIndex(int fileRevisionIndex) throws HgRuntimeException {
        return this.content.linkRevision(fileRevisionIndex);
    }

    public Nodeid getChangesetRevision(Nodeid nid) throws HgRuntimeException {
        int changelogRevision = this.getChangesetRevisionIndex(this.getRevisionIndex(nid));
        return this.getRepo().getChangelog().getRevision(changelogRevision);
    }

    public boolean isCopy() throws HgRuntimeException {
        return this.isCopy(0);
    }

    public Path getCopySourceName() throws HgRuntimeException {
        if (this.isCopy()) {
            Path.Source ps = this.getRepo().getSessionContext().getPathFactory();
            return ps.path(this.metadata.find(0, "copy"));
        }
        throw new UnsupportedOperationException();
    }

    public Nodeid getCopySourceRevision() throws HgRuntimeException {
        if (this.isCopy()) {
            return Nodeid.fromAscii(this.metadata.find(0, "copyrev"));
        }
        throw new UnsupportedOperationException();
    }

    public boolean isCopy(int fileRevisionIndex) throws HgRuntimeException {
        if (fileRevisionIndex == -3) {
            fileRevisionIndex = this.getLastRevision();
        }
        if (HgInternals.wrongRevisionIndex(fileRevisionIndex) || fileRevisionIndex == Integer.MIN_VALUE || fileRevisionIndex == -2 || fileRevisionIndex == -1) {
            throw new HgInvalidRevisionException(fileRevisionIndex);
        }
        if (this.metadata == null || !this.metadata.checked(fileRevisionIndex)) {
            this.checkAndRecordMetadata(fileRevisionIndex);
        }
        if (!this.metadata.known(fileRevisionIndex)) {
            return false;
        }
        return this.metadata.find(fileRevisionIndex, "copy") != null;
    }

    public HgFileRevision getCopySource(int fileRevisionIndex) throws HgRuntimeException {
        if (fileRevisionIndex == -3) {
            fileRevisionIndex = this.getLastRevision();
        }
        if (!this.isCopy(fileRevisionIndex)) {
            throw new UnsupportedOperationException();
        }
        Path.Source ps = this.getRepo().getSessionContext().getPathFactory();
        Path origin = ps.path(this.metadata.find(fileRevisionIndex, "copy"));
        Nodeid originRev = Nodeid.fromAscii(this.metadata.find(fileRevisionIndex, "copyrev"));
        return new HgFileRevision(this.getRepo(), originRev, null, origin);
    }

    public HgManifest.Flags getFlags(int fileRevisionIndex) throws HgRuntimeException {
        int changesetRevIndex = this.getChangesetRevisionIndex(fileRevisionIndex);
        return this.getRepo().getManifest().getFileFlags(changesetRevIndex, this.getPath());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append('(');
        sb.append(this.getPath());
        sb.append(')');
        return sb.toString();
    }

    private void checkAndRecordMetadata(int localRev) throws HgRuntimeException {
        int startRev;
        if (this.metadata == null) {
            this.metadata = new Metadata(this.getRepo());
            startRev = 0;
        } else {
            startRev = this.metadata.lastRevisionRead() + 1;
        }
        assert (localRev >= startRev);
        MetadataInspector insp = new MetadataInspector(this.metadata, null);
        this.content.iterate(startRev, localRev, true, insp);
    }

    private static class MetadataInspector
    extends Revlog.ErrorHandlingInspector
    implements RevlogStream.Inspector {
        private final Metadata metadata;
        private final RevlogStream.Inspector delegate;

        public MetadataInspector(Metadata _metadata, RevlogStream.Inspector chain) {
            this.metadata = _metadata;
            this.delegate = chain;
            this.setCancelSupport(CancelSupport.Factory.get(chain));
        }

        @Override
        public void next(int revisionNumber, int actualLen, int baseRevision, int linkRevision, int parent1Revision, int parent2Revision, byte[] nodeid, DataAccess data) throws HgRuntimeException {
            try {
                boolean gotMetadata = this.metadata.tryRead(revisionNumber, data);
                if (this.delegate != null) {
                    data.reset();
                    if (gotMetadata) {
                        int offset = this.metadata.dataOffset(revisionNumber);
                        data = new FilterDataAccess(data, offset, data.length() - offset);
                    }
                    this.delegate.next(revisionNumber, actualLen, baseRevision, linkRevision, parent1Revision, parent2Revision, nodeid, data);
                }
            }
            catch (IOException ex) {
                this.recordFailure(ex);
            }
            catch (HgInvalidControlFileException ex) {
                this.recordFailure(ex.isRevisionIndexSet() ? ex : ex.setRevisionIndex(revisionNumber));
            }
        }

        @Override
        public void checkFailed() throws HgRuntimeException, IOException, CancelledException {
            super.checkFailed();
            if (this.delegate instanceof Revlog.ErrorHandlingInspector) {
                ((Revlog.ErrorHandlingInspector)this.delegate).checkFailed();
            }
        }
    }
}

