/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.repo;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.internal.DirstateReader;
import org.tmatesoft.hg.internal.Internals;
import org.tmatesoft.hg.repo.HgInvalidControlFileException;
import org.tmatesoft.hg.repo.HgInvalidStateException;
import org.tmatesoft.hg.util.Pair;
import org.tmatesoft.hg.util.Path;
import org.tmatesoft.hg.util.PathRewrite;

public final class HgDirstate {
    private final Internals repo;
    private final Path.Source pathPool;
    private final PathRewrite canonicalPathRewrite;
    private Map<Path, Record> normal;
    private Map<Path, Record> added;
    private Map<Path, Record> removed;
    private Map<Path, Record> merged;
    private Map<Path, Path> canonical2dirstateName;
    private Pair<Nodeid, Nodeid> parents;

    HgDirstate(Internals hgRepo, Path.Source pathSource, PathRewrite canonicalPath) {
        this.repo = hgRepo;
        this.pathPool = pathSource;
        this.canonicalPathRewrite = canonicalPath;
    }

    void read() throws HgInvalidControlFileException {
        this.merged = Collections.emptyMap();
        this.removed = this.merged;
        this.added = this.merged;
        this.normal = this.merged;
        this.parents = new Pair<Nodeid, Nodeid>(Nodeid.NULL, Nodeid.NULL);
        this.canonical2dirstateName = this.canonicalPathRewrite != null ? new HashMap<Path, Path>() : Collections.emptyMap();
        this.normal = new LinkedHashMap<Path, Record>();
        this.added = new LinkedHashMap<Path, Record>();
        this.removed = new LinkedHashMap<Path, Record>();
        this.merged = new LinkedHashMap<Path, Record>();
        DirstateReader dirstateReader = new DirstateReader(this.repo, this.pathPool);
        dirstateReader.readInto(new Inspector(){

            @Override
            public boolean next(EntryKind kind, Record r) {
                if (HgDirstate.this.canonicalPathRewrite != null) {
                    Path canonicalPath = HgDirstate.this.pathPool.path(HgDirstate.this.canonicalPathRewrite.rewrite(r.name()));
                    if (canonicalPath != r.name()) {
                        if (!$assertionsDisabled && HgDirstate.this.canonical2dirstateName.containsKey(canonicalPath)) {
                            throw new AssertionError();
                        }
                        HgDirstate.this.canonical2dirstateName.put(canonicalPath, r.name());
                    }
                    if (r.copySource() != null && (canonicalPath = HgDirstate.this.pathPool.path(HgDirstate.this.canonicalPathRewrite.rewrite(r.copySource()))) != r.copySource()) {
                        HgDirstate.this.canonical2dirstateName.put(canonicalPath, r.copySource());
                    }
                }
                switch (kind) {
                    case Normal: {
                        HgDirstate.this.normal.put(r.name(), r);
                        break;
                    }
                    case Added: {
                        HgDirstate.this.added.put(r.name(), r);
                        break;
                    }
                    case Removed: {
                        HgDirstate.this.removed.put(r.name(), r);
                        break;
                    }
                    case Merged: {
                        HgDirstate.this.merged.put(r.name1, r);
                        break;
                    }
                    default: {
                        throw new HgInvalidStateException(String.format("Unexpected entry in the dirstate: %s", new Object[]{kind}));
                    }
                }
                return true;
            }
        });
        this.parents = dirstateReader.parents();
    }

    public Pair<Nodeid, Nodeid> parents() {
        assert (this.parents != null);
        return this.parents;
    }

    TreeSet<Path> all() {
        assert (this.normal != null);
        TreeSet<Path> rv = new TreeSet<Path>();
        Map[] all = new Map[]{this.normal, this.added, this.removed, this.merged};
        int i = 0;
        while (i < all.length) {
            for (Record r : all[i].values()) {
                rv.add(r.name1);
            }
            ++i;
        }
        return rv;
    }

    Record checkNormal(Path fname) {
        return this.internalCheck(this.normal, fname);
    }

    Record checkAdded(Path fname) {
        return this.internalCheck(this.added, fname);
    }

    Record checkRemoved(Path fname) {
        return this.internalCheck(this.removed, fname);
    }

    Record checkMerged(Path fname) {
        return this.internalCheck(this.merged, fname);
    }

    Path known(Path fname) {
        Path fnameCanonical = null;
        if (this.canonicalPathRewrite != null && (fnameCanonical = this.pathPool.path(this.canonicalPathRewrite.rewrite(fname).toString())) != fname && this.canonical2dirstateName.containsKey(fnameCanonical)) {
            return this.canonical2dirstateName.get(fnameCanonical);
        }
        Map[] all = new Map[]{this.normal, this.added, this.removed, this.merged};
        int i = 0;
        while (i < all.length) {
            if (all[i].containsKey(fname)) {
                return fname;
            }
            if (fnameCanonical != null && all[i].containsKey(fnameCanonical)) {
                return fnameCanonical;
            }
            ++i;
        }
        return null;
    }

    private Record internalCheck(Map<Path, Record> map, Path fname) {
        Record rv = map.get(fname);
        if (rv != null || this.canonicalPathRewrite == null) {
            return rv;
        }
        Path fnameCanonical = this.pathPool.path(this.canonicalPathRewrite.rewrite(fname).toString());
        if (fnameCanonical != fname) {
            if (this.canonical2dirstateName.containsKey(fnameCanonical)) {
                return map.get(this.canonical2dirstateName.get(fnameCanonical));
            }
            rv = map.get(fnameCanonical);
            if (rv != null) {
                return rv;
            }
        }
        return null;
    }

    public void walk(Inspector inspector) {
        assert (this.normal != null);
        Map[] all = new Map[]{this.normal, this.added, this.removed, this.merged};
        int i = 0;
        while (i < all.length) {
            EntryKind k = EntryKind.values()[i];
            for (Record r : all[i].values()) {
                if (inspector.next(k, r)) continue;
                return;
            }
            ++i;
        }
    }

    public static enum EntryKind {
        Normal,
        Added,
        Removed,
        Merged;

    }

    public static interface Inspector {
        public boolean next(EntryKind var1, Record var2);
    }

    public static final class Record
    implements Cloneable {
        private final int mode;
        private final int size;
        private final int time;
        private final Path name1;
        private final Path name2;

        public Record(int fmode, int fsize, int ftime, Path name1, Path name2) {
            this.mode = fmode;
            this.size = fsize;
            this.time = ftime;
            this.name1 = name1;
            this.name2 = name2;
        }

        public Path name() {
            return this.name1;
        }

        public Path copySource() {
            return this.name2;
        }

        public int modificationTime() {
            return this.time;
        }

        public int size() {
            return this.size;
        }

        public int mode() {
            return this.mode;
        }

        public Record clone() {
            try {
                return (Record)super.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new InternalError(ex.toString());
            }
        }
    }
}

