/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.repo;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.tmatesoft.hg.internal.FileChangeMonitor;
import org.tmatesoft.hg.internal.Internals;
import org.tmatesoft.hg.repo.HgInvalidControlFileException;
import org.tmatesoft.hg.repo.HgRepositoryFiles;
import org.tmatesoft.hg.util.LogFacility;
import org.tmatesoft.hg.util.Path;
import org.tmatesoft.hg.util.PathRewrite;

public class HgIgnore
implements Path.Matcher {
    private List<Pattern> entries = Collections.emptyList();
    private final PathRewrite globPathHelper;
    private FileChangeMonitor ignoreFileTracker;
    private final Set<String> ignoredFirstFragments;

    HgIgnore(PathRewrite globPathRewrite) {
        this.globPathHelper = globPathRewrite;
        this.ignoredFirstFragments = new HashSet<String>();
    }

    void read(Internals repo) throws HgInvalidControlFileException {
        File ignoreFile = repo.getRepositoryFile(HgRepositoryFiles.HgIgnore);
        BufferedReader fr = null;
        try {
            try {
                List<String> errors;
                if (ignoreFile.canRead() && ignoreFile.isFile() && (errors = this.read(fr = new BufferedReader(new FileReader(ignoreFile)))) != null) {
                    repo.getLog().dump(this.getClass(), LogFacility.Severity.Warn, "Syntax errors parsing %s:\n%s", ignoreFile.getName(), Internals.join(errors, ",\n"));
                }
                if (this.ignoreFileTracker == null) {
                    this.ignoreFileTracker = new FileChangeMonitor(ignoreFile);
                }
                this.ignoreFileTracker.touch(this);
            }
            catch (IOException ex) {
                String m = String.format("Error reading %s file", ignoreFile);
                throw new HgInvalidControlFileException(m, ex, ignoreFile);
            }
        }
        finally {
            try {
                if (fr != null) {
                    fr.close();
                }
            }
            catch (IOException ex) {
                repo.getLog().dump(this.getClass(), LogFacility.Severity.Warn, ex, null);
            }
        }
    }

    void reloadIfChanged(Internals repo) throws HgInvalidControlFileException {
        assert (this.ignoreFileTracker != null);
        if (this.ignoreFileTracker.changed(this)) {
            this.entries = Collections.emptyList();
            this.read(repo);
        }
    }

    List<String> read(BufferedReader content) throws IOException {
        String line;
        ArrayList<String> errors = new ArrayList<String>();
        ArrayList<Pattern> result = new ArrayList<Pattern>(this.entries);
        String syntax = "regexp";
        while ((line = content.readLine()) != null) {
            String lineSyntax;
            int x;
            if ((line = line.trim()).startsWith("syntax:")) {
                syntax = line.substring("syntax:".length()).trim();
                if ("regexp".equals(syntax) || "glob".equals(syntax)) continue;
                errors.add(line);
                continue;
            }
            if (line.length() <= 0) continue;
            int s = 0;
            while ((x = line.indexOf(35, s)) >= 0) {
                if (x > 0 && line.charAt(x - 1) == '\\') {
                    line = line.substring(0, x - 1).concat(line.substring(x));
                    s = x;
                    continue;
                }
                line = line.substring(0, x).trim();
            }
            if (line.startsWith("glob:")) {
                line = line.substring("glob:".length()).trim();
                lineSyntax = "glob";
            } else if (line.startsWith("regexp:")) {
                line = line.substring("regexp:".length()).trim();
                lineSyntax = "regexp";
            } else if (line.startsWith("re:")) {
                line = line.substring("re:".length()).trim();
                lineSyntax = "regexp";
            } else {
                lineSyntax = syntax;
            }
            if (line.length() == 0) continue;
            if ("glob".equals(lineSyntax)) {
                if (this.globPathHelper != null) {
                    line = this.globPathHelper.rewrite(line).toString();
                }
                line = HgIgnore.glob2regex(line);
            } else {
                assert ("regexp".equals(lineSyntax));
                line = line.charAt(0) == '^' ? line : ".*" + line;
            }
            try {
                result.add(Pattern.compile(line));
            }
            catch (PatternSyntaxException ex) {
                errors.add(String.valueOf(line) + "@" + ex.getMessage());
            }
        }
        result.trimToSize();
        this.entries = result;
        return errors.isEmpty() ? null : errors;
    }

    /*
     * Unable to fully structure code
     */
    private static String glob2regex(String line) {
        if (!HgIgnore.$assertionsDisabled && line.length() <= 0) {
            throw new AssertionError();
        }
        sb = new StringBuilder(line.length() + 10);
        start = 0;
        end = line.length() - 1;
        sb.append("(?:|.*/)");
        inCurly = 0;
        i = start;
        while (i <= end) {
            block7: {
                block10: {
                    block9: {
                        block8: {
                            block6: {
                                block5: {
                                    ch = line.charAt(i);
                                    if (ch != '.' && ch != '\\') break block5;
                                    sb.append('\\');
                                    ** GOTO lbl-1000
                                }
                                if (ch != '?') break block6;
                                sb.append("[^/]");
                                break block7;
                            }
                            if (ch != '*') break block8;
                            sb.append("[^/]*?");
                            break block7;
                        }
                        if (ch != '{') break block9;
                        ++inCurly;
                        sb.append('(');
                        break block7;
                    }
                    if (ch != '}') break block10;
                    if (inCurly <= 0) ** GOTO lbl-1000
                    --inCurly;
                    sb.append(')');
                    break block7;
                }
                if (ch == ',' && inCurly > 0) {
                    sb.append('|');
                } else lbl-1000:
                // 3 sources

                {
                    sb.append(ch);
                }
            }
            ++i;
        }
        if (sb.charAt(sb.length() - 1) != '/') {
            sb.append('$');
        }
        return sb.toString();
    }

    public boolean isIgnored(Path path) {
        String ps = path.toString();
        int x = ps.indexOf(47);
        if (x != -1 && this.ignoredFirstFragments.contains(ps.substring(0, x))) {
            return true;
        }
        for (Pattern p : this.entries) {
            if (!p.matcher(ps).find()) continue;
            return true;
        }
        boolean firstFragment = true;
        while (x != -1 && x + 1 != ps.length()) {
            String fragment = ps.substring(0, x);
            for (Pattern p : this.entries) {
                if (!p.matcher(fragment).matches()) continue;
                if (firstFragment) {
                    this.ignoredFirstFragments.add(new String(fragment));
                }
                return true;
            }
            x = ps.indexOf(47, x + 1);
            firstFragment = false;
        }
        return false;
    }

    @Override
    public boolean accept(Path path) {
        return this.isIgnored(path);
    }
}

