/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.repo;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.internal.Internals;
import org.tmatesoft.hg.internal.Patch;
import org.tmatesoft.hg.internal.RelativePathRewrite;
import org.tmatesoft.hg.internal.WinToNixPathRewrite;
import org.tmatesoft.hg.repo.HgBundle;
import org.tmatesoft.hg.repo.HgDirstate;
import org.tmatesoft.hg.repo.HgIgnore;
import org.tmatesoft.hg.repo.HgInvalidControlFileException;
import org.tmatesoft.hg.repo.HgInvalidRevisionException;
import org.tmatesoft.hg.repo.HgRepository;
import org.tmatesoft.hg.repo.HgSubrepoLocation;
import org.tmatesoft.hg.util.FileIterator;
import org.tmatesoft.hg.util.FileWalker;
import org.tmatesoft.hg.util.Path;
import org.tmatesoft.hg.util.PathRewrite;

public class HgInternals {
    private final HgRepository repo;

    public HgInternals(HgRepository hgRepo) {
        this.repo = hgRepo;
    }

    public HgDirstate getDirstate() throws HgInvalidControlFileException {
        return this.repo.loadDirstate(new Path.SimpleSource());
    }

    public HgDirstate createDirstate(boolean caseSensitiveFileSystem) throws HgInvalidControlFileException {
        PathRewrite canonicalPath = null;
        if (!caseSensitiveFileSystem) {
            canonicalPath = new PathRewrite(){

                @Override
                public CharSequence rewrite(CharSequence path) {
                    return path.toString().toLowerCase();
                }
            };
        }
        HgDirstate ds = new HgDirstate(this.repo.getImplHelper(), new Path.SimpleSource(), canonicalPath);
        ds.read();
        return ds;
    }

    public Path[] checkKnown(HgDirstate dirstate, Path[] toCheck) {
        Path[] rv = new Path[toCheck.length];
        int i = 0;
        while (i < toCheck.length) {
            rv[i] = dirstate.known(toCheck[i]);
            ++i;
        }
        return rv;
    }

    public HgSubrepoLocation newSubrepo(Path loc, String src, HgSubrepoLocation.Kind kind, Nodeid rev) {
        return new HgSubrepoLocation(this.repo, loc, src, kind, rev);
    }

    public static Internals getImplementationRepo(HgRepository hgRepo) {
        return hgRepo.getImplHelper();
    }

    public static HgIgnore newHgIgnore(Reader source, PathRewrite globPathRewrite) throws IOException {
        if (globPathRewrite == null) {
            globPathRewrite = Internals.runningOnWindows() ? new WinToNixPathRewrite() : new PathRewrite.Empty();
        }
        HgIgnore hgIgnore = new HgIgnore(globPathRewrite);
        BufferedReader br = source instanceof BufferedReader ? (BufferedReader)source : new BufferedReader(source);
        hgIgnore.read(br);
        br.close();
        return hgIgnore;
    }

    public static Patch patchFromData(HgBundle.GroupElement ge) throws IOException {
        return ge.patch();
    }

    public static File getBundleFile(HgBundle bundle) {
        return bundle.bundleFile;
    }

    public String getNextCommitUsername() {
        String hgUser = System.getenv("HGUSER");
        if (hgUser != null && hgUser.trim().length() > 0) {
            return hgUser.trim();
        }
        String configValue = this.repo.getConfiguration().getStringValue("ui", "username", null);
        if (configValue != null) {
            return configValue;
        }
        String email = System.getenv("EMAIL");
        if (email != null && email.trim().length() > 0) {
            return email;
        }
        String username = System.getProperty("user.name");
        try {
            String hostname = InetAddress.getLocalHost().getHostName();
            return String.valueOf(username) + '@' + hostname;
        }
        catch (UnknownHostException unknownHostException) {
            return username;
        }
    }

    FileIterator createWorkingDirWalker(Path.Matcher workindDirScope) {
        File repoRoot = this.repo.getWorkingDir();
        Path.SimpleSource pathSrc = new Path.SimpleSource(new PathRewrite.Composite(new RelativePathRewrite(repoRoot), this.repo.getToRepoPathHelper()));
        return new FileWalker(this.repo, repoRoot, (Path.Source)pathSrc, workindDirScope);
    }

    public static boolean wrongRevisionIndex(int rev) {
        return rev < 0 && rev != -3 && rev != -2 && rev != Integer.MIN_VALUE && rev != -1;
    }

    public static void checkRevlogRange(int start, int end, int lastRevision) throws HgInvalidRevisionException {
        if (start < 0 || start > lastRevision) {
            String m = String.format("Bad left range boundary %d in [0..%d]", start, lastRevision);
            throw new HgInvalidRevisionException(m, null, start).setRevisionIndex(start, 0, lastRevision);
        }
        if (end < 0 || end > lastRevision) {
            String m = String.format("Bad right range boundary %d in [0..%d]", end, lastRevision);
            throw new HgInvalidRevisionException(m, null, end).setRevisionIndex(end, 0, lastRevision);
        }
        if (end < start) {
            throw new IllegalArgumentException(String.format("Bad range [%d..%d]", start, end));
        }
    }
}

