/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.repo;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.tmatesoft.hg.core.HgBadArgumentException;
import org.tmatesoft.hg.core.HgIOException;
import org.tmatesoft.hg.core.HgRepositoryNotFoundException;
import org.tmatesoft.hg.core.SessionContext;
import org.tmatesoft.hg.internal.BasicSessionContext;
import org.tmatesoft.hg.internal.ConfigFile;
import org.tmatesoft.hg.internal.DataAccessProvider;
import org.tmatesoft.hg.repo.HgBundle;
import org.tmatesoft.hg.repo.HgRemoteRepository;
import org.tmatesoft.hg.repo.HgRepoConfig;
import org.tmatesoft.hg.repo.HgRepository;
import org.tmatesoft.hg.repo.HgRuntimeException;
import org.tmatesoft.hg.util.LogFacility;

public class HgLookup
implements SessionContext.Source {
    private ConfigFile globalCfg;
    private SessionContext sessionContext;

    public HgLookup() {
    }

    public HgLookup(SessionContext ctx) {
        this.sessionContext = ctx;
    }

    public HgRepository detectFromWorkingDir() throws HgRepositoryNotFoundException {
        return this.detect(System.getProperty("user.dir"));
    }

    public HgRepository detect(String location) throws HgRepositoryNotFoundException {
        return this.detect(new File(location));
    }

    public HgRepository detect(File location) throws HgRepositoryNotFoundException {
        File repository;
        File dir = location.getAbsoluteFile();
        while (!(repository = new File(dir, ".hg")).exists() || !repository.isDirectory()) {
            repository = null;
            if ((dir = dir.getParentFile()) != null) continue;
        }
        if (repository == null) {
            throw new HgRepositoryNotFoundException(String.format("Can't locate .hg/ directory of Mercurial repository in %s nor in parent dirs", location)).setLocation(location.getPath());
        }
        try {
            String repoPath = repository.getParentFile().getAbsolutePath();
            HgRepository rv = new HgRepository(this.getSessionContext(), repoPath, repository);
            int requiresFlags = rv.getImplHelper().getRequiresFlags();
            if ((requiresFlags & 0x40000000) == 0) {
                throw new HgRepositoryNotFoundException(String.format("%s: repository version is not supported (Mercurial <0.9?)", repoPath)).setLocation(location.getPath());
            }
            return rv;
        }
        catch (HgRuntimeException ex) {
            HgRepositoryNotFoundException e = new HgRepositoryNotFoundException("Failed to initialize Hg4J library").setLocation(location.getPath());
            e.initCause(ex);
            throw e;
        }
    }

    public HgBundle loadBundle(File location) throws HgRepositoryNotFoundException {
        if (location == null || !location.canRead()) {
            throw new HgRepositoryNotFoundException(String.format("Can't read file %s", location)).setLocation(String.valueOf(location));
        }
        return new HgBundle(this.getSessionContext(), new DataAccessProvider(this.getSessionContext()), location).link();
    }

    public HgRemoteRepository detectRemote(String key, HgRepository hgRepo) throws HgBadArgumentException {
        URISyntaxException toReport;
        URI uri;
        try {
            uri = new URI(key);
            toReport = null;
        }
        catch (URISyntaxException ex) {
            uri = null;
            toReport = ex;
        }
        if (uri == null) {
            String server = null;
            if (hgRepo != null && !hgRepo.isInvalid()) {
                HgRepoConfig.PathsSection ps = hgRepo.getConfiguration().getPaths();
                server = key == null || key.trim().length() == 0 ? ps.getDefault() : ps.getString(key, null);
            } else if (key == null || key.trim().length() == 0) {
                throw new HgBadArgumentException("Can't look up empty key in a global configuration", null);
            }
            if (server == null) {
                server = this.getGlobalConfig().getSection("paths").get(key);
            }
            if (server == null) {
                throw new HgBadArgumentException(String.format("Can't find server %s specification in the config", key), toReport);
            }
            try {
                uri = new URI(server);
            }
            catch (URISyntaxException ex) {
                throw new HgBadArgumentException(String.format("Found %s server spec in the config, but failed to initialize with it", key), ex);
            }
        }
        return this.detectRemote(uri);
    }

    public HgRemoteRepository detect(URL url) throws HgBadArgumentException {
        if (url == null) {
            throw new IllegalArgumentException();
        }
        try {
            return this.detectRemote(url.toURI());
        }
        catch (URISyntaxException ex) {
            throw new HgBadArgumentException(String.format("Bad remote repository location: %s", url), ex);
        }
    }

    public HgRemoteRepository detectRemote(URI uriRemote) throws HgBadArgumentException {
        HgRemoteRepository.RemoteDescriptor rd = this.getSessionContext().getRemoteDescriptor(uriRemote);
        if (rd == null) {
            throw new HgBadArgumentException(String.format("Unsupported remote repository location:%s", uriRemote), null);
        }
        return new HgRemoteRepository(this.getSessionContext(), rd);
    }

    private ConfigFile getGlobalConfig() {
        if (this.globalCfg == null) {
            this.globalCfg = new ConfigFile(this.getSessionContext());
            try {
                this.globalCfg.addLocation(new File(System.getProperty("user.home"), ".hgrc"));
            }
            catch (HgIOException ex) {
                this.getSessionContext().getLog().dump(this.getClass(), LogFacility.Severity.Warn, ex, null);
            }
        }
        return this.globalCfg;
    }

    @Override
    public SessionContext getSessionContext() {
        if (this.sessionContext == null) {
            this.sessionContext = new BasicSessionContext(null);
        }
        return this.sessionContext;
    }
}

