/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.repo;

import java.io.IOException;
import java.util.Arrays;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.internal.ByteVector;
import org.tmatesoft.hg.internal.DataAccess;
import org.tmatesoft.hg.internal.DigestHelper;
import org.tmatesoft.hg.internal.EncodingHelper;
import org.tmatesoft.hg.internal.IdentityPool;
import org.tmatesoft.hg.internal.IntMap;
import org.tmatesoft.hg.internal.IntVector;
import org.tmatesoft.hg.internal.IterateControlMediator;
import org.tmatesoft.hg.internal.Lifecycle;
import org.tmatesoft.hg.internal.RevisionLookup;
import org.tmatesoft.hg.internal.RevlogStream;
import org.tmatesoft.hg.repo.HgChangelog;
import org.tmatesoft.hg.repo.HgInternals;
import org.tmatesoft.hg.repo.HgInvalidControlFileException;
import org.tmatesoft.hg.repo.HgInvalidRevisionException;
import org.tmatesoft.hg.repo.HgInvalidStateException;
import org.tmatesoft.hg.repo.HgRepository;
import org.tmatesoft.hg.repo.HgRuntimeException;
import org.tmatesoft.hg.repo.Revlog;
import org.tmatesoft.hg.util.CancelSupport;
import org.tmatesoft.hg.util.LogFacility;
import org.tmatesoft.hg.util.Path;
import org.tmatesoft.hg.util.ProgressSupport;

public final class HgManifest
extends Revlog {
    private RevisionMapper revisionMap;
    private final EncodingHelper encodingHelper;
    private final Path.Source pathFactory;
    private final RevlogStream.Observer revisionMapCleaner = new RevlogStream.Observer(){

        @Override
        public void reloaded(RevlogStream src) {
            HgManifest.this.revisionMap = null;
        }
    };

    HgManifest(HgRepository hgRepo, RevlogStream content, EncodingHelper eh) {
        super(hgRepo, content, true);
        this.encodingHelper = eh;
        this.pathFactory = hgRepo.getSessionContext().getPathFactory();
    }

    public void walk(int start, int end, Inspector inspector) throws HgRuntimeException, IllegalArgumentException {
        int manifestLast;
        int manifestFirst;
        if (inspector == null) {
            throw new IllegalArgumentException();
        }
        int csetFirst = start <= end ? start : end;
        int csetLast = start > end ? start : end;
        int i = 0;
        do {
            if ((manifestFirst = this.fromChangelog(csetFirst + i)) != Integer.MIN_VALUE) continue;
            inspector.begin(-1, Nodeid.NULL, csetFirst + i);
            inspector.end(-1);
        } while (manifestFirst == Integer.MIN_VALUE && csetFirst + ++i <= csetLast);
        if (manifestFirst == Integer.MIN_VALUE) {
            this.getRepo().getSessionContext().getLog().dump(this.getClass(), LogFacility.Severity.Info, "None of changesets [%d..%d] have associated manifest revision", csetFirst, csetLast);
            return;
        }
        i = 0;
        do {
            if ((manifestLast = this.fromChangelog(csetLast - i)) != Integer.MIN_VALUE) continue;
            inspector.begin(-1, Nodeid.NULL, csetLast - i);
            inspector.end(-1);
        } while (manifestLast == Integer.MIN_VALUE && csetLast - ++i >= csetFirst);
        if (manifestLast == Integer.MIN_VALUE) {
            throw new HgInvalidStateException(String.format("Manifest %d-%d(!) for cset range [%d..%d] ", manifestFirst, manifestLast, csetFirst, csetLast));
        }
        if (manifestLast < manifestFirst) {
            int x = manifestLast;
            manifestLast = manifestFirst;
            manifestFirst = x;
        }
        this.content.iterate(manifestFirst, manifestLast, true, new ManifestParser(inspector));
    }

    public void walk(Inspector inspector, int ... revisionIndexes) throws HgRuntimeException, IllegalArgumentException {
        if (inspector == null || revisionIndexes == null) {
            throw new IllegalArgumentException();
        }
        int[] manifestRevs = this.toManifestRevisionIndexes(revisionIndexes, inspector);
        this.content.iterate(manifestRevs, true, new ManifestParser(inspector));
    }

    int fromChangelog(int changesetRevisionIndex) throws HgRuntimeException {
        if (HgInternals.wrongRevisionIndex(changesetRevisionIndex)) {
            throw new HgInvalidRevisionException(changesetRevisionIndex);
        }
        if (changesetRevisionIndex == -2 || changesetRevisionIndex == Integer.MIN_VALUE) {
            throw new HgInvalidRevisionException("Can't use constants like WORKING_COPY or BAD_REVISION", null, changesetRevisionIndex);
        }
        if (this.revisionMap == null || this.content.shallDropDerivedCaches()) {
            this.content.detach(this.revisionMapCleaner);
            boolean buildOwnLookup = this.revisionLookup == null;
            RevisionMapper rmap = new RevisionMapper(buildOwnLookup);
            this.content.iterate(0, -3, false, rmap);
            rmap.fixReusedManifests();
            if (buildOwnLookup && this.useRevisionLookup) {
                super.setRevisionLookup(rmap.manifestNodeids);
            }
            rmap.manifestNodeids = null;
            this.revisionMap = rmap;
            this.content.attach(this.revisionMapCleaner);
        }
        return this.revisionMap.at(changesetRevisionIndex);
    }

    public Nodeid getFileRevision(int changelogRevisionIndex, Path file) throws HgRuntimeException {
        int manifestRevIndex = this.fromChangelog(changelogRevisionIndex);
        if (manifestRevIndex == Integer.MIN_VALUE) {
            return null;
        }
        IntMap<Nodeid> resMap = new IntMap<Nodeid>(3);
        FileLookupInspector parser = new FileLookupInspector(this.encodingHelper, file, resMap, null);
        parser.walk(manifestRevIndex, this.content);
        assert (resMap.size() <= 1);
        return resMap.size() == 0 ? null : resMap.get(resMap.firstKey());
    }

    public void walkFileRevisions(Path file, Inspector inspector, int ... changelogRevisionIndexes) throws HgRuntimeException {
        if (file == null || inspector == null || changelogRevisionIndexes == null) {
            throw new IllegalArgumentException();
        }
        int[] manifestRevIndexes = this.toManifestRevisionIndexes(changelogRevisionIndexes, null);
        FileLookupInspector parser = new FileLookupInspector(this.encodingHelper, file, inspector);
        parser.walk(manifestRevIndexes, this.content);
    }

    public Flags getFileFlags(int changesetRevIndex, Path file) throws HgRuntimeException {
        int manifestRevIdx = this.fromChangelog(changesetRevIndex);
        IntMap<Flags> resMap = new IntMap<Flags>(2);
        FileLookupInspector parser = new FileLookupInspector(this.encodingHelper, file, null, resMap);
        parser.walk(manifestRevIdx, this.content);
        assert (resMap.size() <= 1);
        return resMap.size() == 0 ? null : resMap.get(resMap.firstKey());
    }

    void dropCachesOnChangelogChange() {
        this.revisionMap = null;
    }

    private int[] toManifestRevisionIndexes(int[] changelogRevisionIndexes, Inspector inspector) throws HgRuntimeException {
        int[] manifestRevs = new int[changelogRevisionIndexes.length];
        boolean needsSort = false;
        int j = 0;
        int i = 0;
        while (i < changelogRevisionIndexes.length) {
            int manifestRevisionIndex = this.fromChangelog(changelogRevisionIndexes[i]);
            if (manifestRevisionIndex == Integer.MIN_VALUE) {
                if (inspector != null) {
                    inspector.begin(-1, Nodeid.NULL, changelogRevisionIndexes[i]);
                    inspector.end(-1);
                }
            } else {
                manifestRevs[j] = manifestRevisionIndex;
                if (j > 0 && manifestRevs[j - 1] > manifestRevisionIndex) {
                    needsSort = true;
                }
                ++j;
            }
            ++i;
        }
        if (needsSort) {
            Arrays.sort(manifestRevs, 0, j);
        }
        if (j == manifestRevs.length) {
            return manifestRevs;
        }
        int[] rv = new int[j];
        System.arraycopy(manifestRevs, 0, rv, 0, j);
        return rv;
    }

    private static class FileLookupInspector
    implements RevlogStream.Inspector {
        private final Path filename;
        private final byte[] filenameAsBytes;
        private final IntMap<Nodeid> csetIndex2FileRev;
        private final IntMap<Flags> csetIndex2Flags;
        private final Inspector delegate;

        public FileLookupInspector(EncodingHelper eh, Path fileToLookUp, IntMap<Nodeid> csetIndex2FileRevMap, IntMap<Flags> csetIndex2FlagsMap) {
            assert (fileToLookUp != null);
            assert (csetIndex2FileRevMap != null || csetIndex2FlagsMap != null);
            this.filename = fileToLookUp;
            this.filenameAsBytes = eh.toManifest(fileToLookUp.toString());
            this.delegate = null;
            this.csetIndex2FileRev = csetIndex2FileRevMap;
            this.csetIndex2Flags = csetIndex2FlagsMap;
        }

        public FileLookupInspector(EncodingHelper eh, Path fileToLookUp, Inspector delegateInspector) {
            assert (fileToLookUp != null);
            assert (delegateInspector != null);
            this.filename = fileToLookUp;
            this.filenameAsBytes = eh.toManifest(fileToLookUp.toString());
            this.delegate = delegateInspector;
            this.csetIndex2FileRev = null;
            this.csetIndex2Flags = null;
        }

        void walk(int manifestRevIndex, RevlogStream content) throws HgRuntimeException {
            content.iterate(manifestRevIndex, manifestRevIndex, true, this);
        }

        void walk(int[] manifestRevIndexes, RevlogStream content) throws HgRuntimeException {
            content.iterate(manifestRevIndexes, true, this);
        }

        @Override
        public void next(int revisionNumber, int actualLen, int baseRevision, int linkRevision, int parent1Revision, int parent2Revision, byte[] nodeid, DataAccess data) throws HgRuntimeException {
            ByteVector byteVector = new ByteVector(256, 128);
            try {
                byte b;
                while (!data.isEmpty() && (b = data.readByte()) != 10) {
                    if (b != 0) {
                        byteVector.add(b);
                        continue;
                    }
                    if (byteVector.equalsTo(this.filenameAsBytes)) {
                        Nodeid fileRev = null;
                        Flags flags = null;
                        if (this.csetIndex2FileRev != null || this.delegate != null) {
                            byte[] nid = new byte[40];
                            data.readBytes(nid, 0, 40);
                            fileRev = Nodeid.fromAscii(nid, 0, 40);
                        } else {
                            data.skip(40);
                        }
                        if (this.csetIndex2Flags != null || this.delegate != null) {
                            byteVector.clear();
                            while (!data.isEmpty() && (b = data.readByte()) != 10) {
                                byteVector.add(b);
                            }
                            flags = byteVector.size() == 0 ? Flags.RegularFile : Flags.parse(byteVector.toByteArray(), 0, byteVector.size());
                        }
                        if (this.delegate != null) {
                            assert (flags != null);
                            assert (fileRev != null);
                            this.delegate.begin(revisionNumber, Nodeid.fromBinary(nodeid, 0), linkRevision);
                            this.delegate.next(fileRev, this.filename, flags);
                            this.delegate.end(revisionNumber);
                        } else {
                            if (this.csetIndex2FileRev != null) {
                                this.csetIndex2FileRev.put(linkRevision, fileRev);
                            }
                            if (this.csetIndex2Flags != null) {
                                this.csetIndex2Flags.put(linkRevision, flags);
                            }
                        }
                        break;
                    }
                    data.skip(40);
                    while (!data.isEmpty() && (b = data.readByte()) != 10) {
                    }
                    byteVector.clear();
                }
            }
            catch (IOException ex) {
                throw new HgInvalidControlFileException("Failed reading manifest", ex, null);
            }
        }
    }

    public static enum Flags {
        Exec,
        Link,
        RegularFile;


        static Flags parse(String flags) {
            if ("x".equalsIgnoreCase(flags)) {
                return Exec;
            }
            if ("l".equalsIgnoreCase(flags)) {
                return Link;
            }
            if (flags == null) {
                return RegularFile;
            }
            throw new IllegalStateException(flags);
        }

        static Flags parse(byte[] data, int start, int length) {
            if (length == 0) {
                return RegularFile;
            }
            if (length == 1) {
                if (data[start] == 120) {
                    return Exec;
                }
                if (data[start] == 108) {
                    return Link;
                }
            }
            throw new IllegalStateException(new String(data, start, length));
        }

        static Flags parse(int dirstateFileMode) {
            if ((dirstateFileMode & 0xA000) == 40960) {
                return Link;
            }
            if ((dirstateFileMode & 0x40) == 64) {
                return Exec;
            }
            return RegularFile;
        }

        String nativeString() {
            if (this == Exec) {
                return "x";
            }
            if (this == Link) {
                return "l";
            }
            if (this == RegularFile) {
                return "";
            }
            throw new IllegalStateException(this.toString());
        }

        public int fsMode() {
            if (this == Exec) {
                return 493;
            }
            return 420;
        }
    }

    public static interface Inspector {
        public boolean begin(int var1, Nodeid var2, int var3) throws HgRuntimeException;

        public boolean next(Nodeid var1, Path var2, Flags var3) throws HgRuntimeException;

        public boolean end(int var1) throws HgRuntimeException;
    }

    private class ManifestParser
    implements RevlogStream.Inspector,
    Lifecycle {
        private final Inspector inspector;
        private IdentityPool<Nodeid> nodeidPool;
        private IdentityPool<Nodeid> thisRevPool;
        private final IdentityPool<PathProxy> fnamePool;
        private byte[] nodeidLookupBuffer = new byte[20];
        private final ProgressSupport progressHelper;
        private IterateControlMediator iterateControl;

        public ManifestParser(Inspector delegate) {
            assert (delegate != null);
            this.inspector = delegate;
            this.nodeidPool = new IdentityPool();
            this.fnamePool = new IdentityPool();
            this.thisRevPool = new IdentityPool();
            this.progressHelper = ProgressSupport.Factory.get(delegate);
        }

        @Override
        public void next(int revisionNumber, int actualLen, int baseRevision, int linkRevision, int parent1Revision, int parent2Revision, byte[] nodeid, DataAccess da) throws HgRuntimeException {
            try {
                if (!this.inspector.begin(revisionNumber, new Nodeid(nodeid, true), linkRevision)) {
                    this.iterateControl.stop();
                    return;
                }
                if (!da.isEmpty()) {
                    Path fname = null;
                    Flags flags = null;
                    Nodeid nid = null;
                    byte[] data = da.byteArray();
                    int i = 0;
                    while (i < actualLen) {
                        int x = i;
                        while (data[i] != 10 && i < actualLen) {
                            if (fname == null && data[i] == 0) {
                                PathProxy px = this.fnamePool.unify(new PathProxy(data, x, i - x));
                                fname = px.freeze();
                                x = i + 1;
                            }
                            ++i;
                        }
                        if (i < actualLen) {
                            assert (data[i] == 10);
                            int nodeidLen = i - x < 40 ? i - x : 40;
                            DigestHelper.ascii2bin(data, x, nodeidLen, this.nodeidLookupBuffer);
                            nid = new Nodeid(this.nodeidLookupBuffer, false);
                            Nodeid cached = this.nodeidPool.unify(nid);
                            if (cached == nid) {
                                this.nodeidLookupBuffer = new byte[20];
                            } else {
                                nid = cached;
                            }
                            this.thisRevPool.record(nid);
                            flags = nodeidLen + x < i ? Flags.parse(data, x + nodeidLen, i - x - nodeidLen) : Flags.RegularFile;
                            boolean good2go = this.inspector.next(nid, fname, flags);
                            if (!good2go) {
                                this.iterateControl.stop();
                                return;
                            }
                        }
                        nid = null;
                        fname = null;
                        flags = null;
                        ++i;
                    }
                }
                if (!this.inspector.end(revisionNumber)) {
                    this.iterateControl.stop();
                    return;
                }
                this.nodeidPool.clear();
                IdentityPool<Nodeid> t = this.nodeidPool;
                this.nodeidPool = this.thisRevPool;
                this.thisRevPool = t;
                this.iterateControl.checkCancelled();
                this.progressHelper.worked(1);
            }
            catch (IOException ex) {
                throw new HgInvalidControlFileException("Failed reading manifest", ex, null).setRevisionIndex(revisionNumber);
            }
        }

        @Override
        public void start(int count, Lifecycle.Callback callback, Object token) {
            CancelSupport cs = CancelSupport.Factory.get(this.inspector, null);
            this.iterateControl = new IterateControlMediator(cs, callback);
            this.progressHelper.start(count);
        }

        @Override
        public void finish(Object token) {
            this.progressHelper.done();
        }
    }

    private final class PathProxy {
        private byte[] data;
        private int start;
        private final int hash;
        private final int length;
        private Path result;

        public PathProxy(byte[] data, int start, int length) {
            this.data = data;
            this.start = start;
            this.length = length;
            int h = 0;
            byte[] d = data;
            int i = 0;
            int off = start;
            int len = length;
            while (i < len) {
                h = 31 * h + d[off++];
                ++i;
            }
            this.hash = h;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PathProxy)) {
                return false;
            }
            PathProxy o = (PathProxy)obj;
            if (o.result != null && this.result != null) {
                return this.result.equals(o.result);
            }
            if (o.length != this.length || o.hash != this.hash) {
                return false;
            }
            int i = 0;
            int x = o.start;
            int y = this.start;
            while (i < this.length) {
                if (o.data[x++] != this.data[y++]) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public int hashCode() {
            return this.hash;
        }

        public Path freeze() {
            if (this.result == null) {
                Path.Source pf = HgManifest.this.pathFactory;
                this.result = pf.path(HgManifest.this.encodingHelper.fromManifest(this.data, this.start, this.length));
                byte[] d = new byte[this.length];
                System.arraycopy(this.data, this.start, d, 0, this.length);
                this.data = d;
                this.start = 0;
            }
            return this.result;
        }
    }

    private class RevisionMapper
    implements RevlogStream.Inspector,
    Lifecycle {
        private final int changelogRevisionCount;
        private int[] changelog2manifest;
        RevisionLookup manifestNodeids;

        private RevisionMapper(boolean useOwnRevisionLookup) throws HgRuntimeException {
            this.changelogRevisionCount = HgManifest.this.getRepo().getChangelog().getRevisionCount();
            if (useOwnRevisionLookup) {
                this.manifestNodeids = new RevisionLookup(HgManifest.this.content);
            }
        }

        public int at(int changesetRevisionIndex) throws HgInvalidRevisionException {
            if (changesetRevisionIndex == -3) {
                changesetRevisionIndex = this.changelogRevisionCount - 1;
            }
            if (changesetRevisionIndex >= this.changelogRevisionCount) {
                throw new HgInvalidRevisionException(changesetRevisionIndex);
            }
            if (this.changelog2manifest != null) {
                return this.changelog2manifest[changesetRevisionIndex];
            }
            return changesetRevisionIndex;
        }

        @Override
        public void next(int revisionNumber, int actualLen, int baseRevision, int linkRevision, int parent1Revision, int parent2Revision, byte[] nodeid, DataAccess data) throws HgInvalidRevisionException {
            if (linkRevision >= this.changelogRevisionCount) {
                String storeLock = HgManifest.this.getRepo().getStoreLock().readLockInfo();
                String message = String.format("Manifest revision %d references changeset %d, which is beyond known scope [0..%d). Lock: %s", revisionNumber, linkRevision, this.changelogRevisionCount, storeLock);
                throw new HgInvalidRevisionException(message, null, linkRevision);
            }
            if (this.changelog2manifest != null) {
                assert (this.changelog2manifest[linkRevision] == Integer.MIN_VALUE) : String.format("revision:%d, link:%d, already linked to revision:%d", revisionNumber, linkRevision, this.changelog2manifest[linkRevision]);
                this.changelog2manifest[linkRevision] = revisionNumber;
            } else if (revisionNumber != linkRevision) {
                this.changelog2manifest = new int[this.changelogRevisionCount];
                Arrays.fill(this.changelog2manifest, Integer.MIN_VALUE);
                int i = 0;
                while (i < revisionNumber) {
                    this.changelog2manifest[i] = i;
                    ++i;
                }
                this.changelog2manifest[linkRevision] = revisionNumber;
            }
            if (this.manifestNodeids != null) {
                this.manifestNodeids.next(revisionNumber, nodeid);
            }
        }

        @Override
        public void start(int count, Lifecycle.Callback callback, Object token) {
            if (count != this.changelogRevisionCount) {
                assert (count < this.changelogRevisionCount);
                this.changelog2manifest = new int[this.changelogRevisionCount];
                Arrays.fill(this.changelog2manifest, Integer.MIN_VALUE);
            }
            if (this.manifestNodeids != null) {
                this.manifestNodeids.prepare(count);
            }
        }

        @Override
        public void finish(Object token) {
        }

        public void fixReusedManifests() throws HgRuntimeException {
            if (this.changelog2manifest == null) {
                return;
            }
            IntVector undefinedChangelogRevision = new IntVector();
            int i = 0;
            while (i < this.changelog2manifest.length) {
                if (this.changelog2manifest[i] == Integer.MIN_VALUE) {
                    undefinedChangelogRevision.add(i);
                }
                ++i;
            }
            if (undefinedChangelogRevision.size() > 0) {
                final IntMap missingCsetToManifest = new IntMap(undefinedChangelogRevision.size());
                int[] undefinedClogRevs = undefinedChangelogRevision.toArray();
                HgManifest.this.getRepo().getChangelog().rangeInternal(new HgChangelog.Inspector(){

                    @Override
                    public void next(int revisionIndex, Nodeid nodeid, HgChangelog.RawChangeset cset) {
                        missingCsetToManifest.put(revisionIndex, cset.manifest());
                    }
                }, undefinedClogRevs);
                assert (missingCsetToManifest.size() == undefinedChangelogRevision.size());
                int[] nArray = undefinedClogRevs;
                int n = undefinedClogRevs.length;
                int n2 = 0;
                while (n2 < n) {
                    int u = nArray[n2];
                    Nodeid manifest = (Nodeid)missingCsetToManifest.get(u);
                    if (manifest == null || manifest.isNull()) {
                        HgManifest.this.getRepo().getSessionContext().getLog().dump(this.getClass(), LogFacility.Severity.Warn, "Changeset %d has no associated manifest entry", u);
                    } else if (this.manifestNodeids != null) {
                        int manifestRevIndex = this.manifestNodeids.findIndex(manifest);
                        if (manifestRevIndex == Integer.MIN_VALUE) {
                            throw new HgInvalidRevisionException(String.format("Can't find index of revision %s", manifest.shortNotation()), manifest, null);
                        }
                        this.changelog2manifest[u] = manifestRevIndex;
                    } else {
                        this.changelog2manifest[u] = HgManifest.this.getRevisionIndex(manifest);
                    }
                    ++n2;
                }
            }
        }
    }
}

