/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.repo;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.tmatesoft.hg.core.HgFileRevision;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.internal.Internals;
import org.tmatesoft.hg.internal.ManifestRevision;
import org.tmatesoft.hg.internal.Pool;
import org.tmatesoft.hg.repo.HgInvalidControlFileException;
import org.tmatesoft.hg.repo.HgInvalidStateException;
import org.tmatesoft.hg.repo.HgRepository;
import org.tmatesoft.hg.repo.HgRuntimeException;
import org.tmatesoft.hg.util.Pair;
import org.tmatesoft.hg.util.Path;
import org.tmatesoft.hg.util.PathRewrite;

public class HgMergeState {
    private Nodeid wcp1;
    private Nodeid wcp2;
    private Nodeid stateParent;
    private final Internals repo;
    private Entry[] entries;

    HgMergeState(Internals internalRepo) {
        this.repo = internalRepo;
    }

    public void refresh() throws HgRuntimeException {
        HgRepository hgRepo = this.repo.getRepo();
        this.entries = null;
        this.stateParent = Nodeid.NULL;
        Pool<Nodeid> nodeidPool = new Pool<Nodeid>();
        Pool<Path> fnamePool = new Pool<Path>();
        Pair<Nodeid, Nodeid> wcParents = hgRepo.getWorkingCopyParents();
        this.wcp1 = nodeidPool.unify(wcParents.first());
        this.wcp2 = nodeidPool.unify(wcParents.second());
        File f = this.repo.getFileFromRepoDir("merge/state");
        if (!f.canRead()) {
            return;
        }
        try {
            ArrayList<Entry> result = new ArrayList<Entry>();
            Path.SimpleSource pathPool = new Path.SimpleSource(new PathRewrite.Empty(), fnamePool);
            ManifestRevision m1 = new ManifestRevision(nodeidPool, fnamePool);
            ManifestRevision m2 = new ManifestRevision(nodeidPool, fnamePool);
            if (!this.wcp2.isNull()) {
                int rp2 = hgRepo.getChangelog().getRevisionIndex(this.wcp2);
                hgRepo.getManifest().walk(rp2, rp2, m2);
            }
            BufferedReader br = new BufferedReader(new FileReader(f));
            String s = br.readLine();
            this.stateParent = nodeidPool.unify(Nodeid.fromAscii(s));
            int rp1 = hgRepo.getChangelog().getRevisionIndex(this.stateParent);
            hgRepo.getManifest().walk(rp1, rp1, m1);
            while ((s = br.readLine()) != null) {
                Kind k;
                HgFileRevision p2;
                String[] r = s.split("\\00");
                Path p1fname = pathPool.path(r[3]);
                Nodeid nidP1 = m1.nodeid(p1fname);
                Nodeid nidCA = nodeidPool.unify(Nodeid.fromAscii(r[5]));
                HgFileRevision p1 = new HgFileRevision(hgRepo, nidP1, m1.flags(p1fname), p1fname);
                HgFileRevision ca = nidCA == nidP1 && r[3].equals(r[4]) ? p1 : new HgFileRevision(hgRepo, nidCA, null, pathPool.path(r[4]));
                if (!this.wcp2.isNull() || !r[6].equals(r[4])) {
                    Path p2fname = pathPool.path(r[6]);
                    Nodeid nidP2 = m2.nodeid(p2fname);
                    if (nidP2 == null) {
                        assert (false) : "There's not enough information (or I don't know where to look) in merge/state to find out what's the second parent";
                        nidP2 = Nodeid.NULL;
                    }
                    p2 = new HgFileRevision(hgRepo, nidP2, m2.flags(p2fname), p2fname);
                } else {
                    p2 = ca;
                }
                if ("u".equals(r[1])) {
                    k = Kind.Unresolved;
                } else if ("r".equals(r[1])) {
                    k = Kind.Resolved;
                } else {
                    throw new HgInvalidStateException(String.format("Unknown merge kind %s", r[1]));
                }
                Entry e = new Entry(k, pathPool.path(r[0]), p1, p2, ca);
                result.add(e);
            }
            this.entries = result.toArray(new Entry[result.size()]);
            br.close();
        }
        catch (IOException ex) {
            throw new HgInvalidControlFileException("Merge state read failed", ex, f);
        }
    }

    public boolean isMerging() {
        return !this.getFirstParent().isNull() && !this.getSecondParent().isNull() && !this.isStale();
    }

    public boolean isStale() {
        assert (this.wcp1 != null);
        return !this.stateParent.isNull() && !this.wcp1.equals(this.stateParent);
    }

    public Nodeid getFirstParent() {
        assert (this.wcp1 != null);
        return this.wcp1;
    }

    public Nodeid getSecondParent() {
        assert (this.wcp2 != null);
        return this.wcp2;
    }

    public Nodeid getStateParent() {
        assert (this.stateParent != null);
        return this.stateParent;
    }

    public List<Entry> getConflicts() {
        return this.entries == null ? Collections.emptyList() : Arrays.asList(this.entries);
    }

    public static class Entry {
        private final Kind state;
        private final HgFileRevision parent1;
        private final HgFileRevision parent2;
        private final HgFileRevision ancestor;
        private final Path wcFile;

        Entry(Kind s, Path actualCopy, HgFileRevision p1, HgFileRevision p2, HgFileRevision ca) {
            if (p1 == null || p2 == null || ca == null || actualCopy == null) {
                throw new IllegalArgumentException();
            }
            this.state = s;
            this.wcFile = actualCopy;
            this.parent1 = p1;
            this.parent2 = p2;
            this.ancestor = ca;
        }

        public Kind getState() {
            return this.state;
        }

        public Path getActualFile() {
            return this.wcFile;
        }

        public HgFileRevision getFirstParent() {
            return this.parent1;
        }

        public HgFileRevision getSecondParent() {
            return this.parent2;
        }

        public HgFileRevision getCommonAncestor() {
            return this.ancestor;
        }
    }

    public static enum Kind {
        Resolved,
        Unresolved;

    }
}

