/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.repo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.internal.ArrayHelper;
import org.tmatesoft.hg.internal.IntMap;
import org.tmatesoft.hg.repo.HgInvalidStateException;
import org.tmatesoft.hg.repo.HgRepository;
import org.tmatesoft.hg.repo.HgRevisionMap;
import org.tmatesoft.hg.repo.HgRuntimeException;
import org.tmatesoft.hg.repo.Revlog;

public final class HgParentChildMap<T extends Revlog>
implements Revlog.ParentInspector {
    private final T revlog;
    private Nodeid[] sequential;
    private Nodeid[] sorted;
    private Nodeid[] firstParent;
    private Nodeid[] secondParent;
    private IntMap<Nodeid> heads;
    private BitSet headsBitSet;
    private HgRevisionMap<T> revisionIndexMap;
    private ArrayHelper<Nodeid> seqWrapper;

    public HgParentChildMap(T owner) {
        this.revlog = owner;
    }

    public HgRepository getRepo() {
        return ((Revlog)this.revlog).getRepo();
    }

    @Override
    public void next(int revisionNumber, Nodeid revision, int parent1Revision, int parent2Revision, Nodeid nidParent1, Nodeid nidParent2) {
        if (parent1Revision >= revisionNumber || parent2Revision >= revisionNumber) {
            throw new IllegalStateException();
        }
        int ix = revisionNumber;
        this.sequential[ix] = this.sorted[ix] = revision;
        if (parent1Revision != -1) {
            this.firstParent[ix] = this.sequential[parent1Revision];
            this.headsBitSet.set(parent1Revision);
        }
        if (parent2Revision != -1) {
            this.secondParent[ix] = this.sequential[parent2Revision];
            this.headsBitSet.set(parent2Revision);
        }
    }

    public void init() throws HgRuntimeException {
        int lastRecordedRevIndex;
        int revisionCount = ((Revlog)this.revlog).getRevisionCount();
        Nodeid[] oldSequential = null;
        Nodeid[] oldFirstParent = null;
        Nodeid[] oldSecondParent = null;
        Nodeid[] oldSorted = null;
        if (this.sequential != null && this.sequential.length > 0 && this.sequential.length < revisionCount && this.sequential[lastRecordedRevIndex = this.sequential.length - 1].equals(((Revlog)this.revlog).getRevision(lastRecordedRevIndex))) {
            oldSequential = this.sequential;
            oldFirstParent = this.firstParent;
            oldSecondParent = this.secondParent;
            oldSorted = this.sorted;
        }
        this.firstParent = new Nodeid[revisionCount];
        this.secondParent = new Nodeid[revisionCount];
        this.sequential = new Nodeid[revisionCount];
        this.sorted = new Nodeid[revisionCount];
        this.headsBitSet = new BitSet(revisionCount);
        if (oldSequential != null) {
            assert (oldFirstParent.length == oldSequential.length);
            assert (oldSecondParent.length == oldSequential.length);
            assert (oldSorted.length == oldSequential.length);
            System.arraycopy(oldSequential, 0, this.sequential, 0, oldSequential.length);
            System.arraycopy(oldFirstParent, 0, this.firstParent, 0, oldFirstParent.length);
            System.arraycopy(oldSecondParent, 0, this.secondParent, 0, oldSecondParent.length);
            System.arraycopy(oldSorted, 0, this.sorted, 0, oldSorted.length);
            this.headsBitSet.set(0, oldSequential.length);
            int[] nArray = this.heads.keys();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int headIndex = nArray[n2];
                this.headsBitSet.clear(headIndex);
                ++n2;
            }
        }
        ((Revlog)this.revlog).indexWalk(oldSequential == null ? 0 : oldSequential.length, revisionCount - 1, this);
        this.seqWrapper = new ArrayHelper((Comparable[])this.sequential);
        this.seqWrapper.sort(this.sorted, false, true);
        IntMap<Nodeid> _heads = new IntMap<Nodeid>(revisionCount - this.headsBitSet.cardinality());
        int index = 0;
        while (index < this.sequential.length) {
            index = this.headsBitSet.nextClearBit(index);
            _heads.put(index, this.sequential[index]);
            ++index;
        }
        this.headsBitSet = null;
        this.heads = _heads;
    }

    private static void assertSortedIndex(int x) {
        if (x < 0) {
            throw new HgInvalidStateException(String.format("Bad index %d", x));
        }
    }

    public boolean knownNode(Nodeid nid) {
        return this.seqWrapper.binarySearchSorted(nid) >= 0;
    }

    public Nodeid firstParent(Nodeid nid) {
        int x = this.seqWrapper.binarySearchSorted(nid);
        HgParentChildMap.assertSortedIndex(x);
        int i = this.seqWrapper.getReverseIndex(x);
        return this.firstParent[i];
    }

    public Nodeid safeFirstParent(Nodeid nid) {
        Nodeid rv = this.firstParent(nid);
        return rv == null ? Nodeid.NULL : rv;
    }

    public Nodeid secondParent(Nodeid nid) {
        int x = this.seqWrapper.binarySearchSorted(nid);
        HgParentChildMap.assertSortedIndex(x);
        int i = this.seqWrapper.getReverseIndex(x);
        return this.secondParent[i];
    }

    public Nodeid safeSecondParent(Nodeid nid) {
        Nodeid rv = this.secondParent(nid);
        return rv == null ? Nodeid.NULL : rv;
    }

    public boolean appendParentsOf(Nodeid nid, Collection<Nodeid> c) {
        Nodeid p2;
        int x = this.seqWrapper.binarySearchSorted(nid);
        HgParentChildMap.assertSortedIndex(x);
        int i = this.seqWrapper.getReverseIndex(x);
        Nodeid p1 = this.firstParent[i];
        boolean modified = false;
        if (p1 != null) {
            modified = c.add(p1);
        }
        if ((p2 = this.secondParent[i]) != null) {
            modified = c.add(p2) || modified;
        }
        return modified;
    }

    public List<Nodeid> childrenOf(Collection<Nodeid> roots) {
        if (roots.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<Nodeid> parents = new HashSet<Nodeid>();
        LinkedList<Nodeid> result = new LinkedList<Nodeid>();
        int earliestRevision = Integer.MAX_VALUE;
        assert (this.sequential.length == this.firstParent.length && this.firstParent.length == this.secondParent.length);
        for (Nodeid r : roots) {
            int x = this.seqWrapper.binarySearchSorted(r);
            HgParentChildMap.assertSortedIndex(x);
            int i = this.seqWrapper.getReverseIndex(x);
            if (i < earliestRevision) {
                earliestRevision = i;
            }
            parents.add(this.sequential[i]);
        }
        int i = earliestRevision + 1;
        while (i < this.sequential.length) {
            if (parents.contains(this.firstParent[i]) || parents.contains(this.secondParent[i])) {
                parents.add(this.sequential[i]);
                result.add(this.sequential[i]);
            }
            ++i;
        }
        return result;
    }

    public List<Nodeid> directChildren(Nodeid nid) {
        int x = this.seqWrapper.binarySearchSorted(nid);
        HgParentChildMap.assertSortedIndex(x);
        int start = this.seqWrapper.getReverseIndex(x);
        nid = this.sequential[start];
        if (!this.hasChildren(start)) {
            return Collections.emptyList();
        }
        ArrayList<Nodeid> result = new ArrayList<Nodeid>(5);
        int i = start + 1;
        while (i < this.sequential.length) {
            if (nid == this.firstParent[i] || nid == this.secondParent[i]) {
                result.add(this.sequential[i]);
            }
            ++i;
        }
        return result;
    }

    public boolean hasChildren(Nodeid nid) {
        int x = this.seqWrapper.binarySearchSorted(nid);
        HgParentChildMap.assertSortedIndex(x);
        int i = this.seqWrapper.getReverseIndex(x);
        return this.hasChildren(i);
    }

    public List<Nodeid> all() {
        return Arrays.asList(this.sequential);
    }

    public boolean isChild(Nodeid root, Nodeid wannaBeChild) {
        int x = this.seqWrapper.binarySearchSorted(root);
        HgParentChildMap.assertSortedIndex(x);
        int start = this.seqWrapper.getReverseIndex(x);
        root = this.sequential[start];
        if (!this.hasChildren(start)) {
            return false;
        }
        int y = this.seqWrapper.binarySearchSorted(wannaBeChild);
        if (y < 0) {
            return false;
        }
        int end = this.seqWrapper.getReverseIndex(y);
        wannaBeChild = this.sequential[end];
        if (end <= start) {
            return false;
        }
        HashSet<Nodeid> parents = new HashSet<Nodeid>();
        parents.add(root);
        int i = start + 1;
        while (i < end) {
            if (parents.contains(this.firstParent[i]) || parents.contains(this.secondParent[i])) {
                parents.add(this.sequential[i]);
            }
            ++i;
        }
        return parents.contains(this.firstParent[end]) || parents.contains(this.secondParent[end]);
    }

    public Collection<Nodeid> heads() {
        return this.heads.values();
    }

    public HgRevisionMap<T> getRevisionMap() {
        if (this.revisionIndexMap == null) {
            this.revisionIndexMap = new HgRevisionMap<T>(this.revlog);
            this.revisionIndexMap.init(this.seqWrapper);
        }
        return this.revisionIndexMap;
    }

    public Nodeid ancestor(Nodeid r1, Nodeid r2) {
        if (r1.equals(r2)) {
            return r1;
        }
        BitSet a1 = this.buildAncestors(r1);
        BitSet a2 = this.buildAncestors(r2);
        a1.and(a2);
        int cardinality = a1.cardinality();
        if (cardinality == 1) {
            return this.sequential[a1.nextSetBit(0)];
        }
        assert (cardinality > 0);
        int length = this.sequential.length;
        int index = length / 2;
        int lastBitSet = -1;
        while (true) {
            int nextIndex;
            int nextSetBit;
            if ((nextSetBit = a1.nextSetBit(index)) == -1) {
                assert (lastBitSet == -1 || lastBitSet <= index);
                nextIndex = index - (index - (lastBitSet == -1 ? 0 : lastBitSet)) / 2;
            } else {
                lastBitSet = nextSetBit;
                nextIndex = lastBitSet + (length - lastBitSet) / 2;
            }
            if (nextIndex == index) break;
            index = nextIndex;
        }
        if (lastBitSet == -1) {
            assert (false);
            return this.sequential[0];
        }
        return this.sequential[lastBitSet];
    }

    private boolean hasChildren(int sequentialIndex) {
        return !this.heads.containsKey(sequentialIndex);
    }

    private BitSet buildAncestors(Nodeid nid) {
        int x = this.seqWrapper.binarySearchSorted(nid);
        HgParentChildMap.assertSortedIndex(x);
        int i = this.seqWrapper.getReverseIndex(x);
        BitSet rv = new BitSet(this.sequential.length);
        HashSet<Nodeid> ancestors = new HashSet<Nodeid>();
        ancestors.add(nid);
        do {
            if (!ancestors.contains(this.sequential[i])) continue;
            rv.set(i);
            if (this.firstParent[i] != null) {
                ancestors.add(this.firstParent[i]);
            }
            if (this.secondParent[i] == null) continue;
            ancestors.add(this.secondParent[i]);
        } while (--i >= 0);
        return rv;
    }
}

