/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.repo;

public enum HgPhase {
    Public("public"),
    Draft("draft"),
    Secret("secret"),
    Undefined("");

    private final String hgString;

    private HgPhase(String stringRepresentation) {
        this.hgString = stringRepresentation;
    }

    public static HgPhase parse(int value) {
        switch (value) {
            case 0: {
                return Public;
            }
            case 1: {
                return Draft;
            }
            case 2: {
                return Secret;
            }
        }
        throw new IllegalArgumentException(String.format("Bad phase index: %d", value));
    }

    public static HgPhase parse(String value) {
        if (HgPhase.Public.hgString.equals(value)) {
            return Public;
        }
        if (HgPhase.Draft.hgString.equals(value)) {
            return Draft;
        }
        if (HgPhase.Secret.hgString.equals(value)) {
            return Secret;
        }
        throw new IllegalArgumentException(String.format("Bad phase name: %d", value));
    }

    public int mercurialOrdinal() {
        if (this == Undefined) {
            throw new IllegalStateException("Undefined phase is an artifical value, which doesn't possess a valid native mercurial ordinal");
        }
        return this.ordinal();
    }

    public String mercurialString() {
        return this.hgString;
    }
}

