/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.repo;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StreamTokenizer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.tmatesoft.hg.auth.HgAuthFailedException;
import org.tmatesoft.hg.core.HgBadArgumentException;
import org.tmatesoft.hg.core.HgIOException;
import org.tmatesoft.hg.core.HgRemoteConnectionException;
import org.tmatesoft.hg.core.HgRepositoryNotFoundException;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.core.SessionContext;
import org.tmatesoft.hg.internal.BundleSerializer;
import org.tmatesoft.hg.internal.DataSerializer;
import org.tmatesoft.hg.internal.EncodingHelper;
import org.tmatesoft.hg.internal.FileUtils;
import org.tmatesoft.hg.internal.Internals;
import org.tmatesoft.hg.internal.PropertyMarshal;
import org.tmatesoft.hg.internal.remote.Connector;
import org.tmatesoft.hg.internal.remote.RemoteConnectorDescriptor;
import org.tmatesoft.hg.repo.HgBundle;
import org.tmatesoft.hg.repo.HgInvalidStateException;
import org.tmatesoft.hg.repo.HgLookup;
import org.tmatesoft.hg.repo.HgPhase;
import org.tmatesoft.hg.repo.HgRuntimeException;
import org.tmatesoft.hg.util.Adaptable;
import org.tmatesoft.hg.util.LogFacility;
import org.tmatesoft.hg.util.Outcome;
import org.tmatesoft.hg.util.Pair;

public class HgRemoteRepository
implements SessionContext.Source {
    private final boolean debug;
    private HgLookup lookupHelper;
    private final SessionContext sessionContext;
    private Set<String> remoteCapabilities;
    private Connector remote;

    HgRemoteRepository(SessionContext ctx, RemoteDescriptor rd) throws HgBadArgumentException {
        RemoteConnectorDescriptor rcd = Adaptable.Factory.getAdapter(rd, RemoteConnectorDescriptor.class, null);
        if (rcd == null) {
            throw new IllegalArgumentException(String.format("Present implementation supports remote connections via %s only", Connector.class.getName()));
        }
        this.sessionContext = ctx;
        this.debug = new PropertyMarshal(ctx).getBoolean("hg4j.remote.debug", false);
        this.remote = rcd.createConnector();
        this.remote.init(rd, ctx, null);
    }

    public boolean isInvalid() throws HgRemoteConnectionException {
        this.initCapabilities();
        return this.remoteCapabilities.isEmpty();
    }

    public String getLocation() {
        return this.remote.getServerLocation();
    }

    @Override
    public SessionContext getSessionContext() {
        return this.sessionContext;
    }

    public List<Nodeid> heads() throws HgRemoteConnectionException {
        if (this.isInvalid()) {
            return Collections.emptyList();
        }
        try {
            this.remote.sessionBegin();
            InputStreamReader is = new InputStreamReader(this.remote.heads(), "US-ASCII");
            StreamTokenizer st = new StreamTokenizer(is);
            st.ordinaryChars(48, 57);
            st.wordChars(48, 57);
            st.eolIsSignificant(false);
            LinkedList<Nodeid> parseResult = new LinkedList<Nodeid>();
            while (st.nextToken() != -1) {
                parseResult.add(Nodeid.fromAscii(st.sval));
            }
            LinkedList<Nodeid> linkedList = parseResult;
            return linkedList;
        }
        catch (IOException ex) {
            throw new HgRemoteConnectionException("Communication failure", ex).setRemoteCommand("heads").setServerInfo(this.getLocation());
        }
        finally {
            this.remote.sessionEnd();
        }
    }

    public List<Nodeid> between(Nodeid tip, Nodeid base) throws HgRemoteConnectionException {
        Range r = new Range(base, tip);
        return this.between(Collections.singletonList(r)).get(r);
    }

    public Map<Range, List<Nodeid>> between(Collection<Range> ranges) throws HgRemoteConnectionException {
        if (ranges.isEmpty() || this.isInvalid()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<Range, List<Nodeid>> rv = new LinkedHashMap<Range, List<Nodeid>>(ranges.size() * 4 / 3);
        try {
            this.remote.sessionBegin();
            InputStreamReader is = new InputStreamReader(this.remote.between(ranges), "US-ASCII");
            StreamTokenizer st = new StreamTokenizer(is);
            st.ordinaryChars(48, 57);
            st.wordChars(48, 57);
            st.eolIsSignificant(true);
            Iterator<Range> rangeItr = ranges.iterator();
            LinkedList<Nodeid> currRangeList = null;
            Range currRange = null;
            boolean possiblyEmptyNextLine = true;
            while (st.nextToken() != -1) {
                if (st.ttype == 10) {
                    if (possiblyEmptyNextLine) {
                        assert (currRange == null);
                        assert (currRangeList == null);
                        if (!rangeItr.hasNext()) {
                            throw new HgInvalidStateException("Internal error");
                        }
                        rv.put(rangeItr.next(), Collections.emptyList());
                        continue;
                    }
                    if (currRange == null || currRangeList == null) {
                        throw new HgInvalidStateException("Internal error");
                    }
                    currRange = null;
                    currRangeList = null;
                    possiblyEmptyNextLine = true;
                    continue;
                }
                possiblyEmptyNextLine = false;
                if (currRange == null) {
                    if (!rangeItr.hasNext()) {
                        throw new HgInvalidStateException("Internal error");
                    }
                    currRange = rangeItr.next();
                    currRangeList = new LinkedList<Nodeid>();
                    rv.put(currRange, currRangeList);
                }
                Nodeid nid = Nodeid.fromAscii(st.sval);
                currRangeList.addLast(nid);
            }
            is.close();
            LinkedHashMap<Range, List<Nodeid>> linkedHashMap = rv;
            return linkedHashMap;
        }
        catch (IOException ex) {
            throw new HgRemoteConnectionException("Communication failure", ex).setRemoteCommand("between").setServerInfo(this.getLocation());
        }
        finally {
            this.remote.sessionEnd();
        }
    }

    public List<RemoteBranch> branches(List<Nodeid> nodes) throws HgRemoteConnectionException {
        if (this.isInvalid()) {
            return Collections.emptyList();
        }
        try {
            this.remote.sessionBegin();
            InputStreamReader is = new InputStreamReader(this.remote.branches(nodes), "US-ASCII");
            StreamTokenizer st = new StreamTokenizer(is);
            st.ordinaryChars(48, 57);
            st.wordChars(48, 57);
            st.eolIsSignificant(false);
            ArrayList<Nodeid> parseResult = new ArrayList<Nodeid>(nodes.size() * 4);
            while (st.nextToken() != -1) {
                parseResult.add(Nodeid.fromAscii(st.sval));
            }
            if (parseResult.size() != nodes.size() * 4) {
                throw new HgRemoteConnectionException(String.format("Bad number of nodeids in result (shall be factor 4), expected %d, got %d", nodes.size() * 4, parseResult.size()));
            }
            ArrayList<RemoteBranch> rv = new ArrayList<RemoteBranch>(nodes.size());
            int i = 0;
            while (i < nodes.size()) {
                RemoteBranch rb = new RemoteBranch((Nodeid)parseResult.get(i * 4), (Nodeid)parseResult.get(i * 4 + 1), (Nodeid)parseResult.get(i * 4 + 2), (Nodeid)parseResult.get(i * 4 + 3));
                rv.add(rb);
                ++i;
            }
            ArrayList<RemoteBranch> arrayList = rv;
            return arrayList;
        }
        catch (IOException ex) {
            throw new HgRemoteConnectionException("Communication failure", ex).setRemoteCommand("branches").setServerInfo(this.getLocation());
        }
        finally {
            this.remote.sessionEnd();
        }
    }

    public HgBundle getChanges(List<Nodeid> roots) throws HgRemoteConnectionException, HgRuntimeException {
        if (this.isInvalid()) {
            return null;
        }
        List<Nodeid> _roots = roots.isEmpty() ? Collections.singletonList(Nodeid.NULL) : roots;
        try {
            this.remote.sessionBegin();
            File tf = this.writeBundle(this.remote.changegroup(_roots));
            if (this.debug) {
                System.out.printf("Wrote bundle %s for roots %s\n", tf, roots);
            }
            HgBundle hgBundle = this.getLookupHelper().loadBundle(tf);
            return hgBundle;
        }
        catch (IOException ex) {
            throw new HgRemoteConnectionException("Communication failure", ex).setRemoteCommand("changegroup").setServerInfo(this.getLocation());
        }
        catch (HgRepositoryNotFoundException ex) {
            throw new HgRemoteConnectionException("Communication failure", ex).setRemoteCommand("changegroup").setServerInfo(this.getLocation());
        }
        finally {
            this.remote.sessionEnd();
        }
    }

    public void unbundle(HgBundle bundle, List<Nodeid> remoteHeads) throws HgRemoteConnectionException, HgRuntimeException {
        if (remoteHeads == null) {
            throw Internals.notImplemented();
        }
        if (this.isInvalid()) {
            return;
        }
        BundleSerializer bundleData = BundleSerializer.newInstance(this.sessionContext, bundle);
        OutputStream os = null;
        try {
            try {
                this.remote.sessionBegin();
                os = this.remote.unbundle(bundleData.serializeLength(), remoteHeads);
                bundleData.serialize(new DataSerializer.OutputStreamSerializer(os));
                os.flush();
                os.close();
                os = null;
            }
            catch (IOException ex) {
                throw new HgRemoteConnectionException("Communication failure", ex).setRemoteCommand("unbundle").setServerInfo(this.getLocation());
            }
            catch (HgIOException ex) {
                throw new HgRemoteConnectionException("Communication failure", ex).setRemoteCommand("unbundle").setServerInfo(this.getLocation());
            }
        }
        catch (Throwable throwable) {
            new FileUtils(this.sessionContext.getLog(), this).closeQuietly(os);
            this.remote.sessionEnd();
            throw throwable;
        }
        new FileUtils(this.sessionContext.getLog(), this).closeQuietly(os);
        this.remote.sessionEnd();
    }

    public Bookmarks getBookmarks() throws HgRemoteConnectionException, HgRuntimeException {
        this.initCapabilities();
        if (!this.remoteCapabilities.contains("pushkey")) {
            return new Bookmarks(Collections.emptyList());
        }
        List<Pair<String, String>> values = this.listkeys("bookmarks", "Get remote bookmarks");
        ArrayList<Pair<String, Nodeid>> rv = new ArrayList<Pair<String, Nodeid>>();
        for (Pair<String, String> l : values) {
            if (l.second().length() != 40) {
                this.sessionContext.getLog().dump(this.getClass(), LogFacility.Severity.Warn, "%s: bad nodeid '%s', ignored", "Get remote bookmarks", l.second());
                continue;
            }
            Nodeid n = Nodeid.fromAscii(l.second());
            String bm = new String(l.first());
            rv.add(new Pair<String, Nodeid>(bm, n));
        }
        return new Bookmarks(rv);
    }

    public Outcome updateBookmark(String name, Nodeid oldRev, Nodeid newRev) throws HgRemoteConnectionException, HgRuntimeException {
        this.initCapabilities();
        if (!this.remoteCapabilities.contains("pushkey")) {
            return new Outcome(Outcome.Kind.Failure, "Server doesn't support pushkey protocol");
        }
        if (this.pushkey("Update remote bookmark", "bookmarks", name, oldRev.toString(), newRev.toString())) {
            return new Outcome(Outcome.Kind.Success, String.format("Bookmark %s updated to %s", name, newRev.shortNotation()));
        }
        return new Outcome(Outcome.Kind.Failure, String.format("Bookmark update (%s: %s -> %s) failed", name, oldRev.shortNotation(), newRev.shortNotation()));
    }

    public Phases getPhases() throws HgRemoteConnectionException, HgRuntimeException {
        this.initCapabilities();
        if (!this.remoteCapabilities.contains("pushkey")) {
            return new Phases(true, Collections.emptyList());
        }
        List<Pair<String, String>> values = this.listkeys("phases", "Get remote phases");
        boolean publishing = false;
        ArrayList<Nodeid> draftRoots = new ArrayList<Nodeid>();
        for (Pair<String, String> l : values) {
            if ("publishing".equalsIgnoreCase(l.first())) {
                publishing = Boolean.parseBoolean(l.second());
                continue;
            }
            Nodeid root = Nodeid.fromAscii(l.first());
            int ph = Integer.parseInt(l.second());
            if (ph == HgPhase.Draft.mercurialOrdinal()) {
                draftRoots.add(root);
                continue;
            }
            assert (false);
            this.sessionContext.getLog().dump(this.getClass(), LogFacility.Severity.Error, "Unexpected phase value %d for revision %s", ph, root);
        }
        return new Phases(publishing, draftRoots);
    }

    public Outcome updatePhase(HgPhase from, HgPhase to, Nodeid n) throws HgRemoteConnectionException, HgRuntimeException {
        this.initCapabilities();
        if (!this.remoteCapabilities.contains("pushkey")) {
            return new Outcome(Outcome.Kind.Failure, "Server doesn't support pushkey protocol");
        }
        if (this.pushkey("Update remote phases", "phases", n.toString(), String.valueOf(from.mercurialOrdinal()), String.valueOf(to.mercurialOrdinal()))) {
            return new Outcome(Outcome.Kind.Success, String.format("Phase of %s updated to %s", n.shortNotation(), to.name()));
        }
        return new Outcome(Outcome.Kind.Failure, String.format("Phase update (%s: %s -> %s) failed", n.shortNotation(), from.name(), to.name()));
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + '[' + this.getLocation() + ']';
    }

    private void initCapabilities() throws HgRemoteConnectionException {
        if (this.remoteCapabilities != null) {
            return;
        }
        try {
            this.remote.connect();
        }
        catch (HgAuthFailedException ex) {
            throw new HgRemoteConnectionException("Failed to authenticate", ex).setServerInfo(this.remote.getServerLocation());
        }
        try {
            this.remote.sessionBegin();
            String capsLine = this.remote.getCapabilities();
            String[] caps = capsLine.split("\\s");
            this.remoteCapabilities = new HashSet<String>(Arrays.asList(caps));
        }
        finally {
            this.remote.sessionEnd();
        }
    }

    private HgLookup getLookupHelper() {
        if (this.lookupHelper == null) {
            this.lookupHelper = new HgLookup(this.sessionContext);
        }
        return this.lookupHelper;
    }

    private List<Pair<String, String>> listkeys(String namespace, String actionName) throws HgRemoteConnectionException, HgRuntimeException {
        try {
            String l;
            this.remote.sessionBegin();
            ArrayList<Pair<String, String>> rv = new ArrayList<Pair<String, String>>();
            InputStream response = this.remote.listkeys(namespace, actionName);
            BufferedReader r = new BufferedReader(new InputStreamReader(response, EncodingHelper.getUTF8()));
            while ((l = r.readLine()) != null) {
                int sep = l.indexOf(9);
                if (sep == -1) {
                    this.sessionContext.getLog().dump(this.getClass(), LogFacility.Severity.Warn, "%s: bad line '%s', ignored", actionName, l);
                    continue;
                }
                rv.add(new Pair<String, String>(l.substring(0, sep), l.substring(sep + 1)));
            }
            r.close();
            ArrayList<Pair<String, String>> arrayList = rv;
            return arrayList;
        }
        catch (IOException ex) {
            throw new HgRemoteConnectionException("Communication failure", ex).setRemoteCommand("listkeys").setServerInfo(this.getLocation());
        }
        finally {
            this.remote.sessionEnd();
        }
    }

    private boolean pushkey(String opName, String namespace, String key, String oldValue, String newValue) throws HgRemoteConnectionException, HgRuntimeException {
        try {
            this.remote.sessionBegin();
            InputStream is = this.remote.pushkey(opName, namespace, key, oldValue, newValue);
            int rv = is.read();
            is.close();
            boolean bl = rv == 49;
            return bl;
        }
        catch (IOException ex) {
            throw new HgRemoteConnectionException("Communication failure", ex).setRemoteCommand("pushkey").setServerInfo(this.getLocation());
        }
        finally {
            this.remote.sessionEnd();
        }
    }

    private File writeBundle(InputStream is) throws IOException {
        File tf = File.createTempFile("hg4j-bundle-", null);
        new FileUtils(this.sessionContext.getLog(), this).write(is, tf);
        is.close();
        return tf;
    }

    public static final class Bookmarks
    implements Iterable<Pair<String, Nodeid>> {
        private final List<Pair<String, Nodeid>> bm;

        private Bookmarks(List<Pair<String, Nodeid>> bookmarks) {
            this.bm = bookmarks;
        }

        @Override
        public Iterator<Pair<String, Nodeid>> iterator() {
            return this.bm.iterator();
        }
    }

    public static final class Phases {
        private final boolean pub;
        private final List<Nodeid> droots;

        private Phases(boolean publishing, List<Nodeid> draftRoots) {
            this.pub = publishing;
            this.droots = draftRoots;
        }

        public List<Nodeid> draftRoots() {
            return this.droots;
        }

        public boolean isPublishingServer() {
            return this.pub;
        }
    }

    public static final class Range {
        public final Nodeid start;
        public final Nodeid end;

        public Range(Nodeid from, Nodeid to) {
            this.start = from;
            this.end = to;
        }

        public StringBuilder append(StringBuilder sb) {
            sb.append(this.end.toString());
            sb.append('-');
            sb.append(this.start.toString());
            return sb;
        }
    }

    public static final class RemoteBranch {
        public final Nodeid head;
        public final Nodeid root;
        public final Nodeid p1;
        public final Nodeid p2;

        public RemoteBranch(Nodeid h, Nodeid r, Nodeid parent1, Nodeid parent2) {
            this.head = h;
            this.root = r;
            this.p1 = parent1;
            this.p2 = parent2;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof RemoteBranch)) {
                return false;
            }
            RemoteBranch o = (RemoteBranch)obj;
            return this.head.equals(o.head) && this.root.equals(o.root) && (this.p1 == null && o.p1 == null || this.p1.equals(o.p1)) && (this.p2 == null && o.p2 == null || this.p2.equals(o.p2));
        }

        public int hashCode() {
            return this.head.hashCode() ^ this.root.hashCode();
        }

        public String toString() {
            String none = String.valueOf(-1);
            String s1 = this.p1 == null || this.p1.isNull() ? none : this.p1.shortNotation();
            String s2 = this.p2 == null || this.p2.isNull() ? none : this.p2.shortNotation();
            return String.format("RemoteBranch[root: %s, head:%s, p1:%s, p2:%s]", this.root.shortNotation(), this.head.shortNotation(), s1, s2);
        }
    }

    public static interface RemoteDescriptor {
        public URI getURI();
    }
}

