/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.repo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.tmatesoft.hg.internal.ConfigFile;
import org.tmatesoft.hg.util.Pair;

public final class HgRepoConfig {
    final ConfigFile config;

    HgRepoConfig(ConfigFile configFile) {
        this.config = configFile;
    }

    public Section getSection(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if ("paths".equals(name)) {
            return new PathsSection();
        }
        if ("extensions".equals(name)) {
            return new ExtensionsSection();
        }
        return new Section(name);
    }

    public boolean hasSection(String name) {
        return this.config.hasSection(name);
    }

    public boolean getBooleanValue(String section, String key, boolean defaultValue) {
        return this.config.getBoolean(section, key, defaultValue);
    }

    public String getStringValue(String section, String key, String defaultValue) {
        return this.config.getString(section, key, defaultValue);
    }

    public int getIntegerValue(String section, String key, int defaultValue) {
        return this.config.getInteger(section, key, defaultValue);
    }

    public PathsSection getPaths() {
        Section s = this.getSection("paths");
        if (s.exists()) {
            return (PathsSection)s;
        }
        return new PathsSection();
    }

    public ExtensionsSection getExtensions() {
        Section s = this.getSection("extensions");
        if (s.exists()) {
            return (ExtensionsSection)s;
        }
        return new ExtensionsSection();
    }

    public class ExtensionsSection
    extends Section {
        ExtensionsSection() {
            super("extensions");
        }

        public boolean isEnabled(String extensionName) {
            Map<String, String> sect = HgRepoConfig.this.config.getSection(this.section);
            String value = sect.get(extensionName);
            if (value == null) {
                value = sect.get("hgext." + extensionName);
            }
            if (value == null) {
                value = sect.get("hgext/" + extensionName);
            }
            if (value != null) {
                return value.length() == 0 || '!' != value.charAt(0);
            }
            return false;
        }
    }

    public class PathsSection
    extends Section {
        PathsSection() {
            super("paths");
        }

        public List<String> getPathSymbolicNames() {
            List<String> rv = this.getKeys();
            rv.remove("default");
            rv.remove("default-push");
            return rv;
        }

        public boolean hasDefault() {
            return this.isKeySet("default");
        }

        public String getDefault() {
            return super.getString("default", null);
        }

        public boolean hasDefaultPush() {
            return this.isKeySet("default-push");
        }

        public String getDefaultPush() {
            return super.getString("default-push", null);
        }
    }

    public class Section
    implements Iterable<Pair<String, String>> {
        protected final String section;

        Section(String sectionName) {
            this.section = sectionName;
        }

        public String getName() {
            return this.section;
        }

        public boolean exists() {
            return HgRepoConfig.this.hasSection(this.section);
        }

        public List<String> getKeys() {
            return new ArrayList<String>(HgRepoConfig.this.config.getSection(this.section).keySet());
        }

        public boolean isKeySet(String key) {
            String value = HgRepoConfig.this.getStringValue(this.section, key, null);
            return value != null && value.length() > 0;
        }

        public boolean getBoolean(String key, boolean defaultValue) {
            return HgRepoConfig.this.getBooleanValue(this.section, key, defaultValue);
        }

        public String getString(String key, String defaultValue) {
            return HgRepoConfig.this.getStringValue(this.section, key, defaultValue);
        }

        @Override
        public Iterator<Pair<String, String>> iterator() {
            Map<String, String> m = HgRepoConfig.this.config.getSection(this.section);
            if (m.isEmpty()) {
                return Collections.emptyList().iterator();
            }
            ArrayList<Pair<String, String>> rv = new ArrayList<Pair<String, String>>(m.size());
            for (Map.Entry<String, String> e : m.entrySet()) {
                rv.add(new Pair<String, String>(e.getKey(), e.getValue()));
            }
            return rv.iterator();
        }
    }
}

