/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.repo;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.tmatesoft.hg.core.HgIOException;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.core.SessionContext;
import org.tmatesoft.hg.internal.ConfigFile;
import org.tmatesoft.hg.internal.DirstateReader;
import org.tmatesoft.hg.internal.FileUtils;
import org.tmatesoft.hg.internal.Filter;
import org.tmatesoft.hg.internal.Internals;
import org.tmatesoft.hg.internal.PropertyMarshal;
import org.tmatesoft.hg.internal.RevlogStream;
import org.tmatesoft.hg.internal.SubrepoManager;
import org.tmatesoft.hg.repo.HgBookmarks;
import org.tmatesoft.hg.repo.HgBranches;
import org.tmatesoft.hg.repo.HgChangelog;
import org.tmatesoft.hg.repo.HgDataFile;
import org.tmatesoft.hg.repo.HgDirstate;
import org.tmatesoft.hg.repo.HgIgnore;
import org.tmatesoft.hg.repo.HgInvalidControlFileException;
import org.tmatesoft.hg.repo.HgManifest;
import org.tmatesoft.hg.repo.HgMergeState;
import org.tmatesoft.hg.repo.HgRepoConfig;
import org.tmatesoft.hg.repo.HgRepositoryFiles;
import org.tmatesoft.hg.repo.HgRepositoryLock;
import org.tmatesoft.hg.repo.HgRuntimeException;
import org.tmatesoft.hg.repo.HgSubrepoLocation;
import org.tmatesoft.hg.repo.HgTags;
import org.tmatesoft.hg.repo.ext.HgExtensionsManager;
import org.tmatesoft.hg.util.LogFacility;
import org.tmatesoft.hg.util.Pair;
import org.tmatesoft.hg.util.Path;
import org.tmatesoft.hg.util.PathRewrite;
import org.tmatesoft.hg.util.ProgressSupport;

public final class HgRepository
implements SessionContext.Source {
    public static final int TIP = -3;
    public static final int BAD_REVISION = Integer.MIN_VALUE;
    public static final int WORKING_COPY = -2;
    public static final int NO_REVISION = -1;
    public static final String DEFAULT_BRANCH_NAME = "default";
    private final File workingDir;
    private final String repoLocation;
    private final PathRewrite normalizePath;
    private final SessionContext sessionContext;
    private HgChangelog changelog;
    private HgManifest manifest;
    private HgTags tags;
    private HgBranches branches;
    private HgMergeState mergeState;
    private SubrepoManager subRepos;
    private HgBookmarks bookmarks;
    private HgExtensionsManager extManager;
    private HgIgnore ignore;
    private HgRepoConfig repoConfig;
    private HgRepositoryLock wdLock;
    private HgRepositoryLock storeLock;
    private final Internals impl;

    HgRepository(String repositoryPath) {
        this.workingDir = null;
        this.repoLocation = repositoryPath;
        this.normalizePath = null;
        this.sessionContext = null;
        this.impl = null;
    }

    HgRepository(SessionContext ctx, String repositoryPath, File repositoryRoot) throws HgRuntimeException {
        assert (".hg".equals(repositoryRoot.getName()) && repositoryRoot.isDirectory());
        assert (repositoryPath != null);
        assert (repositoryRoot != null);
        assert (ctx != null);
        this.workingDir = repositoryRoot.getParentFile();
        if (this.workingDir == null) {
            throw new IllegalArgumentException(repositoryRoot.toString());
        }
        this.repoLocation = repositoryPath;
        this.sessionContext = ctx;
        this.impl = new Internals(this, repositoryRoot, new Internals.ImplAccess(){

            @Override
            public RevlogStream getStream(HgDataFile df) {
                return df.content;
            }

            @Override
            public RevlogStream getManifestStream() {
                return HgRepository.this.getManifest().content;
            }

            @Override
            public RevlogStream getChangelogStream() {
                return HgRepository.this.getChangelog().content;
            }
        });
        this.normalizePath = this.impl.buildNormalizePathRewrite();
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + this.getLocation() + (this.isInvalid() ? "(BAD)" : "") + "]";
    }

    public String getLocation() {
        return this.repoLocation;
    }

    public boolean isInvalid() {
        return this.impl == null || this.impl.isInvalid();
    }

    public HgChangelog getChangelog() {
        if (this.changelog == null) {
            RevlogStream content = this.impl.createChangelogStream();
            this.changelog = new HgChangelog(this, content);
        }
        return this.changelog;
    }

    public HgManifest getManifest() {
        if (this.manifest == null) {
            RevlogStream content = this.impl.createManifestStream();
            this.manifest = new HgManifest(this, content, this.impl.buildFileNameEncodingHelper());
        }
        return this.manifest;
    }

    public HgTags getTags() throws HgRuntimeException {
        if (this.tags == null) {
            this.tags = new HgTags(this.impl);
            this.tags.read();
        } else {
            this.tags.reloadIfChanged();
        }
        return this.tags;
    }

    public HgBranches getBranches() throws HgRuntimeException {
        ProgressSupport ps = ProgressSupport.Factory.get(null);
        if (this.branches == null) {
            this.branches = new HgBranches(this.impl);
            this.branches.collect(ps);
        } else {
            this.branches.reloadIfChanged(ps);
        }
        return this.branches;
    }

    public HgMergeState getMergeState() throws HgRuntimeException {
        if (this.mergeState == null) {
            this.mergeState = new HgMergeState(this.impl);
            this.mergeState.refresh();
        }
        return this.mergeState;
    }

    public HgDataFile getFileNode(String path) {
        CharSequence nPath = this.normalizePath.rewrite(path);
        Path p = this.sessionContext.getPathFactory().path(nPath);
        return this.getFileNode(p);
    }

    public HgDataFile getFileNode(Path path) {
        RevlogStream content = this.impl.resolveStoreFile(path);
        assert (content != null);
        return new HgDataFile(this, path, content);
    }

    public PathRewrite getToRepoPathHelper() {
        return this.normalizePath;
    }

    public Pair<Nodeid, Nodeid> getWorkingCopyParents() throws HgInvalidControlFileException {
        return DirstateReader.readParents(this.impl);
    }

    public String getWorkingCopyBranchName() throws HgInvalidControlFileException {
        String wcBranch = DirstateReader.readBranch(this.impl);
        return wcBranch;
    }

    public File getWorkingDir() {
        return this.workingDir;
    }

    public List<HgSubrepoLocation> getSubrepositories() throws HgInvalidControlFileException {
        if (this.subRepos == null) {
            this.subRepos = new SubrepoManager(this);
            this.subRepos.read();
        }
        return this.subRepos.all();
    }

    public HgRepoConfig getConfiguration() {
        if (this.repoConfig == null) {
            try {
                ConfigFile configFile = this.impl.readConfiguration();
                this.repoConfig = new HgRepoConfig(configFile);
            }
            catch (HgIOException ex) {
                String m = "Errors while reading user configuration file";
                this.getSessionContext().getLog().dump(this.getClass(), LogFacility.Severity.Warn, ex, m);
                return new HgRepoConfig(new ConfigFile(this.getSessionContext()));
            }
        }
        return this.repoConfig;
    }

    final HgDirstate loadDirstate(Path.Source pathFactory) throws HgInvalidControlFileException {
        PathRewrite canonicalPath = null;
        if (!this.impl.isCaseSensitiveFileSystem()) {
            canonicalPath = new PathRewrite(){

                @Override
                public CharSequence rewrite(CharSequence path) {
                    return path.toString().toLowerCase();
                }
            };
        }
        HgDirstate ds = new HgDirstate(this.impl, pathFactory, canonicalPath);
        ds.read();
        return ds;
    }

    public HgIgnore getIgnore() throws HgInvalidControlFileException {
        if (this.ignore == null) {
            this.ignore = new HgIgnore(this.getToRepoPathHelper());
            this.ignore.read(this.impl);
        } else {
            this.ignore.reloadIfChanged(this.impl);
        }
        return this.ignore;
    }

    public String getCommitLastMessage() throws HgInvalidControlFileException {
        File lastMessage = this.impl.getRepositoryFile(HgRepositoryFiles.LastMessage);
        if (!lastMessage.canRead()) {
            return null;
        }
        FileReader fr = null;
        try {
            fr = new FileReader(lastMessage);
            CharBuffer cb = CharBuffer.allocate(Internals.ltoi(lastMessage.length()));
            fr.read(cb);
            String string = cb.flip().toString();
            return string;
        }
        catch (IOException ex) {
            throw new HgInvalidControlFileException("Can't retrieve message of last commit attempt", ex, lastMessage);
        }
        finally {
            new FileUtils(this.getSessionContext().getLog(), this).closeQuietly(fr, lastMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HgRepositoryLock getWorkingDirLock() {
        if (this.wdLock == null) {
            int timeout = this.getLockTimeout();
            File lf = this.impl.getRepositoryFile(HgRepositoryFiles.WorkingCopyLock);
            HgRepository hgRepository = this;
            synchronized (hgRepository) {
                if (this.wdLock == null) {
                    this.wdLock = new HgRepositoryLock(lf, timeout);
                }
            }
        }
        return this.wdLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HgRepositoryLock getStoreLock() {
        if (this.storeLock == null) {
            int timeout = this.getLockTimeout();
            File fl = this.impl.getRepositoryFile(HgRepositoryFiles.StoreLock);
            HgRepository hgRepository = this;
            synchronized (hgRepository) {
                if (this.storeLock == null) {
                    this.storeLock = new HgRepositoryLock(fl, timeout);
                }
            }
        }
        return this.storeLock;
    }

    public HgBookmarks getBookmarks() throws HgRuntimeException {
        if (this.bookmarks == null) {
            this.bookmarks = new HgBookmarks(this.impl);
            this.bookmarks.read();
        } else {
            this.bookmarks.reloadIfChanged();
        }
        return this.bookmarks;
    }

    public HgExtensionsManager getExtensions() {
        if (this.extManager == null) {
            class EM
            extends HgExtensionsManager {
                EM() {
                    super(HgRepository.this.getImplHelper());
                }
            }
            this.extManager = new EM();
        }
        return this.extManager;
    }

    @Override
    public SessionContext getSessionContext() {
        return this.sessionContext;
    }

    List<Filter> getFiltersFromRepoToWorkingDir(Path p) {
        return this.instantiateFilters(p, new Filter.Options(Filter.Direction.FromRepo));
    }

    List<Filter> getFiltersFromWorkingDirToRepo(Path p) {
        return this.instantiateFilters(p, new Filter.Options(Filter.Direction.ToRepo));
    }

    File getFile(HgDataFile dataFile) {
        return new File(this.getWorkingDir(), dataFile.getPath().toString());
    }

    Internals getImplHelper() {
        return this.impl;
    }

    private List<Filter> instantiateFilters(Path p, Filter.Options opts) {
        List<Filter.Factory> factories = this.impl.getFilters();
        if (factories.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Filter> rv = new ArrayList<Filter>(factories.size());
        for (Filter.Factory ff : factories) {
            Filter f = ff.create(p, opts);
            if (f == null) continue;
            rv.add(f);
        }
        return rv;
    }

    private int getLockTimeout() {
        int cfgValue = this.getConfiguration().getIntegerValue("ui", "timeout", 600);
        if (this.getSessionContext().getConfigurationProperty("hg4j.fs.lock.timeout", null) != null) {
            return new PropertyMarshal(this.sessionContext).getInt("hg4j.fs.lock.timeout", cfgValue);
        }
        return cfgValue;
    }
}

