/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.repo;

public enum HgRepositoryFiles {
    HgIgnore(Home.Root, ".hgignore"),
    HgTags(Home.Root, ".hgtags"),
    HgEol(Home.Root, ".hgeol"),
    Dirstate(Home.Repo, "dirstate"),
    HgLocalTags(Home.Repo, "localtags"),
    HgSub(Home.Root, ".hgsub"),
    HgSubstate(Home.Root, ".hgsubstate"),
    LastMessage(Home.Repo, "last-message.txt"),
    Bookmarks(Home.Repo, "bookmarks"),
    BookmarksCurrent(Home.Repo, "bookmarks.current"),
    Branch(Home.Repo, "branch"),
    UndoBranch(Home.Repo, "undo.branch"),
    UndoDirstate(Home.Repo, "undo.dirstate"),
    Phaseroots(Home.Store, "phaseroots"),
    FNCache(Home.Store, "fncache"),
    WorkingCopyLock(Home.Repo, "wlock"),
    StoreLock(Home.Store, "lock");

    private final String fname;
    private final Home residesIn;

    private HgRepositoryFiles(Home home, String filename) {
        this.fname = filename;
        this.residesIn = home;
    }

    public String getPath() {
        switch (this.residesIn) {
            case Store: {
                return ".hg/store/" + this.getName();
            }
            case Repo: {
                return ".hg/" + this.getName();
            }
        }
        return this.getName();
    }

    public String getName() {
        return this.fname;
    }

    public boolean residesUnderWorkingDir() {
        return this.residesIn == Home.Root;
    }

    public boolean residesUnderRepositoryRoot() {
        return this.residesIn == Home.Repo;
    }

    public Home getHome() {
        return this.residesIn;
    }

    public static enum Home {
        Root,
        Repo,
        Store;

    }
}

