/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.repo;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.tmatesoft.hg.core.HgRepositoryLockException;
import org.tmatesoft.hg.internal.Internals;

public class HgRepositoryLock {
    private final File lockFile;
    private int use = 0;
    private final int timeoutSeconds;

    HgRepositoryLock(File lock, int timeoutInSeconds) {
        this.lockFile = lock;
        this.timeoutSeconds = timeoutInSeconds;
    }

    public String readLockInfo() {
        if (this.lockFile.exists()) {
            try {
                byte[] bytes = HgRepositoryLock.read(this.lockFile);
                if (bytes != null && bytes.length > 0) {
                    return new String(bytes);
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public boolean isLocked() {
        return this.use > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire() throws HgRepositoryLockException {
        if (this.use > 0) {
            ++this.use;
            return;
        }
        StringBuilder lockDescription = new StringBuilder();
        lockDescription.append(this.getHostname());
        lockDescription.append(':');
        lockDescription.append(this.getPid());
        byte[] bytes = lockDescription.toString().getBytes();
        long stopTime = this.timeoutSeconds < 0 ? -1L : System.currentTimeMillis() + (long)(this.timeoutSeconds * 1000);
        do {
            HgRepositoryLock hgRepositoryLock = this;
            synchronized (hgRepositoryLock) {
                try {
                    if (this.lockFile.createNewFile()) {
                        HgRepositoryLock.write(this.lockFile, bytes);
                        ++this.use;
                        return;
                    }
                }
                catch (IOException iOException) {}
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        } while (stopTime == -1L || System.currentTimeMillis() <= stopTime);
        String msg = String.format("Failed to aquire lock, waited for %d seconds, present owner: '%s'", this.timeoutSeconds, this.readLockInfo());
        throw new HgRepositoryLockException(msg);
    }

    public void release() throws HgRepositoryLockException {
        if (this.use == 0) {
            throw new HgRepositoryLockException("Lock is not held!");
        }
        --this.use;
        if (this.use > 0) {
            return;
        }
        this.lockFile.delete();
    }

    protected String getHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            return "localhost";
        }
    }

    protected int getPid() {
        try {
            File f;
            if (!Internals.runningOnWindows() && (f = new File("/proc/self")).exists()) {
                return Integer.parseInt(f.getCanonicalFile().getName());
            }
            String rtBean = ManagementFactory.getRuntimeMXBean().getName();
            int x = rtBean.indexOf(64);
            if (x != -1) {
                return Integer.parseInt(rtBean.substring(0, x));
            }
            return -1;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    private static void write(File f, byte[] content) throws IOException {
        FileOutputStream fos = new FileOutputStream(f);
        fos.write(content);
        fos.close();
    }

    private static byte[] read(File f) throws IOException {
        FileInputStream fis = new FileInputStream(f);
        FileChannel fc = fis.getChannel();
        ByteBuffer bb = ByteBuffer.allocate(Internals.ltoi(fc.size()));
        fc.read(bb);
        fis.close();
        return bb.array();
    }
}

