/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.repo;

import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.internal.ArrayHelper;
import org.tmatesoft.hg.repo.HgRepository;
import org.tmatesoft.hg.repo.HgRuntimeException;
import org.tmatesoft.hg.repo.Revlog;

public final class HgRevisionMap<T extends Revlog>
implements Revlog.RevisionInspector {
    private final T revlog;
    private Nodeid[] sequential;
    private ArrayHelper<Nodeid> seqWrapper;

    public HgRevisionMap(T owner) {
        this.revlog = owner;
    }

    public HgRepository getRepo() {
        return ((Revlog)this.revlog).getRepo();
    }

    @Override
    public void next(int revisionIndex, Nodeid revision, int linkedRevision) {
        this.sequential[revisionIndex] = revision;
    }

    public HgRevisionMap<T> init() throws HgRuntimeException {
        int revisionCount = ((Revlog)this.revlog).getRevisionCount();
        this.sequential = new Nodeid[revisionCount];
        ((Revlog)this.revlog).indexWalk(0, -3, this);
        this.seqWrapper = new ArrayHelper((Comparable[])this.sequential);
        this.seqWrapper.sort(null, true, false);
        return this;
    }

    void init(ArrayHelper<Nodeid> _seqWrapper) {
        assert (((Nodeid[])_seqWrapper.getData()).length == ((Revlog)this.revlog).getRevisionCount());
        this.sequential = (Nodeid[])_seqWrapper.getData();
        this.seqWrapper = _seqWrapper;
    }

    public Nodeid revision(int revisionIndex) {
        return this.sequential[revisionIndex];
    }

    public int revisionIndex(Nodeid revision) {
        if (revision == null || revision.isNull()) {
            return Integer.MIN_VALUE;
        }
        return this.seqWrapper.binarySearch(revision, Integer.MIN_VALUE);
    }
}

