/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.repo;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.internal.FileRenameHistory;
import org.tmatesoft.hg.internal.IntMap;
import org.tmatesoft.hg.internal.ManifestRevision;
import org.tmatesoft.hg.internal.Pool;
import org.tmatesoft.hg.repo.HgDataFile;
import org.tmatesoft.hg.repo.HgInternals;
import org.tmatesoft.hg.repo.HgInvalidFileException;
import org.tmatesoft.hg.repo.HgInvalidRevisionException;
import org.tmatesoft.hg.repo.HgInvalidStateException;
import org.tmatesoft.hg.repo.HgManifest;
import org.tmatesoft.hg.repo.HgRepository;
import org.tmatesoft.hg.repo.HgRuntimeException;
import org.tmatesoft.hg.repo.HgStatusInspector;
import org.tmatesoft.hg.util.CancelSupport;
import org.tmatesoft.hg.util.CancelledException;
import org.tmatesoft.hg.util.Convertor;
import org.tmatesoft.hg.util.Path;

public class HgStatusCollector {
    private final HgRepository repo;
    private final IntMap<ManifestRevision> cache;
    private final int cacheMaxSize = 50;
    private Convertor<Path> pathPool;
    private final Pool<Nodeid> cacheNodes;
    private final Pool<Path> cacheFilenames;
    private final ManifestRevision emptyFakeState;
    private Path.Matcher scope = new Path.Matcher.Any();
    private boolean detectCopies = true;

    public HgStatusCollector(HgRepository hgRepo) {
        this.repo = hgRepo;
        this.cache = new IntMap(50);
        this.cacheNodes = new Pool();
        this.cacheFilenames = new Pool();
        this.emptyFakeState = HgStatusCollector.createEmptyManifestRevision();
    }

    public HgRepository getRepo() {
        return this.repo;
    }

    private ManifestRevision get(int rev) throws HgRuntimeException {
        ManifestRevision i = this.cache.get(rev);
        if (i == null) {
            if (rev == -1) {
                return this.emptyFakeState;
            }
            this.ensureCacheSize();
            i = new ManifestRevision(this.cacheNodes, this.cacheFilenames);
            this.cache.put(rev, i);
            this.repo.getManifest().walk(rev, rev, i);
        }
        return i;
    }

    private boolean cached(int revision) {
        return this.cache.containsKey(revision) || revision == -1;
    }

    private void ensureCacheSize() {
        if (this.cache.size() > 50) {
            this.cache.removeFromStart(this.cache.size() - 50 + 1);
        }
    }

    private void initCacheRange(int minRev, int maxRev) throws HgRuntimeException {
        this.ensureCacheSize();
        assert (minRev <= maxRev);
        int[] revisionsToCollect = new int[maxRev - minRev + 1];
        int x = minRev;
        int i = 0;
        while (x <= maxRev) {
            revisionsToCollect[i] = x++;
            ++i;
        }
        this.repo.getManifest().walk(new HgManifest.Inspector(){
            private ManifestRevision delegate;
            private boolean cacheHit;

            @Override
            public boolean begin(int manifestRevision, Nodeid nid, int changelogRevision) {
                if (!$assertionsDisabled && this.delegate != null) {
                    throw new AssertionError();
                }
                if (HgStatusCollector.this.cache.containsKey(changelogRevision)) {
                    this.cacheHit = true;
                } else {
                    this.delegate = new ManifestRevision(HgStatusCollector.this.cacheNodes, HgStatusCollector.this.cacheFilenames);
                    HgStatusCollector.this.cache.put(changelogRevision, this.delegate);
                    this.delegate.begin(manifestRevision, nid, changelogRevision);
                    this.cacheHit = false;
                }
                return true;
            }

            @Override
            public boolean next(Nodeid nid, Path fname, HgManifest.Flags flags) {
                if (!this.cacheHit) {
                    this.delegate.next(nid, fname, flags);
                }
                return true;
            }

            @Override
            public boolean end(int revision) {
                if (!this.cacheHit) {
                    this.delegate.end(revision);
                }
                this.cacheHit = false;
                this.delegate = null;
                return true;
            }
        }, revisionsToCollect);
    }

    static ManifestRevision createEmptyManifestRevision() {
        ManifestRevision fakeEmptyRev = new ManifestRevision(null, null);
        fakeEmptyRev.begin(-1, null, -1);
        fakeEmptyRev.end(-1);
        return fakeEmptyRev;
    }

    ManifestRevision raw(int rev) throws HgRuntimeException {
        return this.get(rev);
    }

    Convertor<Path> getPathPool() {
        if (this.pathPool == null) {
            this.pathPool = this.cacheFilenames;
        }
        return this.pathPool;
    }

    public void setPathPool(Convertor<Path> pathConvertor) {
        this.pathPool = pathConvertor;
    }

    public void setScope(Path.Matcher scopeMatcher) {
        this.scope = scopeMatcher == null ? new Path.Matcher.Any() : scopeMatcher;
    }

    public void detectCopies(boolean detect) {
        this.detectCopies = detect;
    }

    public void change(int revisionIndex, HgStatusInspector inspector) throws CancelledException, HgRuntimeException {
        int p;
        if (revisionIndex == 0) {
            p = -1;
        } else {
            int[] parents = new int[2];
            this.repo.getChangelog().parents(revisionIndex, parents, null, null);
            p = parents[0];
        }
        this.walk(p, revisionIndex, inspector);
    }

    public void walk(int rev1, int rev2, HgStatusInspector inspector) throws CancelledException, HgRuntimeException, IllegalArgumentException {
        boolean need2;
        if (rev1 == rev2) {
            throw new IllegalArgumentException();
        }
        if (inspector == null) {
            throw new IllegalArgumentException();
        }
        int lastChangelogRevision = this.repo.getChangelog().getLastRevision();
        if (rev1 == -3) {
            rev1 = lastChangelogRevision;
        }
        if (rev2 == -3) {
            rev2 = lastChangelogRevision;
        }
        if (rev1 != -1 && (HgInternals.wrongRevisionIndex(rev1) || rev1 == -2 || rev1 == Integer.MIN_VALUE || rev1 > lastChangelogRevision)) {
            throw new HgInvalidRevisionException(rev1);
        }
        if (rev2 != -1 && (HgInternals.wrongRevisionIndex(rev2) || rev2 == -2 || rev2 == Integer.MIN_VALUE || rev2 > lastChangelogRevision)) {
            throw new HgInvalidRevisionException(rev2);
        }
        if (inspector instanceof Record) {
            ((Record)inspector).init(rev1, rev2, this);
        }
        boolean need1 = !this.cached(rev1);
        boolean bl = need2 = !this.cached(rev2);
        if (need1 || need2) {
            int maxRev;
            int minRev;
            if (need1 && need2 && Math.abs(rev1 - rev2) < 5) {
                minRev = rev1 < rev2 ? rev1 : rev2;
                int n = maxRev = minRev == rev1 ? rev2 : rev1;
                if (minRev > 0) {
                    --minRev;
                }
                this.initCacheRange(minRev, maxRev);
                need2 = false;
                need1 = false;
            }
            if (need1) {
                minRev = rev1;
                maxRev = rev1 < lastChangelogRevision - 5 ? rev1 + 5 : lastChangelogRevision;
                this.initCacheRange(minRev, maxRev);
            }
            if (need2) {
                minRev = rev2;
                maxRev = rev2 < lastChangelogRevision - 5 ? rev2 + 5 : lastChangelogRevision;
                this.initCacheRange(minRev, maxRev);
            }
        }
        ManifestRevision r1 = this.get(rev1);
        ManifestRevision r2 = this.get(rev2);
        CancelSupport cs = CancelSupport.Factory.get(inspector);
        Collection<Path> allBaseFiles = r1.files();
        TreeSet<Path> r1Files = new TreeSet<Path>(allBaseFiles);
        for (Path r2fname : r2.files()) {
            if (!this.scope.accept(r2fname)) continue;
            if (r1Files.remove(r2fname)) {
                Nodeid nidR1 = r1.nodeid(r2fname);
                Nodeid nidR2 = r2.nodeid(r2fname);
                HgManifest.Flags flagsR1 = r1.flags(r2fname);
                HgManifest.Flags flagsR2 = r2.flags(r2fname);
                if (nidR1.equals(nidR2) && flagsR2 == flagsR1) {
                    inspector.clean(r2fname);
                } else {
                    inspector.modified(r2fname);
                }
                cs.checkCancelled();
                continue;
            }
            try {
                Path copyOrigin;
                Path copyTarget = r2fname;
                Path path = copyOrigin = this.detectCopies ? HgStatusCollector.getOriginIfCopy(this.repo, copyTarget, r2.nodeid(copyTarget), allBaseFiles, rev1) : null;
                if (copyOrigin != null) {
                    inspector.copied(this.getPathPool().mangle(copyOrigin), copyTarget);
                } else {
                    inspector.added(copyTarget);
                }
            }
            catch (HgInvalidFileException ex) {
                inspector.invalid(r2fname, ex);
            }
            cs.checkCancelled();
        }
        for (Path r1fname : r1Files) {
            if (!this.scope.accept(r1fname)) continue;
            inspector.removed(r1fname);
            cs.checkCancelled();
        }
    }

    public Record status(int rev1, int rev2) throws HgRuntimeException {
        Record rv = new Record();
        try {
            this.walk(rev1, rev2, rv);
        }
        catch (CancelledException ex) {
            HgInvalidStateException t = new HgInvalidStateException("Internal error");
            t.initCause(ex);
            throw t;
        }
        return rv;
    }

    static Path getOriginIfCopy(HgRepository hgRepo, Path fname, Nodeid fnameRev, Collection<Path> originals, int originalChangesetIndex) throws HgRuntimeException {
        HgDataFile df = hgRepo.getFileNode(fname);
        if (!df.exists()) {
            String msg = String.format("Didn't find file '%s' in the repo. Perhaps, bad storage name conversion?", fname);
            throw new HgInvalidFileException(msg, null).setFileName(fname).setRevisionIndex(originalChangesetIndex);
        }
        assert (fnameRev != null);
        assert (!Nodeid.NULL.equals(fnameRev));
        int fileRevIndex = fnameRev == null ? 0 : df.getRevisionIndex(fnameRev);
        FileRenameHistory frh = new FileRenameHistory(originalChangesetIndex, df.getChangesetRevisionIndex(fileRevIndex));
        if (frh.isOutOfRange(df, fileRevIndex)) {
            return null;
        }
        frh.build(df, fileRevIndex);
        FileRenameHistory.Chunk c = frh.chunkAt(originalChangesetIndex);
        if (c == null) {
            return null;
        }
        Path nameAtOrigin = c.file().getPath();
        if (originals.contains(nameAtOrigin)) {
            return nameAtOrigin;
        }
        return null;
    }

    public static class Record
    implements HgStatusInspector {
        private List<Path> modified;
        private List<Path> added;
        private List<Path> removed;
        private List<Path> clean;
        private List<Path> missing;
        private List<Path> unknown;
        private List<Path> ignored;
        private Map<Path, Path> copied;
        private Map<Path, Exception> failures;
        private int startRev;
        private int endRev;
        private HgStatusCollector statusHelper;

        void init(int startRevision, int endRevision, HgStatusCollector self) {
            this.startRev = startRevision;
            this.endRev = endRevision;
            this.statusHelper = self;
        }

        public Nodeid nodeidBeforeChange(Path fname) throws HgRuntimeException {
            if (this.statusHelper == null || this.startRev == Integer.MIN_VALUE) {
                return null;
            }
            if (!(this.modified != null && this.modified.contains(fname) || this.removed != null && this.removed.contains(fname))) {
                return null;
            }
            return this.statusHelper.raw(this.startRev).nodeid(fname);
        }

        public Nodeid nodeidAfterChange(Path fname) throws HgRuntimeException {
            if (this.statusHelper == null || this.endRev == Integer.MIN_VALUE) {
                return null;
            }
            if (!(this.modified != null && this.modified.contains(fname) || this.added != null && this.added.contains(fname))) {
                return null;
            }
            return this.statusHelper.raw(this.endRev).nodeid(fname);
        }

        public List<Path> getModified() {
            return Record.proper(this.modified);
        }

        public List<Path> getAdded() {
            return Record.proper(this.added);
        }

        public List<Path> getRemoved() {
            return Record.proper(this.removed);
        }

        public Map<Path, Path> getCopied() {
            if (this.copied == null) {
                return Collections.emptyMap();
            }
            return Collections.unmodifiableMap(this.copied);
        }

        public List<Path> getClean() {
            return Record.proper(this.clean);
        }

        public List<Path> getMissing() {
            return Record.proper(this.missing);
        }

        public List<Path> getUnknown() {
            return Record.proper(this.unknown);
        }

        public List<Path> getIgnored() {
            return Record.proper(this.ignored);
        }

        public Map<Path, Exception> getInvalid() {
            if (this.failures == null) {
                return Collections.emptyMap();
            }
            return Collections.unmodifiableMap(this.failures);
        }

        private static List<Path> proper(List<Path> l) {
            if (l == null) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(l);
        }

        @Override
        public void modified(Path fname) {
            this.modified = Record.doAdd(this.modified, fname);
        }

        @Override
        public void added(Path fname) {
            this.added = Record.doAdd(this.added, fname);
        }

        @Override
        public void copied(Path fnameOrigin, Path fnameAdded) {
            if (this.copied == null) {
                this.copied = new LinkedHashMap<Path, Path>();
            }
            this.added(fnameAdded);
            this.copied.put(fnameAdded, fnameOrigin);
        }

        @Override
        public void removed(Path fname) {
            this.removed = Record.doAdd(this.removed, fname);
        }

        @Override
        public void clean(Path fname) {
            this.clean = Record.doAdd(this.clean, fname);
        }

        @Override
        public void missing(Path fname) {
            this.missing = Record.doAdd(this.missing, fname);
        }

        @Override
        public void unknown(Path fname) {
            this.unknown = Record.doAdd(this.unknown, fname);
        }

        @Override
        public void ignored(Path fname) {
            this.ignored = Record.doAdd(this.ignored, fname);
        }

        @Override
        public void invalid(Path fname, Exception ex) {
            if (this.failures == null) {
                this.failures = new LinkedHashMap<Path, Exception>();
            }
            this.failures.put(fname, ex);
        }

        private static List<Path> doAdd(List<Path> l, Path p) {
            if (l == null) {
                l = new LinkedList<Path>();
            }
            l.add(p);
            return l;
        }
    }
}

