/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.repo;

import java.io.File;
import org.tmatesoft.hg.core.HgRepositoryNotFoundException;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.internal.Internals;
import org.tmatesoft.hg.repo.HgInvalidStateException;
import org.tmatesoft.hg.repo.HgLookup;
import org.tmatesoft.hg.repo.HgRepository;
import org.tmatesoft.hg.util.Path;

public class HgSubrepoLocation {
    private final HgRepository owner;
    private final Kind kind;
    private final Path location;
    private final String source;
    private final Nodeid revInfo;

    HgSubrepoLocation(HgRepository parentRepo, Path repoLocation, String actualLocation, Kind type, Nodeid revision) {
        this.owner = parentRepo;
        this.location = repoLocation;
        this.source = actualLocation;
        this.kind = type;
        this.revInfo = revision;
    }

    public Path getLocation() {
        return this.location;
    }

    public String getSource() {
        return this.source;
    }

    public Kind getType() {
        return this.kind;
    }

    public Nodeid getRevision() {
        return this.revInfo;
    }

    public boolean isCommitted() {
        return this.revInfo != null;
    }

    public boolean hasChanges() {
        throw Internals.notImplemented();
    }

    public HgRepository getOwner() {
        return this.owner;
    }

    public HgRepository getRepo() throws HgRepositoryNotFoundException {
        if (this.kind != Kind.Hg) {
            throw new HgInvalidStateException(String.format("Unsupported subrepository %s", new Object[]{this.kind}));
        }
        return new HgLookup().detect(new File(this.owner.getWorkingDir(), this.source));
    }

    public static enum Kind {
        Hg,
        SVN,
        Git;

    }
}

