/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.repo;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.tmatesoft.hg.core.HgBadNodeidFormatException;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.internal.ByteArrayChannel;
import org.tmatesoft.hg.internal.ChangelogMonitor;
import org.tmatesoft.hg.internal.FileChangeMonitor;
import org.tmatesoft.hg.internal.Internals;
import org.tmatesoft.hg.repo.HgDataFile;
import org.tmatesoft.hg.repo.HgInvalidControlFileException;
import org.tmatesoft.hg.repo.HgRepositoryFiles;
import org.tmatesoft.hg.repo.HgRuntimeException;
import org.tmatesoft.hg.util.CancelledException;
import org.tmatesoft.hg.util.LogFacility;

public class HgTags {
    private final Internals repo;
    private final Map<Nodeid, List<String>> globalToName;
    private final Map<Nodeid, List<String>> localToName;
    private final Map<String, List<Nodeid>> globalFromName;
    private final Map<String, List<Nodeid>> localFromName;
    private FileChangeMonitor globalTagsFileMonitor;
    private FileChangeMonitor localTagsFileMonitor;
    private ChangelogMonitor repoChangeMonitor;
    private Map<String, TagInfo> tags;

    HgTags(Internals internalRepo) {
        this.repo = internalRepo;
        this.globalToName = new HashMap<Nodeid, List<String>>();
        this.localToName = new HashMap<Nodeid, List<String>>();
        this.globalFromName = new TreeMap<String, List<Nodeid>>();
        this.localFromName = new TreeMap<String, List<Nodeid>>();
    }

    void read() throws HgRuntimeException {
        this.readTagsFromHistory();
        this.readGlobal();
        this.readLocal();
    }

    private void readTagsFromHistory() throws HgRuntimeException {
        HgDataFile hgTags = this.repo.getRepo().getFileNode(HgRepositoryFiles.HgTags.getPath());
        if (hgTags.exists()) {
            int i = 0;
            while (i <= hgTags.getLastRevision()) {
                try {
                    ByteArrayChannel sink = new ByteArrayChannel();
                    hgTags.content(i, sink);
                    String content = new String(sink.toArray(), "UTF8");
                    this.readGlobal(new StringReader(content));
                }
                catch (CancelledException ex) {
                    this.repo.getLog().dump(this.getClass(), LogFacility.Severity.Debug, ex, null);
                }
                catch (IOException ex) {
                    this.repo.getLog().dump(this.getClass(), LogFacility.Severity.Error, ex, null);
                }
                ++i;
            }
        }
        if (this.repoChangeMonitor == null) {
            this.repoChangeMonitor = new ChangelogMonitor(this.repo.getRepo());
        }
        this.repoChangeMonitor.touch();
    }

    private void readLocal() throws HgInvalidControlFileException {
        File localTags = this.repo.getRepositoryFile(HgRepositoryFiles.HgLocalTags);
        if (localTags.canRead() && localTags.isFile()) {
            this.read(localTags, this.localToName, this.localFromName);
        }
        if (this.localTagsFileMonitor == null) {
            this.localTagsFileMonitor = new FileChangeMonitor(localTags);
        }
        this.localTagsFileMonitor.touch(this);
    }

    private void readGlobal() throws HgInvalidControlFileException {
        File globalTags = this.repo.getRepositoryFile(HgRepositoryFiles.HgTags);
        if (globalTags.canRead() && globalTags.isFile()) {
            this.read(globalTags, this.globalToName, this.globalFromName);
        }
        if (this.globalTagsFileMonitor == null) {
            this.globalTagsFileMonitor = new FileChangeMonitor(globalTags);
        }
        this.globalTagsFileMonitor.touch(this);
    }

    private void readGlobal(Reader globalTags) throws IOException {
        try (BufferedReader r = null;){
            r = new BufferedReader(globalTags);
            this.read(r, this.globalToName, this.globalFromName);
        }
    }

    private void read(File f, Map<Nodeid, List<String>> nid2name, Map<String, List<Nodeid>> name2nid) throws HgInvalidControlFileException {
        if (!f.canRead()) {
            return;
        }
        BufferedReader r = null;
        try {
            try {
                r = new BufferedReader(new FileReader(f));
                this.read(r, nid2name, name2nid);
            }
            catch (IOException ex) {
                this.repo.getLog().dump(this.getClass(), LogFacility.Severity.Error, ex, null);
                throw new HgInvalidControlFileException("Failed to read tags", ex, f);
            }
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (IOException ex) {
                    this.repo.getLog().dump(this.getClass(), LogFacility.Severity.Warn, ex, null);
                }
            }
        }
    }

    private void read(BufferedReader reader, Map<Nodeid, List<String>> nid2name, Map<String, List<Nodeid>> name2nid) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).length() == 0) continue;
            int spacePos = line.indexOf(32);
            if (line.length() < 42 || spacePos != 40) {
                this.repo.getLog().dump(this.getClass(), LogFacility.Severity.Warn, "Bad tags line: %s", line);
                continue;
            }
            try {
                assert (spacePos == 40);
                byte[] nodeidBytes = line.substring(0, spacePos).getBytes();
                Nodeid nid = Nodeid.fromAscii(nodeidBytes, 0, nodeidBytes.length);
                String tagName = line.substring(spacePos + 1);
                List<Nodeid> nids = name2nid.get(tagName);
                if (nids == null) {
                    nids = new LinkedList<Nodeid>();
                    nids.add(nid);
                    tagName = new String(tagName);
                    name2nid.put(tagName, nids);
                } else if (!nid.equals(nids.get(0))) {
                    ((LinkedList)nids).addFirst(nid);
                }
                List<String> revTags = nid2name.get(nid);
                if (revTags == null) {
                    revTags = new LinkedList<String>();
                    revTags.add(tagName);
                    nid2name.put(nid, revTags);
                    continue;
                }
                if (revTags.contains(tagName)) continue;
                revTags.add(tagName);
            }
            catch (HgBadNodeidFormatException ex) {
                this.repo.getLog().dump(this.getClass(), LogFacility.Severity.Error, "Bad revision '%s' in line '%s':%s", line.substring(0, spacePos), line, ex.getMessage());
            }
        }
    }

    public List<String> tags(Nodeid nid) {
        ArrayList<String> rv = new ArrayList<String>(5);
        List<String> l = this.localToName.get(nid);
        if (l != null) {
            rv.addAll(l);
        }
        if ((l = this.globalToName.get(nid)) != null) {
            rv.addAll(l);
        }
        return rv;
    }

    public boolean isTagged(Nodeid nid) {
        return this.localToName.containsKey(nid) || this.globalToName.containsKey(nid);
    }

    public List<Nodeid> tagged(String tagName) {
        ArrayList<Nodeid> rv = new ArrayList<Nodeid>(5);
        List<Nodeid> l = this.localFromName.get(tagName);
        if (l != null) {
            rv.addAll(l);
        }
        if ((l = this.globalFromName.get(tagName)) != null) {
            rv.addAll(l);
        }
        return rv;
    }

    public Map<String, TagInfo> getAllTags() {
        if (this.tags == null) {
            this.tags = new TreeMap<String, TagInfo>();
            for (String t : this.globalFromName.keySet()) {
                this.tags.put(t, new TagInfo(t));
            }
            for (String t : this.localFromName.keySet()) {
                this.tags.put(t, new TagInfo(t));
            }
            this.tags = Collections.unmodifiableMap(this.tags);
        }
        return this.tags;
    }

    public Map<String, TagInfo> getActiveTags() {
        TreeMap<String, TagInfo> rv = new TreeMap<String, TagInfo>();
        for (Map.Entry<String, TagInfo> e : this.getAllTags().entrySet()) {
            if (e.getValue().isRemoved()) continue;
            rv.put(e.getKey(), e.getValue());
        }
        return rv;
    }

    void reloadIfChanged() throws HgRuntimeException {
        assert (this.repoChangeMonitor != null);
        assert (this.localTagsFileMonitor != null);
        assert (this.globalTagsFileMonitor != null);
        if (this.repoChangeMonitor.isChanged() || this.globalTagsFileMonitor.changed(this)) {
            this.globalFromName.clear();
            this.globalToName.clear();
            this.readTagsFromHistory();
            this.readGlobal();
            this.tags = null;
        }
        if (this.localTagsFileMonitor.changed(this)) {
            this.readLocal();
            this.tags = null;
        }
    }

    public final class TagInfo {
        private final String name;
        private String branch;

        TagInfo(String tagName) {
            this.name = tagName;
        }

        public String name() {
            return this.name;
        }

        public boolean isLocal() {
            return HgTags.this.localFromName.containsKey(this.name);
        }

        public String branch() throws HgRuntimeException {
            if (this.branch == null) {
                int x = HgTags.this.repo.getRepo().getChangelog().getRevisionIndex(this.revision());
                this.branch = HgTags.this.repo.getRepo().getChangelog().range(x, x).get(0).branch();
            }
            return this.branch;
        }

        public Nodeid revision() {
            if (this.isLocal()) {
                return (Nodeid)((List)HgTags.this.localFromName.get(this.name)).get(0);
            }
            return (Nodeid)((List)HgTags.this.globalFromName.get(this.name)).get(0);
        }

        public boolean isRemoved() {
            return this.revision().isNull();
        }
    }
}

