/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.repo;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.core.SessionContext;
import org.tmatesoft.hg.internal.ByteArrayChannel;
import org.tmatesoft.hg.internal.FileUtils;
import org.tmatesoft.hg.internal.FilterByteChannel;
import org.tmatesoft.hg.internal.Internals;
import org.tmatesoft.hg.internal.ManifestRevision;
import org.tmatesoft.hg.internal.PathPool;
import org.tmatesoft.hg.internal.PathScope;
import org.tmatesoft.hg.internal.Preview;
import org.tmatesoft.hg.repo.HgDataFile;
import org.tmatesoft.hg.repo.HgDirstate;
import org.tmatesoft.hg.repo.HgIgnore;
import org.tmatesoft.hg.repo.HgInternals;
import org.tmatesoft.hg.repo.HgInvalidControlFileException;
import org.tmatesoft.hg.repo.HgInvalidFileException;
import org.tmatesoft.hg.repo.HgInvalidRevisionException;
import org.tmatesoft.hg.repo.HgInvalidStateException;
import org.tmatesoft.hg.repo.HgManifest;
import org.tmatesoft.hg.repo.HgRepository;
import org.tmatesoft.hg.repo.HgRuntimeException;
import org.tmatesoft.hg.repo.HgStatusCollector;
import org.tmatesoft.hg.repo.HgStatusInspector;
import org.tmatesoft.hg.util.Adaptable;
import org.tmatesoft.hg.util.ByteChannel;
import org.tmatesoft.hg.util.CancelSupport;
import org.tmatesoft.hg.util.CancelledException;
import org.tmatesoft.hg.util.Convertor;
import org.tmatesoft.hg.util.FileInfo;
import org.tmatesoft.hg.util.FileIterator;
import org.tmatesoft.hg.util.LogFacility;
import org.tmatesoft.hg.util.Path;
import org.tmatesoft.hg.util.PathRewrite;
import org.tmatesoft.hg.util.RegularFileInfo;

public class HgWorkingCopyStatusCollector {
    private final HgRepository repo;
    private final FileIterator repoWalker;
    private HgDirstate dirstate;
    private HgStatusCollector baseRevisionCollector;
    private Convertor<Path> pathPool;
    private ManifestRevision dirstateParentManifest;

    public HgWorkingCopyStatusCollector(HgRepository hgRepo) {
        this(hgRepo, new HgInternals(hgRepo).createWorkingDirWalker(null));
    }

    public HgWorkingCopyStatusCollector(HgRepository hgRepo, FileIterator workingCopyWalker) {
        this.repo = hgRepo;
        this.repoWalker = workingCopyWalker;
    }

    public void setBaseRevisionCollector(HgStatusCollector sc) {
        this.baseRevisionCollector = sc;
    }

    Convertor<Path> getPathPool() {
        if (this.pathPool == null) {
            if (this.baseRevisionCollector == null) {
                this.pathPool = new PathPool(new PathRewrite.Empty());
            } else {
                return this.baseRevisionCollector.getPathPool();
            }
        }
        return this.pathPool;
    }

    public void setPathPool(Convertor<Path> pathConvertor) {
        this.pathPool = pathConvertor;
    }

    public HgDirstate getDirstate() throws HgInvalidControlFileException {
        if (this.dirstate == null) {
            Convertor<Path> pp = this.getPathPool();
            Path.Source ps = pp instanceof Path.Source ? (Path.Source)((Object)pp) : new Path.SimpleSource(new PathRewrite.Empty(), pp);
            this.dirstate = this.repo.loadDirstate(ps);
        }
        return this.dirstate;
    }

    private HgDirstate getDirstateImpl() {
        return this.dirstate;
    }

    private ManifestRevision getManifest(int changelogLocalRev) throws HgRuntimeException {
        ManifestRevision mr;
        assert (changelogLocalRev >= 0);
        if (this.baseRevisionCollector != null) {
            mr = this.baseRevisionCollector.raw(changelogLocalRev);
        } else {
            mr = new ManifestRevision(null, null);
            this.repo.getManifest().walk(changelogLocalRev, changelogLocalRev, mr);
        }
        return mr;
    }

    private void initDirstateParentManifest() throws HgRuntimeException {
        Nodeid dirstateParent = this.getDirstateImpl().parents().first();
        if (dirstateParent.isNull()) {
            this.dirstateParentManifest = this.baseRevisionCollector != null ? this.baseRevisionCollector.raw(-1) : HgStatusCollector.createEmptyManifestRevision();
        } else {
            int changeloRevIndex = this.repo.getChangelog().getRevisionIndex(dirstateParent);
            this.dirstateParentManifest = this.getManifest(changeloRevIndex);
        }
    }

    private ManifestRevision getDirstateParentManifest() {
        return this.dirstateParentManifest;
    }

    public void walk(int baseRevision, HgStatusInspector inspector) throws IOException, CancelledException, HgRuntimeException {
        if (HgInternals.wrongRevisionIndex(baseRevision) || baseRevision == Integer.MIN_VALUE) {
            throw new HgInvalidRevisionException(baseRevision);
        }
        if (this.getDirstateImpl() == null) {
            this.getDirstate();
        }
        if (this.getDirstateParentManifest() == null) {
            this.initDirstateParentManifest();
        }
        ManifestRevision collect = null;
        Set<Path> baseRevFiles = Collections.emptySet();
        if (baseRevision != -3 && baseRevision != -2) {
            collect = this.getManifest(baseRevision);
            baseRevFiles = new TreeSet<Path>(collect.files());
        }
        if (inspector instanceof HgStatusCollector.Record) {
            HgStatusCollector sc = this.baseRevisionCollector == null ? new HgStatusCollector(this.repo) : this.baseRevisionCollector;
            int rev2 = this.getDirstateParentManifest().changesetRevisionIndex();
            int rev1 = baseRevision == -3 || baseRevision == -2 ? rev2 - 1 : baseRevision;
            ((HgStatusCollector.Record)inspector).init(rev1, rev2, sc);
        }
        CancelSupport cs = CancelSupport.Factory.get(inspector);
        HgIgnore hgIgnore = this.repo.getIgnore();
        this.repoWalker.reset();
        TreeSet<Path> processed = new TreeSet<Path>();
        HgDirstate ds = this.getDirstateImpl();
        TreeSet<Path> knownEntries = ds.all();
        while (this.repoWalker.hasNext()) {
            Path knownInDirstate;
            cs.checkCancelled();
            this.repoWalker.next();
            Path fname = this.getPathPool().mangle(this.repoWalker.name());
            FileInfo f = this.repoWalker.file();
            if (!f.exists()) {
                knownInDirstate = ds.known(fname);
                if (knownInDirstate != null) {
                    processed.add(knownInDirstate);
                    if (ds.checkRemoved(knownInDirstate) == null) {
                        inspector.missing(knownInDirstate);
                    } else {
                        inspector.removed(knownInDirstate);
                    }
                    if (collect == null) continue;
                    baseRevFiles.remove(knownInDirstate);
                    continue;
                }
                if (collect != null && baseRevFiles.remove(fname)) {
                    inspector.removed(fname);
                    continue;
                }
                inspector.unknown(fname);
                continue;
            }
            knownInDirstate = ds.known(fname);
            if (knownInDirstate != null) {
                processed.add(knownInDirstate);
                if (collect != null) {
                    this.checkLocalStatusAgainstBaseRevision(baseRevFiles, collect, baseRevision, knownInDirstate, f, inspector);
                    continue;
                }
                this.checkLocalStatusAgainstFile(knownInDirstate, f, inspector);
                continue;
            }
            if (hgIgnore.isIgnored(fname)) {
                inspector.ignored(fname);
                continue;
            }
            inspector.unknown(fname);
        }
        if (collect != null) {
            for (Path fromBase : baseRevFiles) {
                if (!this.repoWalker.inScope(fromBase)) continue;
                inspector.removed(fromBase);
                processed.add(fromBase);
                cs.checkCancelled();
            }
        }
        knownEntries.removeAll(processed);
        for (Path m : knownEntries) {
            if (!this.repoWalker.inScope(m)) continue;
            cs.checkCancelled();
            if (ds.checkRemoved(m) == null) {
                inspector.missing(m);
                continue;
            }
            if (collect != null && !baseRevFiles.contains(m)) continue;
            inspector.removed(m);
        }
    }

    public HgStatusCollector.Record status(int baseRevision) throws IOException, HgRuntimeException {
        HgStatusCollector.Record rv = new HgStatusCollector.Record();
        try {
            this.walk(baseRevision, rv);
        }
        catch (CancelledException ex) {
            HgInvalidStateException t = new HgInvalidStateException("Internal error");
            t.initCause(ex);
            throw t;
        }
        return rv;
    }

    public boolean hasTangibleChanges(Path fname, FileInfo fileInfo) throws HgRuntimeException {
        HgDataFile df = this.repo.getFileNode(fname);
        if (!df.exists()) {
            throw new HgInvalidFileException("File not found", null).setFileName(fname);
        }
        Nodeid rev = this.getDirstateParentManifest().nodeid(fname);
        return rev == null || !this.areTheSame(fileInfo, df, rev);
    }

    private void checkLocalStatusAgainstFile(Path fname, FileInfo f, HgStatusInspector inspector) {
        block22: {
            HgDirstate.Record r = this.getDirstateImpl().checkNormal(fname);
            if (r != null) {
                boolean sizeEqual;
                boolean timestampEqual = f.lastModified() == r.modificationTime();
                boolean bl = sizeEqual = (long)r.size() == f.length();
                if (timestampEqual && sizeEqual) {
                    if (this.checkFlagsEqual(f, r.mode())) {
                        inspector.clean(fname);
                    } else {
                        inspector.modified(fname);
                    }
                } else if (!sizeEqual && r.size() >= 0) {
                    inspector.modified(fname);
                } else if (r.size() == -2) {
                    inspector.modified(fname);
                } else {
                    try {
                        if (!this.checkFlagsEqual(f, r.mode())) {
                            inspector.modified(fname);
                            break block22;
                        }
                        HgDataFile df = this.repo.getFileNode(fname);
                        if (!df.exists()) {
                            Internals implRepo = this.repo.getImplHelper();
                            String msg = String.format("File %s known as normal in dirstate (%d, %d), doesn't exist at %s", fname, r.modificationTime(), r.size(), implRepo.getStoragePath(df));
                            throw new HgInvalidFileException(msg, null).setFileName(fname);
                        }
                        Nodeid rev = this.getDirstateParentManifest().nodeid(fname);
                        if (rev == null || !this.areTheSame(f, df, rev)) {
                            inspector.modified(df.getPath());
                            break block22;
                        }
                        inspector.clean(df.getPath());
                    }
                    catch (HgRuntimeException ex) {
                        this.repo.getSessionContext().getLog().dump(this.getClass(), LogFacility.Severity.Warn, ex, null);
                        inspector.invalid(fname, ex);
                    }
                }
            } else {
                r = this.getDirstateImpl().checkAdded(fname);
                if (r != null) {
                    if (r.copySource() == null) {
                        inspector.added(fname);
                    } else {
                        inspector.copied(r.copySource(), fname);
                    }
                } else {
                    r = this.getDirstateImpl().checkRemoved(fname);
                    if (r != null) {
                        inspector.removed(fname);
                    } else {
                        r = this.getDirstateImpl().checkMerged(fname);
                        if (r != null) {
                            inspector.modified(fname);
                        }
                    }
                }
            }
        }
    }

    private void checkLocalStatusAgainstBaseRevision(Set<Path> baseRevNames, ManifestRevision collect, int baseRevision, Path fname, FileInfo f, HgStatusInspector inspector) throws HgRuntimeException {
        Nodeid nid1 = collect.nodeid(fname);
        HgManifest.Flags flags = collect.flags(fname);
        HgDirstate ds = this.getDirstateImpl();
        if (nid1 == null) {
            if (ds.checkNormal(fname) != null || ds.checkMerged(fname) != null) {
                try {
                    Path origin;
                    Nodeid nidFromDirstate = this.getDirstateParentManifest().nodeid(fname);
                    if (nidFromDirstate != null && (origin = HgStatusCollector.getOriginIfCopy(this.repo, fname, nidFromDirstate, collect.files(), baseRevision)) != null) {
                        inspector.copied(this.getPathPool().mangle(origin), fname);
                        return;
                    }
                }
                catch (HgInvalidFileException ex) {
                    inspector.invalid(fname, ex);
                }
            } else {
                HgDirstate.Record r = ds.checkAdded(fname);
                if (r != null) {
                    if (r.copySource() != null && baseRevNames.contains(r.copySource())) {
                        inspector.copied(r.copySource(), fname);
                        return;
                    }
                } else if (ds.checkRemoved(fname) != null) {
                    return;
                }
            }
            inspector.added(fname);
        } else {
            Nodeid nidFromDirstate = this.getDirstateParentManifest().nodeid(fname);
            HgDirstate.Record r = ds.checkNormal(fname);
            if (r != null && nid1.equals(nidFromDirstate)) {
                boolean timestampEqual = f.lastModified() == r.modificationTime();
                boolean sizeEqual = (long)r.size() == f.length();
                boolean handled = false;
                if (timestampEqual && sizeEqual) {
                    inspector.clean(fname);
                    handled = true;
                } else if (!sizeEqual && r.size() >= 0) {
                    inspector.modified(fname);
                    handled = true;
                } else if (!this.checkFlagsEqual(f, flags)) {
                    inspector.modified(fname);
                    handled = true;
                }
                if (handled) {
                    baseRevNames.remove(fname);
                    return;
                }
            }
            if (r != null || (r = ds.checkMerged(fname)) != null || (r = ds.checkAdded(fname)) != null) {
                try {
                    HgDataFile fileNode = this.repo.getFileNode(fname);
                    if (this.areTheSame(f, fileNode, nid1)) {
                        inspector.clean(fname);
                    } else {
                        inspector.modified(fname);
                    }
                }
                catch (HgRuntimeException ex) {
                    this.repo.getSessionContext().getLog().dump(this.getClass(), LogFacility.Severity.Warn, ex, null);
                    inspector.invalid(fname, ex);
                }
                baseRevNames.remove(fname);
            } else if (this.getDirstateImpl().checkRemoved(fname) != null) {
                inspector.removed(fname);
                baseRevNames.remove(fname);
            }
        }
    }

    private boolean areTheSame(FileInfo f, HgDataFile dataFile, Nodeid revision) throws HgRuntimeException {
        ByteArrayChannel bac = new ByteArrayChannel();
        try {
            int fileRevisionIndex = dataFile.getRevisionIndex(revision);
            dataFile.content(fileRevisionIndex, bac);
        }
        catch (CancelledException cancelledException) {}
        return this.areTheSame(f, bac.toArray(), dataFile.getPath());
    }

    private boolean areTheSame(FileInfo f, byte[] data, Path p) throws HgInvalidFileException {
        ReadableByteChannel is = null;
        class Check
        implements ByteChannel {
            final boolean debug;
            boolean sameSoFar;
            int x;
            private final /* synthetic */ byte[] val$data;

            Check(byte[] byArray) {
                this.val$data = byArray;
                this.debug = HgWorkingCopyStatusCollector.this.repo.getSessionContext().getLog().isDebug();
                this.sameSoFar = true;
                this.x = 0;
            }

            @Override
            public int write(ByteBuffer buffer) {
                int i = buffer.remaining();
                while (i > 0) {
                    if (this.x >= this.val$data.length || this.val$data[this.x] != buffer.get()) {
                        if (this.debug) {
                            String exp;
                            byte[] xx = new byte[15];
                            if (buffer.position() > 5) {
                                buffer.position(buffer.position() - 5);
                            }
                            buffer.get(xx, 0, Math.min(xx.length, i - 1));
                            if (this.x < this.val$data.length) {
                                exp = new String(this.val$data, Math.max(0, this.x - 4), Math.min(this.val$data.length - this.x, 20));
                            } else {
                                int offset = Math.max(0, this.x - 4);
                                exp = new String(this.val$data, offset, Math.min(this.val$data.length - offset, 20));
                            }
                            HgWorkingCopyStatusCollector.this.repo.getSessionContext().getLog().dump(this.getClass(), LogFacility.Severity.Debug, "expected >>%s<< but got >>%s<<", exp, new String(xx));
                        }
                        this.sameSoFar = false;
                        break;
                    }
                    --i;
                    ++this.x;
                }
                buffer.position(buffer.limit());
                return buffer.limit();
            }

            public boolean sameSoFar() {
                return this.sameSoFar;
            }

            public boolean ultimatelyTheSame() {
                return this.sameSoFar && this.x == this.val$data.length;
            }
        }
        Check check = new Check(data);
        try {
            is = f.newInputChannel();
            ByteBuffer fb = ByteBuffer.allocate(Math.min(1 + data.length * 2, 8192));
            FilterByteChannel filters = new FilterByteChannel(check, this.repo.getFiltersFromWorkingDirToRepo(p));
            Preview preview = Adaptable.Factory.getAdapter(filters, Preview.class, null);
            if (preview != null) {
                while (is.read(fb) != -1) {
                    fb.flip();
                    preview.preview(fb);
                    fb.clear();
                }
                try {
                    is.close();
                }
                catch (IOException ex) {
                    this.repo.getSessionContext().getLog().dump(this.getClass(), LogFacility.Severity.Info, ex, null);
                }
                is = f.newInputChannel();
                fb.clear();
            }
            while (is.read(fb) != -1 && check.sameSoFar()) {
                fb.flip();
                filters.write(fb);
                fb.compact();
            }
            boolean bl = check.ultimatelyTheSame();
            return bl;
        }
        catch (CancelledException ex) {
            this.repo.getSessionContext().getLog().dump(this.getClass(), LogFacility.Severity.Warn, ex, "Unexpected cancellation");
            boolean bl = check.ultimatelyTheSame();
            return bl;
        }
        catch (IOException ex) {
            throw new HgInvalidFileException("File comparison failed", ex).setFileName(p);
        }
        finally {
            new FileUtils(this.repo.getSessionContext().getLog(), this).closeQuietly(is);
        }
    }

    private boolean checkFlagsEqual(FileInfo f, HgManifest.Flags originalManifestFlags) {
        boolean same = true;
        if (this.repoWalker.supportsLinkFlag()) {
            if (originalManifestFlags == HgManifest.Flags.Link) {
                return f.isSymlink();
            }
            boolean bl = same = !f.isSymlink();
        }
        if (this.repoWalker.supportsExecFlag()) {
            if (originalManifestFlags == HgManifest.Flags.Exec) {
                return f.isExecutable();
            }
            same = same || !f.isExecutable();
        }
        return same;
    }

    private boolean checkFlagsEqual(FileInfo f, int dirstateFileMode) {
        return this.checkFlagsEqual(f, HgManifest.Flags.parse(dirstateFileMode));
    }

    public static HgWorkingCopyStatusCollector create(HgRepository hgRepo, Path ... paths) {
        ArrayList<Path> f = new ArrayList<Path>(5);
        ArrayList<Path> d = new ArrayList<Path>(5);
        Path[] pathArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            Path p = pathArray[n2];
            if (p.isDirectory()) {
                d.add(p);
            } else {
                f.add(p);
            }
            ++n2;
        }
        if (d.isEmpty()) {
            Path[] files = f.toArray(new Path[f.size()]);
            FileListIterator fi = new FileListIterator(hgRepo.getSessionContext(), hgRepo.getWorkingDir(), files);
            return new HgWorkingCopyStatusCollector(hgRepo, fi);
        }
        FileIterator fi = new HgInternals(hgRepo).createWorkingDirWalker(new PathScope(true, paths));
        return new HgWorkingCopyStatusCollector(hgRepo, fi);
    }

    public static HgWorkingCopyStatusCollector create(HgRepository hgRepo, Path.Matcher scope) {
        FileIterator w = new HgInternals(hgRepo).createWorkingDirWalker(null);
        FileIterator wf = scope == null || scope instanceof Path.Matcher.Any ? w : new FileIteratorFilter(w, scope);
        return new HgWorkingCopyStatusCollector(hgRepo, wf);
    }

    private static class FileIteratorFilter
    implements FileIterator {
        private final Path.Matcher filter;
        private final FileIterator walker;
        private boolean didNext = false;

        public FileIteratorFilter(FileIterator fileWalker, Path.Matcher filterMatcher) {
            assert (fileWalker != null);
            assert (filterMatcher != null);
            this.filter = filterMatcher;
            this.walker = fileWalker;
        }

        @Override
        public void reset() throws IOException {
            this.walker.reset();
        }

        @Override
        public boolean hasNext() throws IOException {
            while (this.walker.hasNext()) {
                this.walker.next();
                if (!this.filter.accept(this.walker.name())) continue;
                this.didNext = true;
                return true;
            }
            return false;
        }

        @Override
        public void next() throws IOException {
            if (this.didNext) {
                this.didNext = false;
            } else if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public Path name() {
            return this.walker.name();
        }

        @Override
        public FileInfo file() {
            return this.walker.file();
        }

        @Override
        public boolean inScope(Path file) {
            return this.filter.accept(file);
        }

        @Override
        public boolean supportsExecFlag() {
            return this.walker.supportsExecFlag();
        }

        @Override
        public boolean supportsLinkFlag() {
            return this.walker.supportsLinkFlag();
        }
    }

    private static class FileListIterator
    implements FileIterator {
        private final File dir;
        private final Path[] paths;
        private int index;
        private RegularFileInfo nextFile;
        private final boolean execCap;
        private final boolean linkCap;
        private final SessionContext sessionContext;

        public FileListIterator(SessionContext ctx, File startDir, Path ... files) {
            this.sessionContext = ctx;
            this.dir = startDir;
            this.paths = files;
            this.reset();
            this.execCap = Internals.checkSupportsExecutables(startDir);
            this.linkCap = Internals.checkSupportsSymlinks(startDir);
        }

        @Override
        public void reset() {
            this.index = -1;
            this.nextFile = new RegularFileInfo(this.sessionContext, this.execCap, this.linkCap);
        }

        @Override
        public boolean hasNext() {
            return this.paths.length > 0 && this.index < this.paths.length - 1;
        }

        @Override
        public void next() {
            ++this.index;
            if (this.index == this.paths.length) {
                throw new NoSuchElementException();
            }
            this.nextFile.init(new File(this.dir, this.paths[this.index].toString()));
        }

        @Override
        public Path name() {
            return this.paths[this.index];
        }

        @Override
        public FileInfo file() {
            return this.nextFile;
        }

        @Override
        public boolean inScope(Path file) {
            int i = 0;
            while (i < this.paths.length) {
                if (this.paths[i].equals(file)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        @Override
        public boolean supportsExecFlag() {
            return this.execCap;
        }

        @Override
        public boolean supportsLinkFlag() {
            return this.linkCap;
        }
    }
}

