/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.repo;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.internal.DataAccess;
import org.tmatesoft.hg.internal.IntMap;
import org.tmatesoft.hg.internal.Preview;
import org.tmatesoft.hg.internal.RevisionLookup;
import org.tmatesoft.hg.internal.RevlogDelegate;
import org.tmatesoft.hg.internal.RevlogStream;
import org.tmatesoft.hg.repo.HgInvalidControlFileException;
import org.tmatesoft.hg.repo.HgInvalidRevisionException;
import org.tmatesoft.hg.repo.HgInvalidStateException;
import org.tmatesoft.hg.repo.HgParentChildMap;
import org.tmatesoft.hg.repo.HgRepository;
import org.tmatesoft.hg.repo.HgRuntimeException;
import org.tmatesoft.hg.util.Adaptable;
import org.tmatesoft.hg.util.ByteChannel;
import org.tmatesoft.hg.util.CancelSupport;
import org.tmatesoft.hg.util.CancelledException;
import org.tmatesoft.hg.util.LogFacility;
import org.tmatesoft.hg.util.ProgressSupport;

abstract class Revlog {
    private final HgRepository repo;
    protected final RevlogStream content;
    protected final boolean useRevisionLookup;
    protected RevisionLookup revisionLookup;
    private final RevlogStream.Observer revisionLookupCleaner;

    protected Revlog(HgRepository hgRepo, RevlogStream contentStream, boolean needRevisionLookup) {
        if (hgRepo == null) {
            throw new IllegalArgumentException();
        }
        if (contentStream == null) {
            throw new IllegalArgumentException();
        }
        this.repo = hgRepo;
        this.content = contentStream;
        this.useRevisionLookup = needRevisionLookup;
        this.revisionLookupCleaner = needRevisionLookup ? new RevlogStream.Observer(){

            @Override
            public void reloaded(RevlogStream src) {
                Revlog.this.revisionLookup = null;
            }
        } : null;
    }

    protected Revlog(HgRepository hgRepo) {
        this.repo = hgRepo;
        this.content = null;
        this.useRevisionLookup = false;
        this.revisionLookupCleaner = null;
    }

    public final HgRepository getRepo() {
        return this.repo;
    }

    public final int getRevisionCount() throws HgRuntimeException {
        return this.content.revisionCount();
    }

    public final int getLastRevision() throws HgRuntimeException {
        int revCount = this.content.revisionCount();
        return revCount == 0 ? -1 : revCount - 1;
    }

    public final Nodeid getRevision(int revisionIndex) throws HgRuntimeException {
        return Nodeid.fromBinary(this.content.nodeid(revisionIndex), 0);
    }

    public final List<Nodeid> getRevisions(int ... revisions) throws HgRuntimeException {
        ArrayList<Nodeid> rv = new ArrayList<Nodeid>(revisions.length);
        Arrays.sort(revisions);
        this.getRevisionsInternal(rv, revisions);
        return rv;
    }

    void getRevisionsInternal(final List<Nodeid> retVal, int[] sortedRevs) throws HgRuntimeException {
        this.content.iterate(sortedRevs, false, new RevlogStream.Inspector(){

            @Override
            public void next(int revisionNumber, int actualLen, int baseRevision, int linkRevision, int parent1Revision, int parent2Revision, byte[] nodeid, DataAccess data) {
                retVal.add(Nodeid.fromBinary(nodeid, 0));
            }
        });
    }

    public final int getRevisionIndex(Nodeid nid) throws HgRuntimeException {
        int revision = this.doFindWithCache(nid);
        if (revision == Integer.MIN_VALUE) {
            throw new HgInvalidRevisionException(String.format("Can't find revision %s in %s", nid.shortNotation(), this), nid, null);
        }
        return revision;
    }

    private int doFindWithCache(Nodeid nid) throws HgRuntimeException {
        if (this.useRevisionLookup) {
            if (this.revisionLookup == null || this.content.shallDropDerivedCaches()) {
                this.content.detach(this.revisionLookupCleaner);
                this.setRevisionLookup(RevisionLookup.createFor(this.content));
            }
            return this.revisionLookup.findIndex(nid);
        }
        return this.content.findRevisionIndex(nid);
    }

    protected void setRevisionLookup(RevisionLookup rl) {
        assert (rl != null);
        this.revisionLookup = rl;
        this.content.attach(this.revisionLookupCleaner);
    }

    public final boolean isKnown(Nodeid nodeid) throws HgRuntimeException {
        int rn = this.doFindWithCache(nodeid);
        if (Integer.MIN_VALUE == rn) {
            return false;
        }
        if (rn < 0 || rn >= this.content.revisionCount()) {
            throw new HgInvalidStateException(String.format("Revision index %d found for nodeid %s is not from the range [0..%d]", rn, nodeid.shortNotation(), this.content.revisionCount() - 1));
        }
        return true;
    }

    protected void rawContent(Nodeid nodeid, ByteChannel sink) throws CancelledException, HgRuntimeException {
        this.rawContent(this.getRevisionIndex(nodeid), sink);
    }

    protected void rawContent(int revisionIndex, ByteChannel sink) throws CancelledException, HgRuntimeException {
        if (sink == null) {
            throw new IllegalArgumentException();
        }
        try {
            ContentPipe insp = new ContentPipe(sink, 0, this.repo.getSessionContext().getLog());
            insp.checkCancelled();
            this.content.iterate(revisionIndex, revisionIndex, true, insp);
            insp.checkFailed();
        }
        catch (IOException ex) {
            HgInvalidControlFileException e = new HgInvalidControlFileException(String.format("Access to revision %d content failed", revisionIndex), ex, null);
            e.setRevisionIndex(revisionIndex);
            throw e;
        }
        catch (HgInvalidControlFileException ex) {
            throw ex.isRevisionIndexSet() ? ex : ex.setRevisionIndex(revisionIndex);
        }
    }

    public void parents(int revision, int[] parentRevisions, byte[] parent1, byte[] parent2) throws HgRuntimeException, IllegalArgumentException {
        if (revision != -3 && (revision < 0 || revision >= this.content.revisionCount())) {
            throw new HgInvalidRevisionException(revision);
        }
        if (parentRevisions == null || parentRevisions.length < 2) {
            throw new IllegalArgumentException(String.valueOf(parentRevisions));
        }
        if (parent1 != null && parent1.length < 20) {
            throw new IllegalArgumentException(parent1.toString());
        }
        if (parent2 != null && parent2.length < 20) {
            throw new IllegalArgumentException(parent2.toString());
        }
        class ParentCollector
        implements RevlogStream.Inspector {
            public int p1 = -1;
            public int p2 = -1;
            public byte[] nodeid;

            ParentCollector() {
            }

            @Override
            public void next(int revisionNumber, int actualLen, int baseRevision, int linkRevision, int parent1Revision, int parent2Revision, byte[] nodeid, DataAccess da) {
                this.p1 = parent1Revision;
                this.p2 = parent2Revision;
                this.nodeid = new byte[20];
                System.arraycopy(nodeid, nodeid.length > 20 ? nodeid.length - 20 : 0, this.nodeid, 0, 20);
            }
        }
        ParentCollector pc = new ParentCollector();
        this.content.iterate(revision, revision, false, pc);
        parentRevisions[0] = pc.p1 == -1 ? -1 : pc.p1;
        int n = parentRevisions[1] = pc.p2 == -1 ? -1 : pc.p2;
        if (parent1 != null) {
            if (parentRevisions[0] == -1) {
                Arrays.fill(parent1, 0, 20, (byte)0);
            } else {
                this.content.iterate(parentRevisions[0], parentRevisions[0], false, pc);
                System.arraycopy(pc.nodeid, 0, parent1, 0, 20);
            }
        }
        if (parent2 != null) {
            if (parentRevisions[1] == -1) {
                Arrays.fill(parent2, 0, 20, (byte)0);
            } else {
                this.content.iterate(parentRevisions[1], parentRevisions[1], false, pc);
                System.arraycopy(pc.nodeid, 0, parent2, 0, 20);
            }
        }
    }

    public final void indexWalk(int start, int end, Inspector inspector) throws HgRuntimeException {
        RevlogDelegate head;
        int _start;
        int lastRev = this.getLastRevision();
        int n = _start = start == -3 ? lastRev : start;
        if (end == -3) {
            end = lastRev;
        }
        RevisionInspector revisionInsp = Adaptable.Factory.getAdapter(inspector, RevisionInspector.class, null);
        ParentInspector parentInsp = Adaptable.Factory.getAdapter(inspector, ParentInspector.class, null);
        LinkRevisionInspector linkRevInspector = Adaptable.Factory.getAdapter(inspector, LinkRevisionInspector.class, null);
        ParentDelegate parentDelegate = head = parentInsp == null ? null : new ParentDelegate(parentInsp, null, _start, end);
        if (revisionInsp != null) {
            head = new RevisionDelegate(revisionInsp, head);
        }
        if (linkRevInspector != null) {
            head = new LinkRevDelegate(linkRevInspector, head);
        }
        assert (head != null);
        head.walk(this.getRepo(), this.content, _start, end);
    }

    protected HgParentChildMap<? extends Revlog> getParentWalker() throws HgRuntimeException {
        HgParentChildMap<Revlog> pw = new HgParentChildMap<Revlog>(this);
        pw.init();
        return pw;
    }

    protected static class ContentPipe
    extends ErrorHandlingInspector
    implements RevlogStream.Inspector,
    CancelSupport {
        private final ByteChannel sink;
        private final int offset;
        private final LogFacility logFacility;

        public ContentPipe(ByteChannel _sink, int seekOffset, LogFacility log) {
            assert (_sink != null);
            this.sink = _sink;
            this.setCancelSupport(CancelSupport.Factory.get(_sink));
            this.offset = seekOffset;
            this.logFacility = log;
        }

        protected void prepare(int revisionNumber, DataAccess da) throws IOException {
            if (this.offset > 0) {
                da.seek(this.offset);
            }
        }

        @Override
        public void next(int revisionNumber, int actualLen, int baseRevision, int linkRevision, int parent1Revision, int parent2Revision, byte[] nodeid, DataAccess da) {
            try {
                this.prepare(revisionNumber, da);
                ProgressSupport progressSupport = ProgressSupport.Factory.get(this.sink);
                ByteBuffer buf = ByteBuffer.allocate(actualLen > 8192 ? 8192 : actualLen);
                Preview p = Adaptable.Factory.getAdapter(this.sink, Preview.class, null);
                if (p != null) {
                    progressSupport.start(2 * da.length());
                    while (!da.isEmpty()) {
                        this.checkCancelled();
                        da.readBytes(buf);
                        p.preview(buf);
                        buf.clear();
                    }
                    da.reset();
                    this.prepare(revisionNumber, da);
                    progressSupport.worked(da.length());
                    buf.clear();
                } else {
                    progressSupport.start(da.length());
                }
                while (!da.isEmpty()) {
                    this.checkCancelled();
                    da.readBytes(buf);
                    buf.flip();
                    int consumed = this.sink.write(buf);
                    if ((consumed == 0 || consumed != buf.position()) && this.logFacility != null) {
                        this.logFacility.dump(this.getClass(), LogFacility.Severity.Warn, "Bad data sink when reading revision %d. Reported %d bytes consumed, byt actually read %d", revisionNumber, consumed, buf.position());
                    }
                    if (buf.position() == 0) {
                        throw new HgInvalidStateException("Bad sink implementation (consumes no bytes) results in endless loop");
                    }
                    buf.compact();
                    progressSupport.worked(consumed);
                }
                progressSupport.done();
            }
            catch (IOException ex) {
                this.recordFailure(ex);
            }
            catch (CancelledException ex) {
                this.recordFailure(ex);
            }
        }
    }

    protected static abstract class ErrorHandlingInspector
    implements RevlogStream.Inspector,
    CancelSupport {
        private Exception failure;
        private CancelSupport cancelSupport;

        protected ErrorHandlingInspector() {
        }

        protected void setCancelSupport(CancelSupport cs) {
            assert (this.cancelSupport == null);
            this.cancelSupport = cs;
        }

        protected void recordFailure(Exception ex) {
            assert (this.failure == null);
            this.failure = ex;
        }

        public void checkFailed() throws HgRuntimeException, IOException, CancelledException {
            if (this.failure == null) {
                return;
            }
            if (this.failure instanceof IOException) {
                throw (IOException)this.failure;
            }
            if (this.failure instanceof CancelledException) {
                throw (CancelledException)this.failure;
            }
            if (this.failure instanceof HgRuntimeException) {
                throw (HgRuntimeException)this.failure;
            }
            throw new HgInvalidStateException(this.failure.toString());
        }

        @Override
        public void checkCancelled() throws CancelledException {
            if (this.cancelSupport != null) {
                this.cancelSupport.checkCancelled();
            }
        }
    }

    public static interface Inspector {
    }

    private static final class LinkRevDelegate
    extends RevlogDelegate {
        private final LinkRevisionInspector insp;

        public LinkRevDelegate(LinkRevisionInspector inspector, RevlogDelegate next) {
            super(next);
            assert (inspector != null);
            this.insp = inspector;
        }

        @Override
        public void next(int revisionIndex, int actualLen, int baseRevision, int linkRevision, int parent1Revision, int parent2Revision, byte[] nodeid, DataAccess data) throws HgRuntimeException {
            this.insp.next(revisionIndex, linkRevision);
            super.next(revisionIndex, actualLen, baseRevision, linkRevision, parent1Revision, parent2Revision, nodeid, data);
        }
    }

    public static interface LinkRevisionInspector
    extends Inspector {
        public void next(int var1, int var2) throws HgRuntimeException;
    }

    private static class ParentDelegate
    extends RevlogDelegate {
        private final ParentInspector insp;
        private int i = 0;
        private final Nodeid[] allRevisions;
        private final int[] firstParentIndexes;
        private final int[] secondParentIndexes;
        private final IntMap<Nodeid> missingParents;
        private final int start;

        public ParentDelegate(ParentInspector inspector, RevlogDelegate next, int _start, int end) {
            super(next);
            this.insp = inspector;
            this.start = _start;
            this.allRevisions = new Nodeid[end - _start + 1];
            this.firstParentIndexes = _start == 0 ? null : new int[this.allRevisions.length];
            this.secondParentIndexes = _start == 0 ? null : new int[this.allRevisions.length];
            this.missingParents = _start == 0 ? null : new IntMap(16);
        }

        @Override
        public void next(int revisionIndex, int actualLen, int baseRevision, int linkRevision, int parent1RevIndex, int parent2RevIndex, byte[] nodeid, DataAccess data) throws HgRuntimeException {
            this.allRevisions[this.i] = this.getRevision(nodeid);
            if (this.start > 0) {
                this.firstParentIndexes[this.i] = parent1RevIndex;
                this.secondParentIndexes[this.i] = parent2RevIndex;
                if (parent1RevIndex < this.start && parent1RevIndex >= 0) {
                    this.missingParents.put(parent1RevIndex, null);
                }
                if (parent2RevIndex < this.start && parent2RevIndex >= 0) {
                    this.missingParents.put(parent2RevIndex, null);
                }
            } else {
                Nodeid p1 = parent1RevIndex == -1 ? Nodeid.NULL : this.allRevisions[parent1RevIndex];
                Nodeid p2 = parent2RevIndex == -1 ? Nodeid.NULL : this.allRevisions[parent2RevIndex];
                this.insp.next(revisionIndex, this.allRevisions[this.i], parent1RevIndex, parent2RevIndex, p1, p2);
            }
            ++this.i;
            super.next(revisionIndex, actualLen, baseRevision, linkRevision, parent1RevIndex, parent2RevIndex, nodeid, data);
        }

        @Override
        protected void postWalk(HgRepository hgRepo) {
            if (this.start > 0) {
                this.complete(hgRepo);
            }
            super.postWalk(hgRepo);
        }

        private void complete(HgRepository repo) {
            if (this.missingParents.size() > 0) {
                int k = this.missingParents.firstKey();
                int l = this.missingParents.lastKey();
                while (k <= l) {
                    if (this.missingParents.containsKey(k)) {
                        Nodeid nid = repo.getChangelog().getRevision(k);
                        this.missingParents.put(k, nid);
                    }
                    ++k;
                }
            }
            int i = 0;
            int revNum = this.start;
            while (i < this.allRevisions.length) {
                Nodeid p2;
                int riP1 = this.firstParentIndexes[i];
                int riP2 = this.secondParentIndexes[i];
                Nodeid p1 = p2 = Nodeid.NULL;
                if (riP1 >= this.start) {
                    p1 = this.allRevisions[riP1 - this.start];
                } else if (riP1 != -1) {
                    assert (riP1 >= 0 && riP1 < this.start);
                    p1 = this.missingParents.get(riP1);
                    assert (p1 != null);
                }
                if (riP2 >= this.start) {
                    p2 = this.allRevisions[riP2 - this.start];
                } else if (riP2 != -1) {
                    assert (riP2 >= 0 && riP2 < this.start);
                    p2 = this.missingParents.get(riP2);
                    assert (p2 != null);
                }
                this.insp.next(revNum, this.allRevisions[i], riP1, riP2, p1, p2);
                ++i;
                ++revNum;
            }
        }
    }

    public static interface ParentInspector
    extends Inspector {
        public void next(int var1, Nodeid var2, int var3, int var4, Nodeid var5, Nodeid var6) throws HgRuntimeException;
    }

    private static final class RevisionDelegate
    extends RevlogDelegate {
        private final RevisionInspector insp;

        public RevisionDelegate(RevisionInspector inspector, RevlogDelegate next) {
            super(next);
            assert (inspector != null);
            this.insp = inspector;
        }

        @Override
        public void next(int revisionIndex, int actualLen, int baseRevision, int linkRevision, int parent1Revision, int parent2Revision, byte[] nodeid, DataAccess data) throws HgRuntimeException {
            Nodeid nid = this.getRevision(nodeid);
            this.insp.next(revisionIndex, nid, linkRevision);
            super.next(revisionIndex, actualLen, baseRevision, linkRevision, parent1Revision, parent2Revision, nodeid, data);
        }
    }

    public static interface RevisionInspector
    extends Inspector {
        public void next(int var1, Nodeid var2, int var3) throws HgRuntimeException;
    }
}

