/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.repo.ext;

import org.tmatesoft.hg.internal.Internals;
import org.tmatesoft.hg.repo.HgRepoConfig;
import org.tmatesoft.hg.repo.ext.MqManager;
import org.tmatesoft.hg.repo.ext.Rebase;

public abstract class HgExtensionsManager {
    private final Internals repo;
    private MqManager mqExt;
    private Rebase rebaseExt;

    protected HgExtensionsManager(Internals internalRepo) {
        this.repo = internalRepo;
    }

    public boolean isEnabled(HgExt e) {
        HgRepoConfig cfg = this.repo.getRepo().getConfiguration();
        return cfg.getExtensions().isEnabled(e.getNativeName());
    }

    public Rebase getRebaseExtension() {
        if (this.rebaseExt == null && this.isEnabled(HgExt.Rebase)) {
            this.rebaseExt = new Rebase(this.repo);
        }
        return this.rebaseExt;
    }

    public MqManager getMQ() {
        if (this.mqExt == null && this.isEnabled(HgExt.MQ)) {
            this.mqExt = new MqManager(this.repo);
        }
        return this.mqExt;
    }

    public static enum HgExt {
        MQ("mq"),
        Rebase("rebase");

        private final String mercurialExtName;

        private HgExt(String nativeName) {
            this.mercurialExtName = nativeName;
        }

        String getNativeName() {
            return this.mercurialExtName;
        }
    }
}

