/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.repo.ext;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.tmatesoft.hg.core.HgIOException;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.internal.Internals;
import org.tmatesoft.hg.internal.LineReader;
import org.tmatesoft.hg.repo.HgInvalidControlFileException;
import org.tmatesoft.hg.util.LogFacility;
import org.tmatesoft.hg.util.Path;

public class MqManager {
    private static final String PATCHES_DIR = "patches";
    private final Internals repo;
    private List<PatchRecord> applied = Collections.emptyList();
    private List<PatchRecord> allKnown = Collections.emptyList();
    private List<String> queueNames = Collections.emptyList();
    private String activeQueue = "patches";

    MqManager(Internals internalRepo) {
        this.repo = internalRepo;
    }

    public MqManager refresh() throws HgInvalidControlFileException {
        this.allKnown = Collections.emptyList();
        this.applied = this.allKnown;
        this.queueNames = Collections.emptyList();
        final LogFacility log = this.repo.getSessionContext().getLog();
        try {
            String queueLocation;
            File activeQueueFile;
            File queues = this.repo.getFileFromRepoDir("patches.queues");
            if (queues.isFile()) {
                LineReader lr = new LineReader(queues, log).trimLines(true).skipEmpty(true);
                this.queueNames = new LinkedList<String>();
                lr.read(new LineReader.SimpleLineCollector(), this.queueNames);
            }
            if ((activeQueueFile = this.repo.getFileFromRepoDir("patches.queue")).isFile()) {
                ArrayList contents = new ArrayList();
                new LineReader(activeQueueFile, log).read(new LineReader.SimpleLineCollector(), contents);
                if (contents.isEmpty()) {
                    log.dump(this.getClass(), LogFacility.Severity.Warn, "File %s with active queue name is empty", activeQueueFile.getName());
                    this.activeQueue = PATCHES_DIR;
                    queueLocation = "patches/";
                } else {
                    this.activeQueue = (String)contents.get(0);
                    queueLocation = "patches-" + this.activeQueue + '/';
                }
            } else {
                this.activeQueue = PATCHES_DIR;
                queueLocation = "patches/";
            }
            final Path.Source patchLocation = new Path.Source(){

                @Override
                public Path path(CharSequence p) {
                    StringBuilder sb = new StringBuilder(64);
                    sb.append(".hg/");
                    sb.append(queueLocation);
                    sb.append(p);
                    return Path.create(sb);
                }
            };
            final File fileStatus = this.repo.getFileFromRepoDir(String.valueOf(queueLocation) + "status");
            File fileSeries = this.repo.getFileFromRepoDir(String.valueOf(queueLocation) + "series");
            if (fileStatus.isFile()) {
                this.applied = new LinkedList<PatchRecord>();
                new LineReader(fileStatus, log).read(new LineReader.LineConsumer<List<PatchRecord>>(){

                    @Override
                    public boolean consume(String line, List<PatchRecord> result) throws IOException {
                        int sep = line.indexOf(58);
                        if (sep == -1) {
                            log.dump(MqManager.class, LogFacility.Severity.Warn, "Bad line in %s:%s", fileStatus.getPath(), line);
                            return true;
                        }
                        Nodeid nid = Nodeid.fromAscii(line.substring(0, sep));
                        String name = new String(line.substring(sep + 1));
                        result.add(new PatchRecord(nid, name, patchLocation.path(name)));
                        return true;
                    }
                }, this.applied);
            }
            if (fileSeries.isFile()) {
                HashMap<String, PatchRecord> name2patch = new HashMap<String, PatchRecord>();
                for (PatchRecord pr : this.applied) {
                    name2patch.put(pr.getName(), pr);
                }
                LinkedList knownPatchNames = new LinkedList();
                new LineReader(fileSeries, log).read(new LineReader.SimpleLineCollector(), knownPatchNames);
                this.allKnown = new ArrayList<PatchRecord>(knownPatchNames.size());
                for (String name : knownPatchNames) {
                    PatchRecord pr = (PatchRecord)name2patch.get(name);
                    if (pr == null) {
                        pr = new PatchRecord(null, name, patchLocation.path(name));
                    }
                    this.allKnown.add(pr);
                }
            }
        }
        catch (HgIOException ex) {
            throw new HgInvalidControlFileException(ex, true);
        }
        return this;
    }

    public int getQueueSize() {
        return this.getAllKnownPatches().size() - this.getAppliedPatches().size();
    }

    public List<PatchRecord> getAppliedPatches() {
        return Collections.unmodifiableList(this.applied);
    }

    public List<PatchRecord> getAllKnownPatches() {
        return Collections.unmodifiableList(this.allKnown);
    }

    public String getActiveQueueName() {
        return this.activeQueue;
    }

    public List<String> getQueueNames() {
        return Collections.unmodifiableList(this.queueNames);
    }

    public final class PatchRecord {
        private final Nodeid nodeid;
        private final String name;
        private final Path location;

        PatchRecord(Nodeid revision, String name, Path diffLocation) {
            this.nodeid = revision;
            this.name = name;
            this.location = diffLocation;
        }

        public Nodeid getRevision() {
            return this.nodeid;
        }

        public String getName() {
            return this.name;
        }

        public Path getPatchLocation() {
            return this.location;
        }

        public String toString() {
            String fmt = "mq.PatchRecord[name:%s; %spath:%s]";
            String ni = this.nodeid != null ? String.format("applied as: %s; ", this.nodeid.shortNotation()) : "";
            return String.format(fmt, this.name, ni, this.location);
        }
    }
}

