/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.repo.ext;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.tmatesoft.hg.core.HgBadNodeidFormatException;
import org.tmatesoft.hg.core.HgIOException;
import org.tmatesoft.hg.core.Nodeid;
import org.tmatesoft.hg.internal.Internals;
import org.tmatesoft.hg.internal.LineReader;
import org.tmatesoft.hg.repo.HgInvalidStateException;

public class Rebase {
    private Internals repo;
    private Nodeid workingDirParent;
    private Nodeid destRevision;
    private Nodeid externalParent;
    private Map<Nodeid, Nodeid> state;
    private boolean collapse;
    private boolean keepOriginalRevisions;
    private boolean keepBranchNames;

    Rebase(Internals internalRepo) {
        this.repo = internalRepo;
    }

    public Rebase refresh() throws HgIOException {
        this.workingDirParent = null;
        this.destRevision = null;
        this.externalParent = null;
        this.state = null;
        File f = this.repo.getFileFromRepoDir("rebasestate");
        if (!f.exists()) {
            return this;
        }
        this.state = new HashMap<Nodeid, Nodeid>();
        try {
            LineReader lr = new LineReader(f, this.repo.getSessionContext().getLog());
            ArrayList contents = new ArrayList();
            lr.read(new LineReader.SimpleLineCollector(), contents);
            Iterator it = contents.iterator();
            this.workingDirParent = Nodeid.fromAscii((String)it.next());
            this.destRevision = Nodeid.fromAscii((String)it.next());
            this.externalParent = Nodeid.fromAscii((String)it.next());
            this.collapse = "1".equals(it.next());
            this.keepOriginalRevisions = "1".equals(it.next());
            this.keepBranchNames = "1".equals(it.next());
            while (it.hasNext()) {
                String line = (String)it.next();
                int x = line.indexOf(58);
                if (x == -1) {
                    throw new HgInvalidStateException(line);
                }
                Nodeid oldRev = Nodeid.fromAscii(line.substring(0, x));
                Nodeid newRev = line.regionMatches(x + 1, "-2", 0, "-2".length()) ? null : Nodeid.fromAscii(line.substring(x + 1));
                this.state.put(oldRev, newRev);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new HgIOException("Bad format of rebase state file", f);
        }
        catch (HgBadNodeidFormatException ex) {
            throw new HgIOException("Bad format of rebase state file", ex, f);
        }
        return this;
    }

    public boolean isRebaseInProgress() {
        return this.state != null;
    }

    public Nodeid getWorkingDirParent() {
        assert (this.isRebaseInProgress());
        return this.workingDirParent;
    }

    public Nodeid getTarget() {
        assert (this.isRebaseInProgress());
        return this.destRevision;
    }

    public Nodeid getExternalParent() {
        assert (this.isRebaseInProgress());
        assert (this.collapse);
        return this.externalParent;
    }

    public boolean isCollapse() {
        return this.collapse;
    }

    public boolean isKeepOriginalRevisions() {
        return this.keepOriginalRevisions;
    }

    public boolean isKeepBranchNames() {
        return this.keepBranchNames;
    }
}

