/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.util;

public class DirectHashSet<T> {
    private Object[] table;
    private int size;
    private int threshold;

    public DirectHashSet() {
        this(16);
    }

    public DirectHashSet(int capacity) {
        int result = 2;
        while (result < capacity) {
            result <<= 1;
        }
        this.table = new Object[result];
        this.threshold = result - (result >>> 2);
    }

    public T put(T o) {
        Object t;
        int h = DirectHashSet.hash(o);
        int mask = this.table.length - 1;
        int i = h & mask;
        while ((t = this.table[i]) != null) {
            if (t.equals(o)) {
                this.table[i] = o;
                return (T)t;
            }
            i = i + 1 & mask;
        }
        this.table[i] = o;
        if (++this.size >= this.threshold) {
            this.resize();
        }
        return null;
    }

    public T get(T o) {
        Object t;
        int h = DirectHashSet.hash(o);
        int mask = this.table.length - 1;
        int i = h & mask;
        while ((t = this.table[i]) != null) {
            if (t == o || t.equals(o)) {
                return (T)t;
            }
            i = i + 1 & mask;
        }
        return null;
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        Object[] t = this.table;
        int i = 0;
        int top = t.length;
        while (i < top) {
            t[i] = null;
            ++i;
        }
        this.size = 0;
    }

    private void resize() {
        int newSize = this.table.length << 1;
        int newMask = newSize - 1;
        Object[] newTable = new Object[newSize];
        int i = 0;
        int size = this.table.length;
        while (i < size) {
            Object t = this.table[i];
            if (t != null) {
                this.table[i] = null;
                int x = DirectHashSet.hash(t) & newMask;
                while (newTable[x] != null) {
                    x = x + 1 & newMask;
                }
                newTable[x] = t;
            }
            ++i;
        }
        this.table = newTable;
        this.threshold = newSize - (newSize >>> 2);
    }

    private static int hash(Object o) {
        int h = o.hashCode();
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }
}

