/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.util;

import java.io.File;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.tmatesoft.hg.core.SessionContext;
import org.tmatesoft.hg.internal.Internals;
import org.tmatesoft.hg.util.FileInfo;
import org.tmatesoft.hg.util.FileIterator;
import org.tmatesoft.hg.util.Path;
import org.tmatesoft.hg.util.RegularFileInfo;

public class FileWalker
implements FileIterator {
    private final File startDir;
    private final Path.Source pathHelper;
    private final LinkedList<File> dirQueue;
    private final LinkedList<File> fileQueue;
    private final Path.Matcher scope;
    private final boolean execCap;
    private final boolean linkCap;
    private final SessionContext sessionContext;
    private RegularFileInfo nextFile;
    private Path nextPath;

    public FileWalker(SessionContext ctx, File dir, Path.Source pathFactory) {
        this(ctx, dir, pathFactory, null);
    }

    public FileWalker(SessionContext.Source ctxSource, File dir, Path.Source pathFactory, Path.Matcher scopeMatcher) {
        this(ctxSource.getSessionContext(), dir, pathFactory, scopeMatcher);
    }

    public FileWalker(SessionContext ctx, File dir, Path.Source pathFactory, Path.Matcher scopeMatcher) {
        this.sessionContext = ctx;
        this.startDir = dir;
        this.pathHelper = pathFactory;
        this.dirQueue = new LinkedList();
        this.fileQueue = new LinkedList();
        this.scope = scopeMatcher;
        this.execCap = Internals.checkSupportsExecutables(this.startDir);
        this.linkCap = Internals.checkSupportsSymlinks(this.startDir);
        this.reset();
    }

    @Override
    public void reset() {
        this.fileQueue.clear();
        this.dirQueue.clear();
        this.dirQueue.add(this.startDir);
        this.nextFile = new RegularFileInfo(this.sessionContext, this.supportsExecFlag(), this.supportsLinkFlag());
        this.nextPath = null;
    }

    @Override
    public boolean hasNext() {
        return this.fill();
    }

    @Override
    public void next() {
        if (!this.fill()) {
            throw new NoSuchElementException();
        }
        File next = this.fileQueue.removeFirst();
        this.nextFile.init(next);
        this.nextPath = this.pathHelper.path(next.getPath());
    }

    @Override
    public Path name() {
        return this.nextPath;
    }

    @Override
    public FileInfo file() {
        return this.nextFile;
    }

    @Override
    public boolean inScope(Path file) {
        return this.scope == null ? true : this.scope.accept(file);
    }

    @Override
    public boolean supportsExecFlag() {
        return this.execCap;
    }

    @Override
    public boolean supportsLinkFlag() {
        return this.linkCap;
    }

    private File[] listFiles(File f) {
        File[] rv = f.listFiles();
        return rv == null ? new File[]{} : rv;
    }

    private boolean fill() {
        while (this.fileQueue.isEmpty()) {
            if (this.dirQueue.isEmpty()) {
                return false;
            }
            if (this.dirQueue.isEmpty()) continue;
            File dir = this.dirQueue.removeFirst();
            File[] fileArray = this.listFiles(dir);
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                boolean isDir = f.isDirectory();
                Path path = this.pathHelper.path(isDir ? FileWalker.ensureTrailingSlash(f.getPath()) : f.getPath());
                if (this.inScope(path)) {
                    if (isDir) {
                        if (!".hg".equals(f.getName()) && !new File(f, ".hg").isDirectory()) {
                            this.dirQueue.addLast(f);
                        }
                    } else {
                        this.fileQueue.addLast(f);
                    }
                }
                ++n2;
            }
        }
        return !this.fileQueue.isEmpty();
    }

    private static String ensureTrailingSlash(String dirName) {
        if (dirName.length() > 0) {
            char last = dirName.charAt(dirName.length() - 1);
            if (last == '/' || last == File.separatorChar) {
                return dirName;
            }
            return dirName.indexOf(File.separatorChar) != -1 ? dirName.concat(File.separator) : dirName.concat("/");
        }
        return dirName;
    }
}

