/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.tmatesoft.hg.internal.Internals;
import org.tmatesoft.hg.util.Convertor;
import org.tmatesoft.hg.util.PathRewrite;

public final class Path
implements CharSequence,
Comparable<Path> {
    private String path;
    private static final boolean runningOnWindows = Internals.runningOnWindows();

    Path(String p) {
        this.path = p;
    }

    public boolean isDirectory() {
        return this.path.charAt(this.path.length() - 1) == '/';
    }

    @Override
    public int length() {
        return this.path.length();
    }

    @Override
    public char charAt(int index) {
        return this.path.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.path.substring(start, end);
    }

    @Override
    public String toString() {
        return this.path;
    }

    public Iterable<String> segments() {
        class SegSeq
        implements Iterable<String>,
        Iterator<String> {
            private int pos;

            SegSeq() {
            }

            @Override
            public Iterator<String> iterator() {
                this.reset();
                return this;
            }

            @Override
            public boolean hasNext() {
                return this.pos < Path.this.path.length();
            }

            @Override
            public String next() {
                if (this.pos >= Path.this.path.length()) {
                    throw new NoSuchElementException();
                }
                int x = Path.this.path.indexOf(47, this.pos);
                if (x == -1) {
                    String rv = Path.this.path.substring(this.pos);
                    this.pos = Path.this.path.length();
                    return rv;
                }
                String rv = Path.this.path.substring(this.pos, x);
                this.pos = x + 1;
                return rv;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void reset() {
                this.pos = 0;
            }
        }
        return new SegSeq();
    }

    @Override
    public int compareTo(Path o) {
        return this.path.compareTo(o.path);
    }

    public boolean equals(Object obj) {
        if (obj != null && this.getClass() == obj.getClass()) {
            return this == obj || this.path.equals(((Path)obj).path);
        }
        return false;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public CompareResult compareWith(Path another) {
        if (another == null) {
            return CompareResult.Unrelated;
        }
        if (another == this || another.length() == this.length() && this.equals(another)) {
            return CompareResult.Same;
        }
        if (another.isDirectory() && this.path.startsWith(another.path)) {
            return Path.isOneSegmentDifference(this.path, another.path) ? CompareResult.ImmediateChild : CompareResult.Nested;
        }
        if (this.isDirectory() && another.path.startsWith(this.path)) {
            return Path.isOneSegmentDifference(another.path, this.path) ? CompareResult.ImmediateParent : CompareResult.Parent;
        }
        return CompareResult.Unrelated;
    }

    private static boolean isOneSegmentDifference(String p1, String p2) {
        assert (p1.startsWith(p2));
        String p1Tail = p1.substring(p2.length());
        int slashLoc = p1Tail.indexOf(47);
        return slashLoc == -1 || slashLoc == p1Tail.length() - 1;
    }

    public static Path create(CharSequence path) {
        if (path == null) {
            throw new IllegalArgumentException();
        }
        if (path instanceof Path) {
            Path o = (Path)path;
            return o;
        }
        String p = path.toString();
        if (runningOnWindows && p.indexOf(92) != -1) {
            throw new IllegalArgumentException(String.format("Path '%s' contains illegal char at %d", p, p.indexOf(92)));
        }
        Path rv = new Path(p);
        return rv;
    }

    public static enum CompareResult {
        Same,
        Unrelated,
        ImmediateChild,
        Nested,
        ImmediateParent,
        Parent;

    }

    public static interface Matcher {
        public boolean accept(Path var1);

        public static final class Any
        implements Matcher {
            @Override
            public boolean accept(Path path) {
                return true;
            }
        }

        public static class Composite
        implements Matcher {
            private final Matcher[] elements;

            public Composite(Collection<Matcher> matchers) {
                this.elements = matchers.toArray(new Matcher[matchers.size()]);
            }

            @Override
            public boolean accept(Path path) {
                Matcher[] matcherArray = this.elements;
                int n = this.elements.length;
                int n2 = 0;
                while (n2 < n) {
                    Matcher m = matcherArray[n2];
                    if (m.accept(path)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        }
    }

    public static class SimpleSource
    implements Source {
        private final PathRewrite normalizer;
        private final Convertor<Path> convertor;

        public SimpleSource() {
            this(new PathRewrite.Empty(), null);
        }

        public SimpleSource(PathRewrite pathRewrite) {
            this(pathRewrite, null);
        }

        public SimpleSource(PathRewrite pathRewrite, Convertor<Path> pathConvertor) {
            this.normalizer = pathRewrite;
            this.convertor = pathConvertor;
        }

        @Override
        public Path path(CharSequence p) {
            Path rv = Path.create(this.normalizer.rewrite(p));
            if (this.convertor != null) {
                return this.convertor.mangle(rv);
            }
            return rv;
        }
    }

    public static interface Source {
        public Path path(CharSequence var1);
    }
}

