/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.util;

import org.tmatesoft.hg.util.Adaptable;

public interface ProgressSupport {
    public void start(int var1);

    public void worked(int var1);

    public void done();

    public static class Factory {
        public static ProgressSupport get(Object target) {
            ProgressSupport ps = Adaptable.Factory.getAdapter(target, ProgressSupport.class, null);
            if (ps != null) {
                return ps;
            }
            return new ProgressSupport(){

                @Override
                public void start(int totalUnits) {
                }

                @Override
                public void worked(int units) {
                }

                @Override
                public void done() {
                }
            };
        }
    }

    public static class Sub
    implements ProgressSupport {
        private int perChildWorkUnitMultiplier;
        private int perChildWorkUnitDivisor;
        private int unitsConsumed;
        private int fraction = 0;
        private final ProgressSupport ps;
        private final int psUnits;

        public Sub(ProgressSupport parent, int parentUnits) {
            if (parent == null) {
                throw new IllegalArgumentException();
            }
            this.ps = parent;
            this.psUnits = parentUnits;
        }

        @Override
        public void start(int totalUnits) {
            this.perChildWorkUnitDivisor = 10 * totalUnits;
            this.perChildWorkUnitMultiplier = this.psUnits * this.perChildWorkUnitDivisor / totalUnits;
        }

        @Override
        public void worked(int worked) {
            int x = this.fraction + worked * this.perChildWorkUnitMultiplier;
            int u = x / this.perChildWorkUnitDivisor;
            this.fraction = x % this.perChildWorkUnitDivisor;
            if (u > 0) {
                this.ps.worked(u);
                this.unitsConsumed += u;
            }
        }

        @Override
        public void done() {
            this.ps.worked(this.psUnits - this.unitsConsumed);
        }
    }

    public static interface Target<T> {
        public T set(ProgressSupport var1);
    }
}

