/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import org.tmatesoft.hg.core.SessionContext;
import org.tmatesoft.hg.internal.StreamLogFacility;
import org.tmatesoft.hg.util.FileInfo;
import org.tmatesoft.hg.util.LogFacility;
import org.tmatesoft.hg.util.RegularFileStats;

public class RegularFileInfo
implements FileInfo {
    private final boolean supportsExec;
    private final boolean supportsLink;
    private final RegularFileStats fileFlagsHelper;
    private File file;

    public RegularFileInfo(SessionContext ctx) {
        this(ctx, false, false);
    }

    public RegularFileInfo(SessionContext ctx, boolean supportExecFlag, boolean supportSymlink) {
        this.supportsLink = supportSymlink;
        this.supportsExec = supportExecFlag;
        this.fileFlagsHelper = supportSymlink || supportExecFlag ? new RegularFileStats(ctx) : null;
    }

    public void init(File f) {
        this.file = f;
        if (this.fileFlagsHelper != null) {
            this.fileFlagsHelper.init(this.file);
        }
    }

    @Override
    public boolean exists() {
        return this.isSymlink() || this.file.canRead() && this.file.isFile();
    }

    @Override
    public int lastModified() {
        return (int)(this.file.lastModified() / 1000L);
    }

    @Override
    public long length() {
        if (this.isSymlink()) {
            return this.getLinkTargetBytes().length;
        }
        return this.file.length();
    }

    @Override
    public ReadableByteChannel newInputChannel() {
        try {
            if (this.isSymlink()) {
                return new ByteArrayReadableChannel(this.getLinkTargetBytes());
            }
            return new FileInputStream(this.file).getChannel();
        }
        catch (FileNotFoundException ex) {
            StreamLogFacility.newDefault().dump(this.getClass(), LogFacility.Severity.Info, ex, null);
            return new ByteArrayReadableChannel(null);
        }
    }

    @Override
    public boolean isExecutable() {
        return this.supportsExec && this.fileFlagsHelper.isExecutable();
    }

    @Override
    public boolean isSymlink() {
        return this.supportsLink && this.fileFlagsHelper.isSymlink();
    }

    public String toString() {
        char t = this.exists() ? (this.isExecutable() ? (char)'*' : (this.isSymlink() ? (char)'@' : '-')) : (char)'!';
        return String.format("RegularFileInfo[%s %c]", this.file.getPath(), Character.valueOf(t));
    }

    private byte[] getLinkTargetBytes() {
        assert (this.isSymlink());
        return this.fileFlagsHelper.getSymlinkTarget().getBytes();
    }

    private static class ByteArrayReadableChannel
    implements ReadableByteChannel {
        private final byte[] data;
        private boolean closed = false;
        private int firstAvailIndex = 0;

        ByteArrayReadableChannel(byte[] dataToStream) {
            this.data = dataToStream;
        }

        @Override
        public boolean isOpen() {
            return !this.closed;
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            if (this.closed) {
                throw new ClosedChannelException();
            }
            int remainingBytes = this.data.length - this.firstAvailIndex;
            if (this.data == null || remainingBytes == 0) {
                return -1;
            }
            int x = Math.min(dst.remaining(), remainingBytes);
            int i = this.firstAvailIndex;
            int lim = this.firstAvailIndex + x;
            while (i < lim) {
                dst.put(this.data[i]);
                ++i;
            }
            this.firstAvailIndex += x;
            return x;
        }
    }
}

