/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.hg.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tmatesoft.hg.core.SessionContext;
import org.tmatesoft.hg.internal.Internals;
import org.tmatesoft.hg.internal.ProcessExecHelper;
import org.tmatesoft.hg.util.LogFacility;

class RegularFileStats {
    private boolean isExec;
    private boolean isSymlink;
    private String symlinkValue;
    private final List<String> command;
    private final ProcessExecHelper execHelper;
    private final Matcher linkMatcher;
    private final Matcher execMatcher;
    private final SessionContext sessionContext;
    private Map<String, Map<String, String>> dir2links = new TreeMap<String, Map<String, String>>();
    private Map<String, Set<String>> dir2execs = new TreeMap<String, Set<String>>();

    RegularFileStats(SessionContext ctx) {
        this.sessionContext = ctx;
        if (Internals.runningOnWindows()) {
            this.command = Arrays.asList("cmd", "/c", "dir");
            Pattern pLink = Pattern.compile("^\\S+.*\\s+<SYMLINK>\\s+(\\S.*)\\s+\\[(.+)\\]$", 8);
            Pattern pExec = Pattern.compile("^\\S+.*\\s+\\d+\\s+(\\S.*\\.exe)$", 8);
            this.linkMatcher = pLink.matcher("");
            this.execMatcher = pExec.matcher("");
        } else {
            this.command = Arrays.asList("/bin/ls", "-l", "-Q");
            Pattern pLink = Pattern.compile("^lrwxrwxrwx\\s.*\\s\"(.*)\"\\s+->\\s+\"(.*)\"$", 8);
            Pattern pExec = Pattern.compile("^-..[sx]..[sx]..[sx]\\s.*\\s\"(.+)\"$", 8);
            this.linkMatcher = pLink.matcher("");
            this.execMatcher = pExec.matcher("");
        }
        this.execHelper = new ProcessExecHelper();
    }

    public void init(File f) {
        this.isSymlink = false;
        this.isExec = false;
        this.symlinkValue = null;
        if (f.isDirectory()) {
            throw new IllegalArgumentException();
        }
        String dirName = f.getParentFile().getAbsolutePath();
        String fileName = f.getName();
        try {
            Map<String, String> links = this.dir2links.get(dirName);
            Set<String> execs = this.dir2execs.get(dirName);
            if (links == null || execs == null) {
                ArrayList<String> cmd = new ArrayList<String>(this.command);
                cmd.add(dirName);
                CharSequence result = this.execHelper.exec(cmd);
                if (this.execMatcher.reset(result).find()) {
                    execs = new HashSet<String>();
                    do {
                        execs.add(this.execMatcher.group(1));
                    } while (this.execMatcher.find());
                } else {
                    execs = Collections.emptySet();
                }
                if (this.linkMatcher.reset(result).find()) {
                    links = new HashMap<String, String>();
                    do {
                        links.put(this.linkMatcher.group(1), this.linkMatcher.group(2));
                    } while (this.linkMatcher.find());
                } else {
                    links = Collections.emptyMap();
                }
                this.dir2links.put(dirName, links);
                this.dir2execs.put(dirName, execs);
            }
            this.isExec = execs.contains(fileName);
            this.isSymlink = links.containsKey(fileName);
            this.symlinkValue = this.isSymlink ? links.get(fileName) : null;
        }
        catch (InterruptedException ex) {
            this.sessionContext.getLog().dump(this.getClass(), LogFacility.Severity.Warn, ex, String.format("Failed to detect flags for %s", f));
        }
        catch (IOException ex) {
            this.sessionContext.getLog().dump(this.getClass(), LogFacility.Severity.Warn, ex, String.format("Failed to detect flags for %s", f));
        }
    }

    public boolean isExecutable() {
        return this.isExec;
    }

    public boolean isSymlink() {
        return this.isSymlink;
    }

    public String getSymlinkTarget() {
        if (this.isSymlink) {
            return this.symlinkValue;
        }
        throw new UnsupportedOperationException();
    }
}

