/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.harmony.core.analysis;

import fr.labri.harmony.core.AbstractHarmonyService;
import fr.labri.harmony.core.analysis.Analysis;
import fr.labri.harmony.core.analysis.HasAnalysisConfiguration;
import fr.labri.harmony.core.analysis.PostProcessingAnalysis;
import fr.labri.harmony.core.config.model.AnalysisConfiguration;
import fr.labri.harmony.core.dao.Dao;
import fr.labri.harmony.core.log.HarmonyLogger;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class AnalysisFactory {
    static final String PROPERTY_DEPENDENCIES = "depends";
    static final String PROPERTY_PERSISTENCE_UNIT = "persistence-unit";
    private Dao dao;

    public AnalysisFactory(Dao dao) {
        this.dao = dao;
    }

    public Analysis createAnalysis(AnalysisConfiguration analysisConfig) {
        return this.createAnalysis(analysisConfig, Analysis.class);
    }

    public PostProcessingAnalysis createPostProcessingAnalysis(AnalysisConfiguration analysisConfig) {
        return this.createAnalysis(analysisConfig, PostProcessingAnalysis.class);
    }

    private <T extends HasAnalysisConfiguration> T createAnalysis(AnalysisConfiguration analysisConfig, Class<T> clazz) {
        try {
            BundleContext context = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
            Collection serviceReferences = context.getServiceReferences(clazz, AbstractHarmonyService.getFilter(analysisConfig.getAnalysisName()));
            if (serviceReferences != null && !serviceReferences.isEmpty()) {
                String dependencies;
                ServiceReference analysisReference = (ServiceReference)serviceReferences.iterator().next();
                if (serviceReferences.size() > 1) {
                    HarmonyLogger.info("Multiple implementations of the analysis" + analysisConfig.getAnalysisName() + "have been found. The first one has been selected");
                }
                if ((dependencies = (String)analysisReference.getProperty(PROPERTY_DEPENDENCIES)) != null) {
                    analysisConfig.setDependencies(Arrays.asList(dependencies.split(":")));
                }
                analysisConfig.setPersistenceUnit((String)analysisReference.getProperty(PROPERTY_PERSISTENCE_UNIT));
                HasAnalysisConfiguration analysis = (HasAnalysisConfiguration)((HasAnalysisConfiguration)context.getService(analysisReference)).getClass().getConstructor(AnalysisConfiguration.class, Dao.class, Properties.class).newInstance(analysisConfig, this.dao, this.extractProperties(analysisReference));
                return (T)analysis;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException | InvalidSyntaxException e) {
            e.printStackTrace();
        }
        HarmonyLogger.error("The analysis '" + analysisConfig.getAnalysisName() + "' could not be found. \n Either the associated bundle is not loaded or there is a typo in your configuration");
        return null;
    }

    private Properties extractProperties(ServiceReference<?> ref) {
        Properties properties = new Properties();
        String[] stringArray = ref.getPropertyKeys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            properties.put(key, ref.getProperty(key));
            ++n2;
        }
        return properties;
    }
}

