/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.harmony.core.config;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import fr.labri.harmony.core.config.model.AnalysisConfiguration;
import fr.labri.harmony.core.config.model.DatabaseConfiguration;
import fr.labri.harmony.core.config.model.FoldersConfiguration;
import fr.labri.harmony.core.config.model.SchedulerConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class GlobalConfigReader {
    private static final String DEFAULT_CONFIG_PATH = "configuration/fr.labri.harmony/default-global-config.json";
    private JsonNode globalConfig;
    private ObjectMapper mapper;

    public GlobalConfigReader(String path) throws IOException {
        if (path == null) {
            path = DEFAULT_CONFIG_PATH;
        }
        this.mapper = new ObjectMapper();
        this.globalConfig = this.mapper.readTree(new File(path));
    }

    public DatabaseConfiguration getDatabaseConfiguration() {
        JsonNode dbNode = this.globalConfig.get("database");
        if (dbNode != null) {
            try {
                return (DatabaseConfiguration)this.mapper.readValue(dbNode.toString(), DatabaseConfiguration.class);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return new DatabaseConfiguration();
    }

    public List<AnalysisConfiguration> getAnalysisConfigurations() {
        return this.getAnalysisConfigurations("source-analyses");
    }

    public List<AnalysisConfiguration> getPostProcessingAnalysisConfigurations() {
        return this.getAnalysisConfigurations("post-processing-analyses");
    }

    private List<AnalysisConfiguration> getAnalysisConfigurations(String jsonKey) {
        ArrayList<AnalysisConfiguration> configs = new ArrayList<AnalysisConfiguration>();
        ArrayNode n = (ArrayNode)this.globalConfig.get(jsonKey);
        if (n != null) {
            for (JsonNode c : n) {
                try {
                    AnalysisConfiguration config = (AnalysisConfiguration)this.mapper.readValue(c.toString(), AnalysisConfiguration.class);
                    config.setFoldersConfiguration(this.getFoldersConfig());
                    configs.add(config);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return configs;
    }

    public SchedulerConfiguration getSchedulerConfiguration() {
        JsonNode n = this.globalConfig.get("manage-create-sources");
        if (n == null) {
            n = this.globalConfig.get("scheduler");
        }
        try {
            return (SchedulerConfiguration)this.mapper.readValue(n.toString(), SchedulerConfiguration.class);
        }
        catch (Exception exception) {
            return new SchedulerConfiguration();
        }
    }

    public FoldersConfiguration getFoldersConfig() {
        if (this.globalConfig.has("folders")) {
            JsonNode n = this.globalConfig.get("folders");
            try {
                return (FoldersConfiguration)this.mapper.readValue(n.toString(), FoldersConfiguration.class);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return new FoldersConfiguration();
    }
}

