/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.harmony.core.config;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import fr.labri.harmony.core.config.GlobalConfigReader;
import fr.labri.harmony.core.config.model.SourceConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SourceConfigReader {
    private static final String DEFAULT_CONFIG_PATH = "configuration/fr.labri.harmony/default-source-config.json";
    private ArrayNode sourceConfig;
    private GlobalConfigReader global;
    private ObjectMapper mapper;
    private String configurationFileName;

    public SourceConfigReader(String path, GlobalConfigReader global) throws IOException {
        if (path == null) {
            path = DEFAULT_CONFIG_PATH;
        }
        this.global = global;
        this.mapper = new ObjectMapper();
        File configFile = new File(path);
        this.configurationFileName = configFile.getName();
        this.sourceConfig = (ArrayNode)this.mapper.readTree(configFile);
    }

    public List<SourceConfiguration> getSourcesConfigurations() {
        ArrayList<SourceConfiguration> configs = new ArrayList<SourceConfiguration>();
        for (JsonNode c : this.sourceConfig) {
            try {
                SourceConfiguration config = (SourceConfiguration)this.mapper.readValue(c.toString(), SourceConfiguration.class);
                config.setFoldersConfiguration(this.global.getFoldersConfig());
                config.setConfigurationFileName(this.configurationFileName);
                configs.add(config);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return configs;
    }
}

