/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.harmony.core.config.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

public class DatabaseConfiguration {
    private static final String DEFAULT_URL = "jdbc:h2:tmp";
    private static final String DEFAULT_USER = "SA";
    private static final String DEFAULT_PASSWORD = "";
    private static final String DEFAULT_DRIVER = "org.h2.Driver";
    private HashMap<String, String> properties = new HashMap();
    private boolean cleanDatabase = true;

    public DatabaseConfiguration() {
        this.setUrl(DEFAULT_URL);
        this.setDriver(DEFAULT_DRIVER);
        this.setUser(DEFAULT_USER);
        this.setPassword(DEFAULT_PASSWORD);
    }

    public DatabaseConfiguration(String url, String driver, String user) {
        this();
        this.setUrl(url);
        this.setUser(user);
        this.setDriver(driver);
    }

    public DatabaseConfiguration(String url, String driver, String user, String password, boolean cleanDatabase) {
        this(url, driver, user);
        this.setPassword(password);
        this.setCleanDatabase(cleanDatabase);
    }

    public DatabaseConfiguration(DatabaseConfiguration other) {
        this(other.getUrl(), other.getDriver(), other.getUser(), other.getPassword(), other.cleanDatabase());
    }

    public String getUrl() {
        return this.properties.get("javax.persistence.jdbc.url");
    }

    @JsonProperty(value="url")
    public void setUrl(String url) {
        this.properties.put("javax.persistence.jdbc.url", url);
    }

    public String getUser() {
        return this.properties.get("javax.persistence.jdbc.user");
    }

    @JsonProperty(value="user")
    public void setUser(String user) {
        this.properties.put("javax.persistence.jdbc.user", user);
    }

    public String getPassword() {
        return this.properties.get("javax.persistence.jdbc.password");
    }

    @JsonProperty(value="password")
    public void setPassword(String password) {
        this.properties.put("javax.persistence.jdbc.password", password);
    }

    public String getDriver() {
        return this.properties.get("javax.persistence.jdbc.driver");
    }

    @JsonProperty(value="driver")
    public void setDriver(String driver) {
        this.properties.put("javax.persistence.jdbc.driver", driver);
    }

    @JsonIgnore
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @JsonProperty(value="clean-database")
    public boolean cleanDatabase() {
        return this.cleanDatabase;
    }

    public void setCleanDatabase(boolean cleanDatabase) {
        this.cleanDatabase = cleanDatabase;
        if (cleanDatabase) {
            this.properties.put("eclipselink.ddl-generation", "drop-and-create-tables");
        } else {
            this.properties.put("eclipselink.ddl-generation", "create-tables");
        }
    }
}

