/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.harmony.core.dao;

import fr.labri.harmony.core.AbstractHarmonyService;
import fr.labri.harmony.core.dao.HarmonyEntityManagerFactory;
import fr.labri.harmony.core.model.Source;
import fr.labri.harmony.core.model.SourceElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.TypedQuery;

public abstract class AbstractDao {
    public static final String HARMONY_PERSISTENCE_UNIT = "harmony";
    protected Map<String, HarmonyEntityManagerFactory> entityManagerFactories;

    AbstractDao(Map<String, HarmonyEntityManagerFactory> entityManagerFactories) {
        this.entityManagerFactories = entityManagerFactories;
    }

    public Map<String, HarmonyEntityManagerFactory> getEntityManagerFactories() {
        return this.entityManagerFactories;
    }

    public EntityManager getEntityManager(String a) {
        HarmonyEntityManagerFactory f = this.entityManagerFactories.get(a);
        if (f == null) {
            return null;
        }
        return f.createEntityManager();
    }

    public EntityManager getEntityManager() {
        return this.getEntityManager(HARMONY_PERSISTENCE_UNIT);
    }

    public synchronized HarmonyEntityManagerFactory getEntityManagerFactory(AbstractHarmonyService harmonyService) {
        String puName = harmonyService == null ? HARMONY_PERSISTENCE_UNIT : harmonyService.getPersitenceUnitName();
        return this.entityManagerFactories.get(puName);
    }

    protected <E> void save(Collection<E> elements) {
        EntityManager m = this.getEntityManager();
        if (!m.getTransaction().isActive()) {
            m.getTransaction().begin();
        }
        for (E e : elements) {
            m.persist(e);
        }
        m.getTransaction().commit();
        m.close();
    }

    protected <E extends SourceElement> E get(Class<E> clazz, Source s, String nativeId) {
        EntityManager m = this.getEntityManager();
        m.getTransaction().begin();
        String sQuery = "SELECT e FROM " + clazz.getSimpleName() + " e WHERE e.source.id = :sourceId AND e.nativeId = :nativeId";
        TypedQuery query = m.createQuery(sQuery, clazz);
        query.setParameter("sourceId", (Object)s.getId());
        query.setParameter("nativeId", (Object)nativeId).setMaxResults(1);
        SourceElement result = null;
        try {
            result = (SourceElement)query.getSingleResult();
        }
        catch (NoResultException noResultException) {}
        m.getTransaction().commit();
        return (E)result;
    }

    protected <E extends SourceElement> List<E> getList(Class<E> clazz, Source s) {
        EntityManager m = this.getEntityManager();
        String sQuery = "SELECT e FROM " + clazz.getSimpleName() + " e WHERE e.source.id = :sourceId AND e.nativeId = :nativeId";
        TypedQuery query = m.createQuery(sQuery, clazz);
        query.setParameter("sourceId", (Object)s.getId());
        try {
            return query.getResultList();
        }
        catch (NoResultException noResultException) {
            return new ArrayList();
        }
    }

    protected <T> T refreshElement(T element) {
        EntityManager m = this.getEntityManager();
        m.getTransaction().begin();
        element = m.merge(element);
        m.refresh(element);
        m.getTransaction().commit();
        return element;
    }

    protected <E> void save(E e) {
        EntityManager m = this.getEntityManager();
        m.getTransaction().begin();
        m.persist(e);
        m.getTransaction().commit();
        m.close();
    }

    protected <E> void update(E e) {
        EntityManager m = this.getEntityManager();
        m.getTransaction().begin();
        m.merge(e);
        m.getTransaction().commit();
        m.close();
    }
}

