/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.harmony.core.dao;

import fr.labri.harmony.core.dao.AbstractDao;
import fr.labri.harmony.core.dao.DataMappingObject;
import fr.labri.harmony.core.dao.HarmonyEntityManagerFactory;
import fr.labri.harmony.core.log.HarmonyLogger;
import fr.labri.harmony.core.model.Action;
import fr.labri.harmony.core.model.ActionKind;
import fr.labri.harmony.core.model.Author;
import fr.labri.harmony.core.model.Event;
import fr.labri.harmony.core.model.HarmonyModelElement;
import fr.labri.harmony.core.model.Item;
import fr.labri.harmony.core.model.Source;
import fr.labri.harmony.core.source.Workspace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public class Dao
extends AbstractDao {
    Dao(Map<String, HarmonyEntityManagerFactory> entityManagerFactories) {
        super(entityManagerFactories);
    }

    public Event getEvent(Source s, String nativeId) {
        return this.get(Event.class, s, nativeId);
    }

    public List<Event> getEvents(Source source) {
        String queryString = "SELECT e FROM Event e WHERE e.source = :source ORDER BY e.timestamp ASC";
        EntityManager em = this.getEntityManager();
        em.getTransaction().begin();
        TypedQuery query = em.createQuery(queryString, Event.class);
        query.setParameter("source", (Object)source);
        List events = query.getResultList();
        em.getTransaction().commit();
        return events;
    }

    public Event getNextEvent(Item item, Date date) {
        EntityManager em = this.getEntityManager();
        String queryString = "SELECT e FROM Event e, Action a WHERE a.item = :item AND a MEMBER OF e.actions AND e.timestamp > :date ORDER BY e.timestamp";
        TypedQuery query = em.createQuery(queryString, Event.class).setMaxResults(1);
        query.setParameter("item", (Object)item).setParameter("date", (Object)date.getTime());
        try {
            return (Event)query.getSingleResult();
        }
        catch (NoResultException noResultException) {
            return null;
        }
    }

    public Event getEventWithTag(Source src, String tag) {
        String queryString = "SELECT e FROM Event e WHERE e.source = :source AND :tag MEMBER OF e.tags";
        TypedQuery query = this.getEntityManager().createQuery(queryString, Event.class);
        query.setParameter("source", (Object)src).setParameter("tag", (Object)tag).setMaxResults(1);
        try {
            return (Event)query.getSingleResult();
        }
        catch (NoResultException noResultException) {
            return null;
        }
    }

    public Event getPreviousEvent(Item item, Date date) {
        EntityManager em = this.getEntityManager();
        String queryString = "SELECT e FROM Event e, Action a WHERE a.item = :item AND a MEMBER OF e.actions AND e.timestamp <= :date ORDER BY e.timestamp DESC";
        TypedQuery query = em.createQuery(queryString, Event.class).setMaxResults(1);
        query.setParameter("item", (Object)item).setParameter("date", (Object)date.getTime());
        try {
            return (Event)query.getSingleResult();
        }
        catch (NoResultException noResultException) {
            return null;
        }
    }

    public List<Item> getItems(Event event) {
        EntityManager em = this.getEntityManager();
        String queryString = "SELECT DISTINCT a.item FROM Event e, Action a JOIN a.item i WHERE e = :event AND a MEMBER OF e.actions";
        TypedQuery query = em.createQuery(queryString, Item.class);
        query.setParameter("event", (Object)event);
        try {
            return query.getResultList();
        }
        catch (NoResultException noResultException) {
            return new ArrayList<Item>();
        }
    }

    public List<Item> getItems(Source src, Date date) {
        EntityManager em = this.getEntityManager();
        String queryString = "SELECT i FROM Item i WHERE i.source = :source AND NOT EXISTS  (SELECT 'found' FROM Action a JOIN a.event e WHERE a.item = i AND a.kind = :createKind AND e.timestamp = (SELECT MIN(e.timestamp) FROM Event e, Action a WHERE a.item = i AND a MEMBER OF e.actions AND e.timestamp > :date)) AND NOT EXISTS  (SELECT 'found' FROM Action a JOIN a.event e WHERE a.item = i AND a.kind = :deleteKind AND e.timestamp = (SELECT MAX(e.timestamp) FROM Event e, Action a WHERE a.item = i AND a MEMBER OF e.actions AND e.timestamp < :date))";
        TypedQuery query = em.createQuery(queryString, Item.class);
        query.setParameter("source", (Object)src).setParameter("date", (Object)date.getTime()).setParameter("createKind", (Object)ActionKind.Create).setParameter("deleteKind", (Object)ActionKind.Delete);
        try {
            return query.getResultList();
        }
        catch (NoResultException noResultException) {
            return new ArrayList<Item>();
        }
    }

    public Item getItem(Source s, String nativeId) {
        return this.get(Item.class, s, nativeId);
    }

    public List<Action> getActions(Source s) {
        return this.getList(Action.class, s);
    }

    public List<Action> getActions(Item item) {
        List<Action> actions = new ArrayList<Action>();
        EntityManager m = this.getEntityManager();
        m.getTransaction().begin();
        try {
            try {
                String stringQuery = "SELECT a FROM Action a JOIN a.event e WHERE a.item = :item ORDER BY e.timestamp";
                TypedQuery q = m.createQuery(stringQuery, Action.class);
                q.setParameter("item", (Object)item);
                actions = q.getResultList();
            }
            catch (Exception e) {
                HarmonyLogger.error(e.getMessage());
                m.getTransaction().commit();
                m.close();
            }
        }
        finally {
            m.getTransaction().commit();
            m.close();
        }
        return actions;
    }

    public List<Action> getActions(Item item, Date fromDate, Date toDate) {
        EntityManager em = this.getEntityManager();
        String stringQuery = "SELECT a FROM Action a JOIN a.item i JOIN a.event e WHERE i = :item ";
        if (fromDate != null) {
            stringQuery = String.valueOf(stringQuery) + " AND e.timestamp >= :fromDate ";
        }
        if (toDate != null) {
            stringQuery = String.valueOf(stringQuery) + " AND e.timestamp <= :toDate ";
        }
        stringQuery = String.valueOf(stringQuery) + "ORDER BY e.timestamp";
        TypedQuery query = em.createQuery(stringQuery, Action.class);
        query.setParameter("item", (Object)item);
        if (fromDate != null) {
            query.setParameter("fromDate", (Object)fromDate.getTime());
        }
        if (toDate != null) {
            query.setParameter("toDate", (Object)toDate.getTime());
        }
        try {
            return query.getResultList();
        }
        catch (NoResultException noResultException) {
            return new ArrayList<Action>();
        }
    }

    public Action getCreateAction(Item item) {
        EntityManager m = this.getEntityManager();
        String stringQuery = "SELECT a FROM Action a JOIN a.event e WHERE a.item = :item AND a.kind = :createKind";
        TypedQuery q = m.createQuery(stringQuery, Action.class);
        q.setParameter("item", (Object)item);
        q.setParameter("createKind", (Object)ActionKind.Create);
        try {
            return (Action)q.getSingleResult();
        }
        catch (NoResultException noResultException) {
            return null;
        }
    }

    public Action getDeleteAction(Item item) {
        EntityManager m = this.getEntityManager();
        String stringQuery = "SELECT a FROM Action a JOIN a.event e WHERE a.item = :item AND a.kind = :deleteKind";
        TypedQuery q = m.createQuery(stringQuery, Action.class);
        q.setParameter("item", (Object)item);
        q.setParameter("deleteKind", (Object)ActionKind.Delete);
        try {
            return (Action)q.getSingleResult();
        }
        catch (NoResultException noResultException) {
            return null;
        }
    }

    public Author getAuthor(Source s, String nativeId) {
        return this.get(Author.class, s, nativeId);
    }

    public List<Author> getAuthors(Item item) {
        EntityManager m = this.getEntityManager();
        String queryString = "SELECT DISTINCT auth FROM Author auth, Event e, Action act WHERE act.item = :item AND act MEMBER OF e.actions AND auth MEMBER OF e.authors";
        TypedQuery query = m.createQuery(queryString, Author.class);
        query.setParameter("item", (Object)item);
        return query.getResultList();
    }

    public List<Author> getAuthors(Item item, Date fromDate, Date toDate) {
        EntityManager m = this.getEntityManager();
        String queryString = "SELECT DISTINCT auth FROM Author auth, Event e, Action act WHERE act.item = :item AND act MEMBER OF e.actions AND auth MEMBER OF e.authors AND e.timestamp > :fromDate AND e.timestamp < e.toDate";
        TypedQuery query = m.createQuery(queryString, Author.class);
        query.setParameter("item", (Object)item);
        query.setParameter("fromDate", (Object)fromDate.getTime());
        query.setParameter("toDate", (Object)toDate.getTime());
        return query.getResultList();
    }

    public <D> List<D> getData(String database, Class<D> dataClass, HarmonyModelElement harmonyModelElement) {
        List<Integer> dataIds = this.getDataIds(database, dataClass, harmonyModelElement);
        EntityManager dataEntityManager = this.getEntityManager(database);
        ArrayList<Object> dataList = new ArrayList<Object>();
        for (Integer dataId : dataIds) {
            dataList.add(dataEntityManager.find(dataClass, (Object)dataId));
        }
        return dataList;
    }

    public List<Integer> getDataIds(String database, Class<?> dataClass, HarmonyModelElement harmonyModelElement) {
        EntityManager coreEntityManager = this.getEntityManager();
        String queryString = "SELECT dmo.dataId FROM " + DataMappingObject.class.getSimpleName() + " dmo WHERE dmo.elementId = :elementId " + "AND dmo.elementType = :elementType AND dmo.databaseName = :databaseName AND dmo.dataClassSimpleName = :dataClass";
        TypedQuery query = coreEntityManager.createQuery(queryString, Integer.class);
        query.setParameter("elementId", (Object)harmonyModelElement.getId());
        query.setParameter("elementType", (Object)harmonyModelElement.getClass().getSimpleName());
        query.setParameter("databaseName", (Object)database);
        query.setParameter("dataClass", (Object)dataClass.getSimpleName());
        try {
            return query.getResultList();
        }
        catch (NoResultException noResultException) {
            return new ArrayList<Integer>();
        }
    }

    public <D> List<D> getData(String database, Class<D> dataClass) {
        EntityManager m = this.getEntityManager(database);
        String sQuery = "SELECT d FROM " + dataClass.getSimpleName() + " d";
        TypedQuery query = m.createQuery(sQuery, dataClass);
        List results = query.getResultList();
        return results;
    }

    public void saveData(String database, Object data, HarmonyModelElement harmonyModelElement) {
        EntityManager dataEntityManager = this.getEntityManager(database);
        dataEntityManager.getTransaction().begin();
        dataEntityManager.persist(data);
        dataEntityManager.getTransaction().commit();
        int dataId = (Integer)((HarmonyEntityManagerFactory)this.entityManagerFactories.get(database)).getPersistenceUnitUtil().getIdentifier(data);
        DataMappingObject dmo = new DataMappingObject(database, data.getClass().getSimpleName(), dataId, harmonyModelElement.getId(), harmonyModelElement.getClass().getSimpleName());
        this.save(dmo);
    }

    public void updateData(String database, Object data) {
        EntityManager dataEntityManager = this.getEntityManager(database);
        dataEntityManager.getTransaction().begin();
        try {
            dataEntityManager.persist(dataEntityManager.merge(data));
            dataEntityManager.getTransaction().commit();
        }
        catch (Exception exception) {
            dataEntityManager.getTransaction().rollback();
        }
    }

    public Source getSource(int id) {
        EntityManager m = this.getEntityManager();
        m.getTransaction().begin();
        Source result = (Source)m.find(Source.class, (Object)id);
        m.getTransaction().commit();
        return result;
    }

    public Source getSourceByUrl(String url) {
        EntityManager m = this.getEntityManager();
        m.getTransaction().begin();
        try {
            CriteriaBuilder cb = m.getCriteriaBuilder();
            CriteriaQuery cq = cb.createQuery(Source.class);
            Root src = cq.from(Source.class);
            cq.select((Selection)src);
            cq.where((Expression)cb.equal((Expression)src.get("url"), (Object)url));
            TypedQuery q = m.createQuery(cq).setMaxResults(1);
            Source source = (Source)q.getSingleResult();
            m.getTransaction().commit();
            return source;
        }
        catch (NoResultException noResultException) {
            m.getTransaction().rollback();
            return null;
        }
    }

    public Source reloadSource(Source source) {
        Workspace ws = source.getWorkspace();
        EntityManager m = this.getEntityManager();
        m.getTransaction().begin();
        source = (Source)m.find(Source.class, (Object)source.getId());
        m.getTransaction().commit();
        source.setWorkspace(ws);
        return source;
    }

    public void saveSource(Source s) {
        this.save(s);
    }

    public void saveEvent(Event e) {
        this.save(e);
    }

    public void saveItem(Item i) {
        this.save(i);
    }

    public void saveAuthor(Author a) {
        this.save(a);
    }

    public void saveAction(Action a) {
        this.save(a);
    }

    public void saveEvents(Collection<Event> events) {
        this.save(events);
    }

    public void saveAuthors(Collection<Author> authors) {
        this.save(authors);
    }

    public void saveActions(Collection<Action> actions) {
        this.save(actions);
    }

    public void saveItems(Collection<Item> items) {
        this.save(items);
    }

    public void updateAction(Action a) {
        this.update(a);
    }
}

