/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.harmony.core.dao;

import fr.labri.harmony.core.config.model.DatabaseConfiguration;
import fr.labri.harmony.core.dao.Dao;
import fr.labri.harmony.core.dao.HarmonyEntityManagerFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.jpa.EntityManagerFactoryBuilder;

public class DaoFactory {
    private Map<String, HarmonyEntityManagerFactory> entityManagerFactories;

    public DaoFactory(DatabaseConfiguration config) {
        BundleContext context = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        try {
            Collection refs = context.getServiceReferences(EntityManagerFactoryBuilder.class, null);
            this.entityManagerFactories = new HashMap<String, HarmonyEntityManagerFactory>();
            for (ServiceReference ref : refs) {
                String name = (String)ref.getProperty("osgi.unit.name");
                HarmonyEntityManagerFactory factory = new HarmonyEntityManagerFactory(config, (ServiceReference<EntityManagerFactoryBuilder>)ref, context);
                this.entityManagerFactories.put(name, factory);
            }
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
    }

    public Dao createDao() {
        return new Dao(this.entityManagerFactories);
    }
}

