/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.harmony.core.dao;

import fr.labri.harmony.core.config.model.DatabaseConfiguration;
import fr.labri.harmony.core.log.HarmonyLogger;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.persistence.PersistenceUnitUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.jpa.EntityManagerFactoryBuilder;

public class HarmonyEntityManagerFactory {
    private DatabaseConfiguration config;
    private String databaseName;
    private String databaseUrl;
    private EntityManagerFactory factory;

    public HarmonyEntityManagerFactory(DatabaseConfiguration configuration, ServiceReference<EntityManagerFactoryBuilder> ref, BundleContext context) {
        this.config = new DatabaseConfiguration(configuration);
        this.databaseUrl = configuration.getUrl();
        this.databaseName = (String)ref.getProperty("osgi.unit.name");
        this.config.setUrl(String.valueOf(this.databaseUrl) + this.databaseName);
        EntityManagerFactoryBuilder b = (EntityManagerFactoryBuilder)context.getService(ref);
        this.factory = b.createEntityManagerFactory(this.config.getProperties());
    }

    public EntityManager createEntityManager() {
        EntityManager em = null;
        try {
            em = this.factory.createEntityManager();
        }
        catch (PersistenceException persistenceException) {
            this.createDatabase();
            em = this.factory.createEntityManager();
        }
        return em;
    }

    public PersistenceUnitUtil getPersistenceUnitUtil() {
        return this.factory.getPersistenceUnitUtil();
    }

    private void createDatabase() {
        try {
            Connection conn = DriverManager.getConnection(String.valueOf(this.databaseUrl) + "?user=" + this.config.getUser() + "&password=" + this.config.getPassword());
            Statement s = conn.createStatement();
            s.executeUpdate("CREATE DATABASE " + this.databaseName);
        }
        catch (SQLException e) {
            HarmonyLogger.error(e.getMessage());
        }
    }
}

