/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.harmony.core.execution;

import fr.labri.harmony.core.dao.Dao;
import fr.labri.harmony.core.dao.HarmonyEntityManagerFactory;
import fr.labri.harmony.core.execution.ExecutionReport;
import fr.labri.harmony.core.execution.SourceExecutionReport;
import fr.labri.harmony.core.execution.ThreadTimes;
import fr.labri.harmony.core.log.HarmonyLogger;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;

public class ExecutionMonitor {
    private HarmonyEntityManagerFactory emf;
    private ThreadTimes tt;

    public ExecutionMonitor(Dao dao) {
        this.emf = dao.getEntityManagerFactory(null);
        this.tt = new ThreadTimes(100L);
    }

    public int initMonitoring() {
        ExecutionReport report = new ExecutionReport();
        report.setExecutionDate(new Date());
        EntityManager em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)report);
        em.getTransaction().commit();
        em.close();
        this.tt.start();
        return report.getId();
    }

    public void stopMonitoring(int executionReportId) {
        this.tt.interrupt();
        EntityManager em = this.emf.createEntityManager();
        em.getTransaction().begin();
        ExecutionReport report = (ExecutionReport)em.find(ExecutionReport.class, (Object)executionReportId);
        report.setTotalSystemTimeMillis(this.tt.getTotalSystemTime() / 1000000L);
        report.setTotalUserTimeMillis(this.tt.getTotalUserTime() / 1000000L);
        em.persist((Object)report);
        em.getTransaction().commit();
    }

    public void addSourceExecutionReport(int executionReportId, SourceExecutionReport sourceExecutionReport) {
        EntityManager em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)sourceExecutionReport);
        ExecutionReport report = (ExecutionReport)em.find(ExecutionReport.class, (Object)executionReportId);
        report.add(sourceExecutionReport);
        em.persist((Object)report);
        em.getTransaction().commit();
    }

    public void printExecutionReport(int executionReportId) {
        EntityManager em = this.emf.createEntityManager();
        em.getTransaction().begin();
        ExecutionReport report = (ExecutionReport)em.find(ExecutionReport.class, (Object)executionReportId);
        em.getTransaction().commit();
        HashMap<String, String> executionErrors = new HashMap<String, String>();
        double totalTimeMilis = 0.0;
        for (SourceExecutionReport sourceExecutionReport : report.getSourceExecutionReports()) {
            if (sourceExecutionReport.isExecutedWithoutError()) {
                totalTimeMilis += (double)sourceExecutionReport.getExecutionTimeMillis();
                continue;
            }
            executionErrors.put(sourceExecutionReport.getSourceUrl(), sourceExecutionReport.getStackTrace());
        }
        HarmonyLogger.info("Total execution time: " + totalTimeMilis / 1000.0 + "s");
        if (!executionErrors.isEmpty()) {
            HarmonyLogger.info(String.valueOf(executionErrors.size()) + " sources were analyzed with errors");
            HarmonyLogger.info("Stack Traces are available in the ErrorLog.txt file");
            try {
                FileWriter writer = new FileWriter(new File("ErrorLog.txt"));
                for (Map.Entry error : executionErrors.entrySet()) {
                    writer.write("Source Url: " + (String)error.getKey() + "\n\n" + (String)error.getValue() + "\n\n\n");
                }
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            HarmonyLogger.info("All analyses finished without error");
        }
    }
}

