/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.harmony.core.execution;

import java.io.PrintWriter;
import java.io.StringWriter;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;

@Entity
public class SourceExecutionReport {
    private static final int STACK_TRACE_LENGTH = 1000;
    @Id
    @GeneratedValue
    private int id;
    private String sourceUrl;
    private boolean executedWithoutError;
    @Column(length=1000)
    private String stackTrace;
    private long executionTimeMillis;

    public String getSourceUrl() {
        return this.sourceUrl;
    }

    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    public boolean isExecutedWithoutError() {
        return this.executedWithoutError;
    }

    public void setExecutedWithoutError(boolean executedWithoutError) {
        this.executedWithoutError = executedWithoutError;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public long getExecutionTimeMillis() {
        return this.executionTimeMillis;
    }

    public void setExecutionTimeMillis(long executionTimeMillis) {
        this.executionTimeMillis = executionTimeMillis;
    }

    public void setException(Throwable e) {
        this.stackTrace = this.getStackTrace(e);
        if (this.stackTrace.length() > 1000) {
            this.stackTrace = this.stackTrace.substring(0, 1000);
        }
    }

    private String getStackTrace(Throwable e) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        e.printStackTrace(printWriter);
        return ((Object)result).toString();
    }
}

