/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.harmony.core.execution;

import fr.labri.harmony.core.analysis.Analysis;
import fr.labri.harmony.core.analysis.AnalysisFactory;
import fr.labri.harmony.core.analysis.PostProcessingAnalysis;
import fr.labri.harmony.core.config.GlobalConfigReader;
import fr.labri.harmony.core.config.SourceConfigReader;
import fr.labri.harmony.core.config.model.AnalysisConfiguration;
import fr.labri.harmony.core.config.model.SchedulerConfiguration;
import fr.labri.harmony.core.config.model.SourceConfiguration;
import fr.labri.harmony.core.dao.Dao;
import fr.labri.harmony.core.dao.DaoFactory;
import fr.labri.harmony.core.execution.ExecutionMonitor;
import fr.labri.harmony.core.execution.SourceExecutionReport;
import fr.labri.harmony.core.log.HarmonyLogger;
import fr.labri.harmony.core.model.Source;
import fr.labri.harmony.core.source.SourceExtractor;
import fr.labri.harmony.core.source.SourceExtractorFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;

public class StudyScheduler {
    private static final int NUMBER_OF_EXECUTION_UNIT_AVAILABLE = Runtime.getRuntime().availableProcessors();
    private ExecutorService threadsPool;
    private SchedulerConfiguration schedulerConfiguration;
    private Dao dao;
    private int executionReportId;
    private ExecutionMonitor mainMonitor;

    public StudyScheduler(SchedulerConfiguration schedulerConfiguration) {
        this.schedulerConfiguration = schedulerConfiguration;
    }

    public void run(GlobalConfigReader global, SourceConfigReader sourceConfigReader) {
        try {
            FileUtils.forceMkdir((File)new File(global.getFoldersConfig().getOutFolder()));
            FileUtils.forceMkdir((File)new File(global.getFoldersConfig().getTmpFolder()));
        }
        catch (IOException e) {
            HarmonyLogger.error("An error occured while creating working folders");
            e.printStackTrace();
        }
        List<SourceConfiguration> sourceConfigurations = sourceConfigReader.getSourcesConfigurations();
        if (sourceConfigurations.isEmpty()) {
            HarmonyLogger.error("No source to analyze");
            return;
        }
        DaoFactory daoFactory = new DaoFactory(global.getDatabaseConfiguration());
        this.dao = daoFactory.createDao();
        if (this.schedulerConfiguration.getNumberOfThreads() > NUMBER_OF_EXECUTION_UNIT_AVAILABLE) {
            HarmonyLogger.info("You requested more threads than the number of execution unit (core) available, this choice might lead to lower execution performance");
        }
        this.threadsPool = Executors.newFixedThreadPool(this.schedulerConfiguration.getNumberOfThreads());
        SourceExtractorFactory sourceExtractorFactory = new SourceExtractorFactory(this.dao);
        this.mainMonitor = new ExecutionMonitor(this.dao);
        this.executionReportId = this.mainMonitor.initMonitoring();
        List<AnalysisConfiguration> analysisConfigurations = global.getAnalysisConfigurations();
        for (SourceConfiguration sourceConfiguration : sourceConfigurations) {
            this.launchSortedAnalysisOnSource(sourceExtractorFactory, sourceConfiguration, analysisConfigurations);
        }
        this.shutdownThreadsPool();
        this.mainMonitor.stopMonitoring(this.executionReportId);
        this.mainMonitor.printExecutionReport(this.executionReportId);
        Collection<Source> sources = this.getSources(sourceConfigurations);
        List<AnalysisConfiguration> postProcessingAnalysisConfigurations = global.getPostProcessingAnalysisConfigurations();
        AnalysisFactory analysisFactory = new AnalysisFactory(this.dao);
        for (AnalysisConfiguration analysisConfiguration : postProcessingAnalysisConfigurations) {
            PostProcessingAnalysis postProcessingAnalysis = analysisFactory.createPostProcessingAnalysis(analysisConfiguration);
            postProcessingAnalysis.runOn(sources);
        }
    }

    private Collection<Source> getSources(List<SourceConfiguration> sourceConfigurations) {
        ArrayList<Source> sources = new ArrayList<Source>();
        for (SourceConfiguration configuration : sourceConfigurations) {
            Source source = this.dao.getSourceByUrl(configuration.getRepositoryURL());
            if (source == null) continue;
            source.setConfig(configuration);
            sources.add(source);
        }
        return sources;
    }

    private void launchSortedAnalysisOnSource(final SourceExtractorFactory sourceExtractorFactory, final SourceConfiguration sourceConfiguration, final Collection<AnalysisConfiguration> analysesConfigurations) {
        this.threadsPool.execute(new Thread(){

            @Override
            public void run() {
                SourceExtractor<?> sourceExtractor = sourceExtractorFactory.createSourceExtractor(sourceConfiguration);
                if (sourceExtractor == null) {
                    HarmonyLogger.error("Could not load the source:" + sourceConfiguration.getRepositoryURL());
                    return;
                }
                String url = sourceExtractor.getConfig().getRepositoryURL();
                SourceExecutionReport executionReport = new SourceExecutionReport();
                executionReport.setSourceUrl(url);
                try {
                    try {
                        long startTime = System.currentTimeMillis();
                        Source src = StudyScheduler.this.dao.getSourceByUrl(url);
                        if (src != null) {
                            HarmonyLogger.info("Initializing existing source, extraction will not be performed again.");
                            sourceExtractor.initializeExistingSource(src);
                        } else if (analysesConfigurations.isEmpty()) {
                            sourceExtractor.initializeSource(true, true);
                        } else {
                            boolean extractActions = false;
                            boolean extractHarmonyModel = false;
                            for (AnalysisConfiguration a : analysesConfigurations) {
                                if (a == null) continue;
                                extractActions = a.requireActions() || extractActions;
                                boolean bl = extractHarmonyModel = a.requireHarmonyModel() || extractHarmonyModel;
                            }
                            sourceExtractor.initializeSource(extractHarmonyModel, extractActions);
                        }
                        AnalysisFactory analysisFactory = new AnalysisFactory(StudyScheduler.this.dao);
                        Iterator it = analysesConfigurations.iterator();
                        while (it.hasNext() && !this.isInterrupted()) {
                            Analysis currentAnalysis = analysisFactory.createAnalysis((AnalysisConfiguration)it.next());
                            HarmonyLogger.info("Running analysis " + currentAnalysis.getConfig().getAnalysisName() + " on source " + sourceExtractor.getSource().getUrl());
                            currentAnalysis.runOn(sourceExtractor.getSource());
                        }
                        long endTime = System.currentTimeMillis();
                        executionReport.setExecutionTimeMillis(endTime - startTime);
                        executionReport.setExecutedWithoutError(true);
                    }
                    catch (Exception e) {
                        executionReport.setExecutedWithoutError(false);
                        executionReport.setException(e);
                        e.printStackTrace();
                        ExecutionMonitor monitor = new ExecutionMonitor(StudyScheduler.this.dao);
                        monitor.addSourceExecutionReport(StudyScheduler.this.executionReportId, executionReport);
                    }
                }
                finally {
                    ExecutionMonitor monitor = new ExecutionMonitor(StudyScheduler.this.dao);
                    monitor.addSourceExecutionReport(StudyScheduler.this.executionReportId, executionReport);
                }
            }
        });
    }

    private void shutdownThreadsPool() {
        this.threadsPool.shutdown();
        try {
            if (!this.threadsPool.awaitTermination(this.schedulerConfiguration.getGlobalTimeOut(), TimeUnit.MINUTES)) {
                HarmonyLogger.error("Execution timeout, the pool of analysis threads will be shutdown (You may check your configuration file for running longer analysis)");
                this.threadsPool.shutdownNow();
                if (!this.threadsPool.awaitTermination(60L, TimeUnit.SECONDS)) {
                    HarmonyLogger.error("Harmony was not able to shutdown the pool of threads in charge of running your analyses");
                }
            } else {
                HarmonyLogger.info("Finished execution of analyses");
            }
        }
        catch (InterruptedException interruptedException) {
            this.threadsPool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

