/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.harmony.core.execution;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Collection;
import java.util.HashMap;

public final class ThreadTimes
extends Thread {
    private final long interval;
    private final long threadId;
    private final HashMap<Long, Times> history = new HashMap();

    public ThreadTimes(long interval) {
        super("Thread time monitor");
        this.interval = interval;
        this.threadId = this.getId();
        this.setDaemon(true);
    }

    @Override
    public void run() {
        while (!this.isInterrupted()) {
            this.update();
            try {
                ThreadTimes.sleep(this.interval);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
    }

    private void update() {
        long[] ids;
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        long[] lArray = ids = bean.getAllThreadIds();
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            long id = lArray[n2];
            if (id != this.threadId) {
                long c = bean.getThreadCpuTime(id);
                long u = bean.getThreadUserTime(id);
                if (c != -1L && u != -1L) {
                    Times times = this.history.get(id);
                    if (times == null) {
                        times = new Times();
                        times.id = id;
                        times.startCpuTime = c;
                        times.startUserTime = u;
                        times.endCpuTime = c;
                        times.endUserTime = u;
                        this.history.put(id, times);
                    } else {
                        times.endCpuTime = c;
                        times.endUserTime = u;
                    }
                }
            }
            ++n2;
        }
    }

    public long getTotalCpuTime() {
        Collection<Times> hist = this.history.values();
        long time = 0L;
        for (Times times : hist) {
            time += times.endCpuTime - times.startCpuTime;
        }
        return time;
    }

    public long getTotalUserTime() {
        Collection<Times> hist = this.history.values();
        long time = 0L;
        for (Times times : hist) {
            time += times.endUserTime - times.startUserTime;
        }
        return time;
    }

    public long getTotalSystemTime() {
        return this.getTotalCpuTime() - this.getTotalUserTime();
    }

    private class Times {
        private long id;
        public long startCpuTime;
        public long startUserTime;
        public long endCpuTime;
        public long endUserTime;

        private Times() {
        }
    }
}

